/*
 * ZerlegteAnweisung.cpp
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#include "ZerlegteAnweisung.h"

#include "Spiel.h"
#include "Raum.h"
#include "Gegenstand.h"
#include "Befehlsliste.h"
#include "Befehl.h"
#include "Stringfunktionen.h"
#include "spiel_const.h"
#include <iostream>

using namespace std;

ZerlegteAnweisung::ZerlegteAnweisung(Spiel* s, string anw)
: spiel(s), gueltig(true), objekt_anz(0), obj1_id(-1), obj2_id(-1) {

  vector<string> teile;

  anw=trim(lower_string(anw));

  unsigned int cmdend;
  if((cmdend = anw.find(" "))!=string::npos) {
    teile.push_back(anw.substr(0,cmdend));
    unsigned int trenner;
    if((trenner=anw.find(" + "))!=string::npos) {
      teile.push_back(trim(anw.substr(cmdend, trenner-cmdend+1)));
      teile.push_back(trim(anw.substr(trenner+3)));
    }
    else {
      teile.push_back(trim(anw.substr(cmdend)));
    }
  }
  else {
    teile.push_back(anw);
  }

  auto cmds = spiel->get_befehle();
  auto gegenstaende = spiel->get_gegenstaende();

  cmd_id = cmds->get_id_by_partial_name_match(teile[0]);
  if(cmd_id!=-1)
    cmd_txt=cmds->get_befehl_by_id(cmd_id)->get_name();
  else {
    cmd_txt=teile[0];
    gueltig=false;
    return;
  }

#ifdef FDEBUG
  if(cmd_id<0) {
    if(teile.size()>1) {
      obj1_txt=teile[1];
      obj1_id=-2;
      ++objekt_anz;
    }
    if(teile.size()>2) {
      obj2_txt=teile[2];
      obj2_id=-2;
      ++objekt_anz;
    }
    return;
  }
#endif

  if(teile.size()>1) {
    ++objekt_anz;
    if(cmd_id==Spiel::CMD_GEHE) {
      obj1_id=spiel->get_akt_raum()->get_ausgangid_by_partial_name_match(teile[1]);
    }
    else if(cmd_id==Spiel::CMD_SPEICHERN || cmd_id==Spiel::CMD_LADEN) {
      obj1_id=-2;
      obj1_txt=teile[1];
      return;
    }
    else {
      obj1_id=gegenstaende->get_gegenstandid_by_available_and_partial_name_match(teile[1]);
    }
    if(obj1_id>=0)
      obj1_txt=gegenstaende->get_gegenstand_by_id(obj1_id)->get_name();
    else if(obj1_id!=-2) {
      obj1_txt=teile[1];
      gueltig=false;
    }
  }

  if(teile.size()>2) {
    ++objekt_anz;
    string oname;
    if(teile.size()==3)
      oname=teile[2];
    else if(teile.size()>=4)
      oname=teile[3];

    obj2_id=gegenstaende->get_gegenstandid_by_available_and_partial_name_match(oname);
    if(obj2_id!=-1)
      obj2_txt=gegenstaende->get_gegenstand_by_id(obj2_id)->get_name();
    else {
      obj2_txt=oname;
      gueltig=false;
    }
  }

  Befehl* cmd = spiel->get_befehle()->get_befehl_by_id(cmd_id);
  if(objekt_anz!=cmd->get_benoetigte_objekt_anz())
    gueltig=false;


}

void ZerlegteAnweisung::schreibe_feedback() const {
  static vector<string> neg_cmd_txts {"Wie um alles in der Welt soll ich denn %?",
                                      "Mach mir % bitte erst einmal vor.",
                                      "Ich weiss nicht, was ich machen soll.",
                                      "Das habe ich nicht verstanden.",
                                      "Was ist das? Kann man % essen?"
                                     };
  static vector<string> neg_ort_txts {"Nach %? In welcher Richtung liegt das denn?",
                                      "Kannst du mir % mal auf der Karte zeigen.",
                                      "Nach % kannst du alleine gehen..",
                                      "Bis wir in % ankommen, ist es dunkel...",
                                      "In % waren wir doch eben erst."
                                     };
  static vector<string> neg_obj_txts {"Ich sehe hier nichts, was nach % aussieht",
                                      "Wo siehst du denn %? Wenn du die Augen schliesst?",
                                      "Ich will nicht wissen, wo du % gesehen hast.",
                                      "Schau dich um, % gibt es hier nicht, glaub mir.",
                                      "Vielleicht findest du % in einem anderen Spiel, hier nicht."
                                     };

  cout << "\n";
  if(gueltig) {
//    cout << "Ich habe verstanden: " << cmd_txt;
    cout << Spiel::convert_output(cmd_txt);
    if(objekt_anz>0)
      cout << " " << Spiel::convert_output(obj1_txt);
    if(objekt_anz==2)
      cout << " -> " << Spiel::convert_output(obj2_txt);
    cout << "\n";
  }
  else {
    if(cmd_id==-1) {
      Spiel::schreibe_zufallsreaktion(neg_cmd_txts, cmd_txt);
    }
    else {
      Befehl* cmd = spiel->get_befehle()->get_befehl_by_id(cmd_id);
      if(objekt_anz!=cmd->get_benoetigte_objekt_anz()) {
        if(cmd_id==Spiel::CMD_GEHE) {
          cout << "Bei "<<cmd_txt << " musst du genau eine Richtung angeben.";

        }
        else if(objekt_anz>cmd->get_benoetigte_objekt_anz()) {
          cout << "Fuer "<<cmd_txt << " hast du zu viele Gegenstaende angegeben.";
        }
        else if(objekt_anz<cmd->get_benoetigte_objekt_anz()) {
          cout << "Fuer "<<cmd_txt << " hast du nicht genug Gegenstaende angegeben.";
        }
      }
      else {
        if(objekt_anz>0 && obj1_id==-1) {
          if(cmd_id==Spiel::CMD_GEHE)
            Spiel::schreibe_zufallsreaktion(neg_ort_txts, obj1_txt);
          else
            Spiel::schreibe_zufallsreaktion(neg_obj_txts, obj1_txt);
        }
        else if(objekt_anz>1 && obj2_id==-1) {
          Spiel::schreibe_zufallsreaktion(neg_obj_txts, obj2_txt);
        }

      }

    }


  }

  cout << endl;

}

