/*
 * Trigger.cpp
 *
 *  Created on: 28.05.2014
 *      Author: Andr Willms
 */

#include "Trigger.h"

Trigger::Trigger(id_type c, id_type o1, id_type o2)
 : cmd(c), obj1(o1), obj2(o2) {

}

bool Trigger::ist_trigger(id_type c, id_type o1, id_type o2, bool sym) const {
  return (cmd==c && (
      (!sym && obj1==o1 && obj2==o2) ||
      (sym && ((obj1==o1 && obj2==o2) || (obj1==o2 && obj2==o1)))
    ));
}

void Trigger::xml_out(std::ostream& ostr) const {
  ostr << "<trigger cmd=\"" << cmd << "\"" ;
  if(obj1!=-1) ostr << " first=\"" << obj1 << "\"";
  if(obj2!=-1) ostr << " second=\"" << obj2 << "\"";
  ostr << " />\n";
}
