/*
 * Stringfunktionen.cpp
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#include "Stringfunktionen.h"


#include <cctype>
#include <sstream>
#include <cstdlib>
#include <iostream>

using namespace std;

string lower_string(string s) {
  for(unsigned int i=0; i<s.size(); ++i)
    s[i]=static_cast<char>(tolower(static_cast<int>(s[i])));
  return s;
}

vector<string> explode(const string& s, const string& separators) {

  vector<string> words;
  string::size_type en, be=0;

  do {
    en=s.find_first_of(separators, be);
    if(en==string::npos || en!=be) {
      words.push_back(s.substr(be, en-be));
    }

    be=s.find_first_not_of(separators, en);
  } while(be!=string::npos && be<s.size());

  return(words);
}


string text_layout(const string& s, unsigned int breite) {
  string erg;
  auto lines=explode(s, "\n");
  for(auto liter=lines.begin(); liter!=lines.end(); ++liter) {
    if(liter!=lines.begin())
      erg+="\n";

    auto words=explode(*liter, " \t");
    unsigned int laenge=0;
    for(auto witer=words.begin(); witer!=words.end(); ++witer) {
      if(laenge+witer->size() >= breite) {
        erg+="\n";
        laenge=0;
      }
      if(laenge!=0) {
        erg+=" ";
      }
      erg+=*witer;
      laenge+=witer->size()+1;
    }
  }
  return erg;
}


int stoi(const std::string& s) {
  return atoi(s.c_str());
}

bool stob(const std::string& s) {
  return atoi(s.c_str()) == 1;
}


string to_string(int i) {
  stringstream ss;
  ss << i;
  return ss.str();
}

string start_capitalized(string s) {
  s[0]=toupper(s[0]);
  return s;
}

void clear_screen() {
  for(int i=0; i<100; ++i) cout << "\n";
}

std::string separator_line(int anz) {
  return string(anz, '-');
}

std::string trim(const std::string& s, const std::string& ws) {
  int anf=0, end=s.size()-1;
  while(ws.find(s[anf])!=string::npos)
    ++anf;
  while(ws.find(s[end])!=string::npos)
    --end;

  return s.substr(anf, end-anf+1);
}

void show_char_values(const std::string& s) {
  for(auto iter=s.begin(); iter!=s.end(); ++iter) {
    if(iter!=s.begin())
      cout << ", ";
    cout << static_cast<int>(*iter);
  }

}


std::string to_dos(std::string s) {
  for(auto iter=s.begin(); iter!=s.end(); ++iter) {
    switch(*iter){
      case -28:
        *iter=-124;
        break;
      case -60:
        *iter=-114;
        break;
      case -10:
        *iter=-108;
        break;
      case -42:
        *iter=-103;
        break;
      case -4:
        *iter=-127;
        break;
      case -36:
        *iter=-102;
        break;
      case -33:
        *iter=-31;
        break;
    }
  }
  return s;
}

std::string from_dos(std::string s) {
  for(auto iter=s.begin(); iter!=s.end(); ++iter) {
    switch(*iter){
      case -124:
        *iter=-28;
        break;
      case -114:
        *iter=-60;
        break;
      case -108:
        *iter=-10;
        break;
      case -103:
        *iter=-42;
        break;
      case -127:
        *iter=-4;
        break;
      case -102:
        *iter=-36;
        break;
      case -31:
        *iter=-33;
        break;
    }
  }
  return s;
}
