/*
 * Spielregeln.h
 *
 *  Created on: 13.05.2014
 *      Author: Andr Willms
 */

#ifndef SPIELREGELN_H_
#define SPIELREGELN_H_

#include "Spielregel.h"

#include <memory>
#include <vector>

class Spielregelliste {
public:
  typedef std::unique_ptr<Spielregel> regel_ptr;

private:
      std::vector<regel_ptr> regeln;

public:
  Spielregelliste();
  virtual ~Spielregelliste() {
  }

  bool ausfuehren(id_type b, id_type o1, id_type o2);

  void add_regel(Spielregel* r) {
    regeln.push_back(regel_ptr(r));
  }

  unsigned int size() const {
    return regeln.size();
  }

  void xml_out(std::ostream& ostr) const;

};

#endif /* SPIELREGELN_H_ */
