/*
 * Spielregel.h
 *
 *  Created on: 13.05.2014
 *      Author: Andr Willms
 */

#ifndef SPIELREGEL_H_
#define SPIELREGEL_H_

#include "Spielobjekt.h"
#include "XMLObjekt.h"
#include "Bedingung.h"
#include "Aktion.h"

#include <vector>
#include <memory>
#include "Trigger.h"

class Spiel;

class Spielregel : public Spielobjekt, public XMLObjekt {
public:
  typedef std::unique_ptr<Bedingung> bedingung_ptr;
  typedef std::unique_ptr<Aktion> aktion_ptr;

private:
  std::vector<Trigger> trigger;
  std::vector<bedingung_ptr> bedingungen;
  std::vector<aktion_ptr> aktionen;
  bool symmetrie;   // true, wenn Objektreihenfolge egal (Verwende X mit Y oder Verwende Y mit X)

  bool single_action; // Bricht die Aktionsverarbeitung ab, sobald eine Aktion erfolgreich durchgefuehrt wurde

  bool ist_trigger(id_type c, id_type o1, id_type o2) const;

  bool pruefe_bedingungen() const;

  bool fuehre_aktionen_aus();

public:
  Spielregel(Spiel* spiel, id_type b, id_type o1=-1, id_type o2=-1, bool sym = false, bool single=false);
  virtual ~Spielregel() {
  }
  bool ausfuehren(id_type b, id_type o1, id_type o2);

  void add_bedingung(Bedingung* b) {
    bedingungen.push_back(bedingung_ptr(b));
  }
  void add_aktion(Aktion* b) {
    aktionen.push_back(aktion_ptr(b));
  }
  void add_trigger(id_type b, id_type o1, id_type o2) {
    trigger.push_back(Trigger(b,o1,o2));
  }

  virtual void xml_out(std::ostream& ostr) const;
};

#endif /* SPIELREGEL_H_ */
