/*
 * Spielregel.cpp
 *
 *  Created on: 13.05.2014
 *      Author: Andr Willms
 */

#include "Spielregel.h"
#include <iostream>
#include "Spiel.h"
#include "Gegenstand.h"

using namespace std;

Spielregel::Spielregel(Spiel* spiel, id_type b, id_type o1, id_type o2, bool sym, bool single)
  : Spielobjekt(spiel), symmetrie(sym), single_action(single) {

  add_trigger(b, o1, o2);
}

bool Spielregel::ist_trigger(id_type c, id_type o1, id_type o2) const {
  for(auto iter=trigger.begin(); iter!=trigger.end(); ++iter) {
    if(iter->ist_trigger(c, o1, o2, symmetrie))
/*
    if(iter->befehl==b && (
        (!symmetrie && iter->obj1==o1 && iter->obj2==o2) ||
        (symmetrie && ((iter->obj1==o1 && iter->obj2==o2) || (iter->obj1==o2 && iter->obj2==o1)))
      ))
*/
      return true;
  }
  return false;

}

bool Spielregel::pruefe_bedingungen() const {
  for(auto iter=bedingungen.begin(); iter!=bedingungen.end(); ++iter) {
    if(!(*iter)->pruefen())
      return false;
  }
  return true;
}

bool Spielregel::fuehre_aktionen_aus() {
  bool erfolg=false;
  for(auto iter=aktionen.begin(); iter!=aktionen.end(); ++iter) {
    if((*iter)->ausfuehren()) {
      if(single_action)
        return true;
      erfolg=true;
    }
  }
  return erfolg;
}

bool Spielregel::ausfuehren(id_type b, id_type o1, id_type o2) {
  if(!ist_trigger(b, o1, o2))
    return false;

  if(!pruefe_bedingungen())
    return false;

  return fuehre_aktionen_aus();
}

void Spielregel::xml_out(std::ostream& ostr) const {
  ostr << "<rule";
  if(symmetrie) ostr << " symmetry=\"symmetry\"";
  if(single_action) ostr << " oneaction=\"oneaction\"";
  ostr << " >\n";

  for(auto iter=trigger.begin(); iter!=trigger.end(); ++iter) {
    Trigger t = *iter;
    t.xml_out(ostr);
  }
  for(auto iter=bedingungen.begin(); iter!=bedingungen.end(); ++iter) {
    (*iter).get()->xml_out(ostr);
  }
  for(auto iter=aktionen.begin(); iter!=aktionen.end(); ++iter) {
    (*iter).get()->xml_out(ostr);
  }

  ostr << "</rule>\n";

}
