/*
 * SpielBauer.h
 *
 *  Created on: 28.05.2014
 *      Author: Andr Willms
 */

#ifndef SPIELBAUER_H_
#define SPIELBAUER_H_

#include "Spiel.h"

class SpielBauer : public Spiel {
public:
  static const int ST_TUER_VERSCHLOSSEN=0;
  static const int ST_TUER_GESCHLOSSEN=1;
  static const int ST_TUER_OFFEN=2;
  static const int ST_TUER_OFFENBLOCKIERT=3;

  static const int POS_EGAL=0;
  static const int POS_INVENTAR=1;
  static const int POS_RAUM=2;

protected:
  // Hilfsmethoden zur Weltenerzeugung

    void erzeuge_zweiweg_verbindung(id_type raum1, id_type raum2,
        id_type hinid, const std::string& hinname, bool hinsichtbar,
        id_type zurueckid, const std::string& zurueckname, bool zuruecksichtbar
                                   );
    void erzeuge_einweg_verbindung(id_type raum1, id_type raum2,
        id_type hinid, const std::string& hinname, bool hinsichtbar
                                   );

    void erzeuge_tuer(id_type raum1id, id_type raum2id, id_type exit1id, id_type exit2id,
                             id_type tuer1id, id_type tuer2id, int z,
                              const std::string& name1, const std::string& bez1,const std::string& otxt1,
                              const std::string& name2, const std::string& bez2,const std::string& otxt2,
                              const std::string& stxt, const std::string& blocktxt);

    void erzeuge_einseitige_tuer(id_type raumid, id_type exit1id, id_type exit2id,
                             id_type tuerid, int z,
                              const std::string& name1, const std::string& bez1,const std::string& otxt1,
                              const std::string& stxt, const std::string& blocktxt);

    void erzeuge_gegenstand(id_type id, id_type raum, bool fest, bool ablegbar, bool sichtbar,
                            const std::string& name, const std::string& bez, const std::string& beschr="", int z=0, int v1=0);

    Spielregel* erzeuge_nehmen(id_type id, int z, bool ins_inv, const std::string& text);
    void erzeuge_raum(id_type id, const std::string& name, const std::string& beschr);
    Spielregel* erzeuge_untersuchung(id_type id, int z, int pos, const std::string& beschr="");
    Spielregel* erzeuge_beschreibung(id_type id, int z, const std::string& beschr="");
    Spielregel* erzeuge_oeffnen(id_type id, int z, const std::string& beschr="");
    Spielregel* erzeuge_schliessen(id_type id, int z, const std::string& beschr="");
    Spielregel* erzeuge_benutzung(id_type id, int z, int pos, const std::string& beschr="");
    Spielregel* erzeuge_gehe(id_type id, const std::string& beschr="");
    Spielregel* erzeuge_druecken(id_type id, int z, int pos, const std::string& beschr="");
    Spielregel* erzeuge_ziehen(id_type id, int z, int pos, const std::string& beschr="");
    Spielregel* erzeuge_kombination(id_type id1, id_type id2, int z1, int z2, int pos1, int pos2, const std::string& beschr="");
public:
  SpielBauer();
  virtual ~SpielBauer() {

  }
};

#endif /* SPIELBAUER_H_ */
