/*
 * SpielBauer.cpp
 *
 *  Created on: 28.05.2014
 *      Author: Andr Willms
 */

#include "SpielBauer.h"
#include "Raum.h"
#include "Befehl.h"
#include "Gegenstand.h"
#include "Spielregel.h"
#include "Aktionen.h"
#include "Bedingungen.h"
#include "ZerlegteAnweisung.h"
#include "spiel_const.h"

SpielBauer::SpielBauer() {
}


// Hilfsmethoden zur Weltenerzeugung

  void SpielBauer::erzeuge_zweiweg_verbindung(id_type raum1, id_type raum2,
      id_type hinid, const std::string& hinname, bool hinsichtbar,
      id_type zurueckid, const std::string& zurueckname, bool zuruecksichtbar
                                 ) {
    Raum* r1 = get_raeume()->get_raum_by_id(raum1);
    Raum* r2 = get_raeume()->get_raum_by_id(raum2);
    Spielregel* tmpregel;

    get_gegenstaende()->add_objekt(new Gegenstand(this, hinid, hinname, hinname, true, false, hinsichtbar, -1));
    get_gegenstaende()->add_objekt(new Gegenstand(this, zurueckid, zurueckname, zurueckname, true, false, zuruecksichtbar, -1));
    r1->add_ausgang(hinid);
    r2->add_ausgang(zurueckid);
    tmpregel=new Spielregel(this, CMD_GEHE, hinid, -1);
    tmpregel->add_aktion(new AktionRaumwechsel(this, raum2));
    get_regeln()->add_regel(tmpregel);
    tmpregel=new Spielregel(this, CMD_GEHE, zurueckid, -1);
    tmpregel->add_aktion(new AktionRaumwechsel(this, raum1));
    get_regeln()->add_regel(tmpregel);
  }

  void SpielBauer::erzeuge_einweg_verbindung(id_type raum1, id_type raum2,
      id_type hinid, const std::string& hinname, bool hinsichtbar
                                 ) {
    Raum* r1 = get_raeume()->get_raum_by_id(raum1);
    Spielregel* tmpregel;

    get_gegenstaende()->add_objekt(new Gegenstand(this, hinid, hinname, hinname, true, false, hinsichtbar, -1));
    r1->add_ausgang(hinid);
    tmpregel=new Spielregel(this, CMD_GEHE, hinid, -1);
    tmpregel->add_aktion(new AktionRaumwechsel(this, raum2));
    get_regeln()->add_regel(tmpregel);
  }

  void SpielBauer::erzeuge_gegenstand(id_type id, id_type raum, bool fest, bool ablegbar, bool sichtbar,
                          const std::string& name, const std::string& bez, const std::string& beschr,
                          int z, int v1) {

    get_gegenstaende()->add_objekt(new Gegenstand(this, id, name, bez, fest, ablegbar, sichtbar, raum, z, v1));
    if(beschr!="") {
      Spielregel* tmpregel;
      get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_BESCHREIBEN, -1, -1));
      tmpregel->add_bedingung(new BedingungObjektInAktRaum(this, id));
      tmpregel->add_bedingung(new BedingungObjektIstSichtbar(this, id));
      if(!fest)
        tmpregel->add_bedingung(new BedingungObjektAnOrgPos(this, id));
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));
    }
  }

  Spielregel* SpielBauer::erzeuge_beschreibung(id_type id, int z, const std::string& beschr) {

    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_BESCHREIBEN, -1, -1));
    tmpregel->add_bedingung(new BedingungObjektInAktRaum(this, id));
    tmpregel->add_bedingung(new BedingungObjektIstSichtbar(this, id));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_oeffnen(id_type id, int z, const std::string& beschr) {

    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_OEFFNE, id, -1));
//    tmpregel->add_bedingung(new BedingungObjektInAktRaum(this, id));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_schliessen(id_type id, int z, const std::string& beschr) {

    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_SCHLIESSE, id, -1));
//    tmpregel->add_bedingung(new BedingungObjektInAktRaum(this, id));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_nehmen(id_type id, int z, bool ins_inv, const std::string& text) {
    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_NIMM, id, -1));
//    tmpregel->add_bedingung(new BedingungObjektLose(this, id));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(ins_inv)
    tmpregel->add_aktion(new AktionObjektNeuePos(this, id, 0));
    if(text!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, text));

    return tmpregel;
  }

  void SpielBauer::erzeuge_raum(id_type id, const std::string& name, const std::string& beschr) {
    Raum* tmpraum;
    tmpraum=new Raum(this, id, name, beschr);
    get_raeume()->add_objekt(tmpraum);

  }

// Zustnde fr Tuer: 0 abgeschlossen, 1 zu, 2 offen, 3 offen und blockiert.

  void SpielBauer::erzeuge_tuer(id_type raum1id, id_type raum2id, id_type exit1id, id_type exit2id,
                           id_type tuer1id, id_type tuer2id, int z,
                            const std::string& name1, const std::string& bez1,const std::string& otxt1,
                            const std::string& name2, const std::string& bez2,const std::string& otxt2,
                            const std::string& stxt, const std::string& blocktxt) {

    erzeuge_gegenstand(tuer1id,raum1id,true,false,true, name1, bez1, "", z);
    erzeuge_gegenstand(tuer2id,raum2id,true,false,true, name2, bez2, "", z);
    if(z==ST_TUER_VERSCHLOSSEN || z==ST_TUER_GESCHLOSSEN) {
      get_gegenstaende()->get_gegenstand_by_id(exit1id)->set_sichtbar(false);
      get_gegenstaende()->get_gegenstand_by_id(exit2id)->set_sichtbar(false);
    }
    else {
      get_gegenstaende()->get_gegenstand_by_id(exit1id)->set_sichtbar(true);
      get_gegenstaende()->get_gegenstand_by_id(exit2id)->set_sichtbar(true);
    }


    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_OEFFNE, tuer1id, -1));
    tmpregel->add_bedingung(new BedingungObjektHatZustand(this, tuer1id, ST_TUER_GESCHLOSSEN));
    tmpregel->add_aktion(new AktionTextausgabe(this, otxt1));
    tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit1id, true));
    tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit2id, true));
    if(blocktxt!="") {
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer1id, ST_TUER_OFFENBLOCKIERT));
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer2id, ST_TUER_OFFENBLOCKIERT));
    }
    else {
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer1id, ST_TUER_OFFEN));
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer2id, ST_TUER_OFFEN));
    }

    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_OEFFNE, tuer2id, -1));
    tmpregel->add_bedingung(new BedingungObjektHatZustand(this, tuer2id, ST_TUER_GESCHLOSSEN));
    tmpregel->add_aktion(new AktionTextausgabe(this, otxt2));
    tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit1id, true));
    tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit2id, true));
    if(blocktxt!="") {
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer1id, ST_TUER_OFFENBLOCKIERT));
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer2id, ST_TUER_OFFENBLOCKIERT));
    }
    else {
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer1id, ST_TUER_OFFEN));
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer2id, ST_TUER_OFFEN));
    }

    if(blocktxt!="") {
      get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_SCHLIESSE, tuer1id, -1));
      tmpregel->add_trigger(CMD_SCHLIESSE, tuer2id, -1);
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, tuer1id, ST_TUER_OFFENBLOCKIERT));
      tmpregel->add_aktion(new AktionTextausgabe(this, blocktxt));
    }
    else {
      get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_SCHLIESSE, tuer1id, -1));
      tmpregel->add_trigger(CMD_SCHLIESSE, tuer2id, -1);
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, tuer1id, ST_TUER_OFFEN));
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer1id, ST_TUER_GESCHLOSSEN));
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuer2id, ST_TUER_GESCHLOSSEN));
      tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit1id, false));
      tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit2id, false));
      tmpregel->add_aktion(new AktionTextausgabe(this, stxt));
    }
  }

  void SpielBauer::erzeuge_einseitige_tuer(id_type raumid, id_type exit1id, id_type exit2id,
                           id_type tuerid, int z,
                            const std::string& name, const std::string& bez,const std::string& otxt,
                            const std::string& stxt, const std::string& blocktxt) {

    erzeuge_gegenstand(tuerid,raumid,true,false,true, name, bez, "", z);
    if(z==ST_TUER_VERSCHLOSSEN || z==ST_TUER_GESCHLOSSEN) {
      get_gegenstaende()->get_gegenstand_by_id(exit1id)->set_sichtbar(false);
      get_gegenstaende()->get_gegenstand_by_id(exit2id)->set_sichtbar(false);
    }
    else {
      get_gegenstaende()->get_gegenstand_by_id(exit1id)->set_sichtbar(true);
      get_gegenstaende()->get_gegenstand_by_id(exit2id)->set_sichtbar(true);
    }


    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_OEFFNE, tuerid, -1));
    tmpregel->add_bedingung(new BedingungObjektHatZustand(this, tuerid, ST_TUER_GESCHLOSSEN));
    tmpregel->add_aktion(new AktionTextausgabe(this, otxt));
    tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit1id, true));
    tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit2id, true));
    if(blocktxt!="") {
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuerid, ST_TUER_OFFENBLOCKIERT));
    }
    else {
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuerid, ST_TUER_OFFEN));
    }

    if(blocktxt!="") {
      get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_SCHLIESSE, tuerid, -1));
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, tuerid, ST_TUER_OFFENBLOCKIERT));
      tmpregel->add_aktion(new AktionTextausgabe(this, blocktxt));
    }
    else {
      get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_SCHLIESSE, tuerid, -1));
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, tuerid, ST_TUER_OFFEN));
      tmpregel->add_aktion(new AktionObjektNeuerZustand(this, tuerid, ST_TUER_GESCHLOSSEN));
      tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit1id, false));
      tmpregel->add_aktion(new AktionObjektSetSichtbar(this, exit2id, false));
      tmpregel->add_aktion(new AktionTextausgabe(this, stxt));
    }
  }

  Spielregel* SpielBauer::erzeuge_untersuchung(id_type id, int z, int pos, const std::string& beschr) {
    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_UNTERSUCHE, id, -1));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(pos==POS_INVENTAR)
      tmpregel->add_bedingung(new BedingungObjektInInventar(this, id));
    if(pos==POS_RAUM)
      tmpregel->add_bedingung(new BedingungObjektNichtInInventar(this, id));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_benutzung(id_type id, int z, int pos, const std::string& beschr) {
    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_BENUTZE, id, -1));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(pos==POS_INVENTAR)
      tmpregel->add_bedingung(new BedingungObjektInInventar(this, id));
    if(pos==POS_RAUM)
      tmpregel->add_bedingung(new BedingungObjektNichtInInventar(this, id));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_gehe(id_type id, const std::string& beschr) {
    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_GEHE, id, -1));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_druecken(id_type id, int z, int pos, const std::string& beschr) {
    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_DRUECKE, id, -1));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(pos==POS_INVENTAR)
      tmpregel->add_bedingung(new BedingungObjektInInventar(this, id));
    if(pos==POS_RAUM)
      tmpregel->add_bedingung(new BedingungObjektNichtInInventar(this, id));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_ziehen(id_type id, int z, int pos, const std::string& beschr) {
    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_ZIEHE, id, -1));
    if(z!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id, z));
    if(pos==POS_INVENTAR)
      tmpregel->add_bedingung(new BedingungObjektInInventar(this, id));
    if(pos==POS_RAUM)
      tmpregel->add_bedingung(new BedingungObjektNichtInInventar(this, id));
    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }

  Spielregel* SpielBauer::erzeuge_kombination(id_type id1, id_type id2, int z1, int z2, int pos1, int pos2, const std::string& beschr) {
    Spielregel* tmpregel;
    get_regeln()->add_regel(tmpregel=new Spielregel(this, CMD_KOMBINIERE, id1, id2, true));
    if(z1!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id1, z1));
    if(pos1==POS_INVENTAR)
      tmpregel->add_bedingung(new BedingungObjektInInventar(this, id1));
    if(pos1==POS_RAUM)
      tmpregel->add_bedingung(new BedingungObjektNichtInInventar(this, id1));

    if(z2!=-1)
      tmpregel->add_bedingung(new BedingungObjektHatZustand(this, id2, z2));
    if(pos2==POS_INVENTAR)
      tmpregel->add_bedingung(new BedingungObjektInInventar(this, id2));
    if(pos2==POS_RAUM)
      tmpregel->add_bedingung(new BedingungObjektNichtInInventar(this, id2));

    if(beschr!="")
      tmpregel->add_aktion(new AktionTextausgabe(this, beschr));

    return tmpregel;
  }
