/*
 * Spiel.h
 *
 *  Created on: 11.05.2014
 *      Author: Andr Willms
 */

#ifndef SPIEL_H_
#define SPIEL_H_

#include "Raumliste.h"
#include "Befehlsliste.h"
#include "Gegenstandsliste.h"
#include "Spielregelliste.h"
#include "Stringfunktionen.h"

#include <vector>
//#include <memory>

class Raum;
class ZerlegteAnweisung;

class Spiel {
public:
  static const int ENGINE=1;

  static const int LINEWIDTH=70;

  enum Cmds { CMD_ENDE=1, CMD_HILFE=2, CMD_UMSCHAUEN=3, CMD_HOTSPOT=4, CMD_RICHTUNGEN=5, CMD_SPEICHERN=6, CMD_LADEN=7,
                   CMD_INVENTAR=8, CMD_GEHE=9, CMD_BESCHREIBEN=10, CMD_NIMM=11, CMD_UNTERSUCHE=12, CMD_KOMBINIERE=13,
                   CMD_VERWENDE=14, CMD_OEFFNE=15, CMD_SCHLIESSE=16, CMD_BENUTZE=17, CMD_DRUECKE=18, CMD_ZIEHE=19};

private:
  std::string starttext;
  std::string titel;
  Befehlsliste befehle;
  Raumliste raeume;
  Gegenstandsliste gegenstaende;
  Spielregelliste spielregeln;

//  id_type neuer_raum;
  Raum* akt_raum;

  bool spiel_laeuft, spiel_gewonnen;

  void raum_beschreiben(id_type id);
  void raum_beschreiben(Raum* obj);
  bool pruefe_auf_internen_befehl(const ZerlegteAnweisung& anw);
  void erzeuge_befehle();
  void schreibe_nimm_neg(const std::string& bez);
  void schreibe_nimm_pos(const std::string& bez);
  void schreibe_allgemein_neg();
  void schreibe_untersuche_neg(const std::string& bez);

protected:
  void set_starttext(const std::string& s) {
    starttext = s;
  }
   void set_titel(const std::string& t) {
    titel = t;
  }
public:
  Spiel();
  virtual ~Spiel();
  virtual void spielen();



   std::string get_titel() {
    return titel;
  }

  virtual void wechsel_raum(id_type id) {
//    neuer_raum = id;
//    akt_raum=raeume.get_raum_by_id(neuer_raum);
    akt_raum=raeume.get_raum_by_id(id);
}

  Befehlsliste* get_befehle() {
    return &befehle;
  }

  Gegenstandsliste* get_gegenstaende() {
    return &gegenstaende;
  }

  Spielregelliste* get_regeln() {
    return &spielregeln;
  }

  Raumliste* get_raeume() {
    return &raeume;
  }

  Raum* get_akt_raum() {
    return akt_raum;
  }

  virtual void spiel_beenden(bool won) {
    spiel_laeuft = false;
    spiel_gewonnen = won;
  }

//  void erzeuge_spielstruktur();
//  void erzeuge_spielstruktur2();


  static void schreibe_zufallsreaktion(const std::vector<std::string>& txts, const std::string& bez);
  static std::string fmt(const std::string& s);


  static std::string convert_output(const std::string& s) {
#ifdef DOS_CHARSET
    return to_dos(s);
#else
    return s;
#endif
  }

  static std::string convert_input(const std::string& s) {
#ifdef DOS_CHARSET
    return from_dos(s);
#else
    return s;
#endif
  }

  bool xml_out(const std::string& datei) const;

};

#endif /* SPIEL_H_ */
