/*
 * Spiel.cpp
 *
 *  Created on: 11.05.2014
 *      Author: Andr Willms
 */

#include "Spiel.h"
#include "spiel_const.h"
#include "Mathefunktionen.h"
#include "Befehl.h"
#include "Gegenstand.h"
#include "ZerlegteAnweisung.h"

#include <iostream>
#include <fstream>

using namespace std;

Spiel::Spiel() {
  spiel_laeuft=true;
  spiel_gewonnen=false;

  erzeuge_befehle();
}

Spiel::~Spiel() {

}


void Spiel::spielen() {
#ifdef FDEBUG
  cout << "Raeume      : " << raeume.size() << endl;
  cout << "Gegenstaende: " << gegenstaende.size() << endl;
  cout << "Spielregeln : " << spielregeln.size() << "\n" << endl;
#endif


  cout << fmt(convert_output(starttext)) << endl;

//  raum_beschreiben(akt_raum);

  while(spiel_laeuft) {
/*
    if(akt_raum->get_id()!=neuer_raum) {
      akt_raum=raeume.get_raum_by_id(neuer_raum);
    }
*/
      cout << "\n";
      raum_beschreiben(akt_raum);

    string eingabe;
    cout << Spiel::convert_output("\nWas willst du machen (\"h\" fr Hilfe): ");
    getline(cin, eingabe);
    clear_screen();
    ZerlegteAnweisung anw(this, convert_input(eingabe));
    anw.schreibe_feedback();
    if(anw.gueltig) {
//      cout << "gueltig" << endl;
      if(!pruefe_auf_internen_befehl(anw)) {
        if(!spielregeln.ausfuehren(anw.cmd_id, anw.obj1_id, anw.obj2_id)) {
          schreibe_allgemein_neg();
        }
      }
      cout << endl;
    }
  }

  if(!spiel_gewonnen)
    cout << "\nBeim naechsten Mal klappt es bestimmt besser.\n" << endl;
  else
    cout << "\nDu hast es tatsaechlich geschafft. Herzlichen Glueckwunsch.\n" << endl;

}


void Spiel::raum_beschreiben(id_type id) {
  raum_beschreiben(raeume.get_raum_by_id(id));
}

void Spiel::raum_beschreiben(Raum* obj){
  cout << convert_output(obj->get_name()) << "\n" << separator_line(obj->get_name().size()+2) << endl;
  string beschr=convert_output(obj->get_beschreibung());
  if(!beschr.empty())
    cout << fmt(beschr) << endl;
  spielregeln.ausfuehren(CMD_BESCHREIBEN,-1,-1);
  akt_raum->schreibe_verfuegbare_richtungen_kurz();
  cout << endl;
  gegenstaende.schreibe_hotspots_kurz();
  cout << endl;
#ifdef FDEBUG
  gegenstaende.schreibe_invisible_hotspots_kurz();
  cout << endl;
#endif

}

bool Spiel::pruefe_auf_internen_befehl(const ZerlegteAnweisung& anw) {
  if(anw.gueltig) {
    string eingabe;
    switch(anw.cmd_id) {
      case CMD_ENDE:
#ifndef FDEBUG
        cout << "\nWillst du wirklich das Spiel beenden? Dann schreib \"ja\":";
        getline(cin, eingabe);
        if(eingabe=="ja")
#endif
          spiel_laeuft=false;
        return true;

      case CMD_HILFE:
        befehle.schreibe_verfuegbare_befehle();
        return true;

/*
      case CMD_RICHTUNGEN:
        akt_raum->schreibe_verfuegbare_richtungen();
        return true;
*/
      case CMD_INVENTAR:
        gegenstaende.schreibe_inventar();
        return true;
/*
      case CMD_HOTSPOT:
        gegenstaende.schreibe_hotspots();
        return true;

      case CMD_UMSCHAUEN:
        cout << "\n";
        raum_beschreiben(akt_raum);
        return true;
*/
      case CMD_SPEICHERN:
        if(gegenstaende.serialisieren(this, "savegame_"+anw.obj1_txt+".dat"))
          cout << "\nSpiel unter " << anw.obj1_txt <<" gespeichert." << endl;
        else
          cout << "\nSpeichern fehlgeschlagen!" << endl;
        return true;

      case CMD_LADEN:
        if(gegenstaende.deserialisieren(this, "savegame_"+anw.obj1_txt+".dat"))
          cout << "\nSpiel " << anw.obj1_txt <<" geladen." << endl;
        else
          cout << "\nLaden fehlgeschlagen!" << endl;
        return true;

      case CMD_NIMM:
        cout << "\n";
        if(!spielregeln.ausfuehren(anw.cmd_id, anw.obj1_id, anw.obj2_id)) {
          Gegenstand* g=gegenstaende.get_gegenstand_by_id(anw.obj1_id);
          if(!g->ist_fest()) {
            if(g->in_inventar()) {
              cout << convert_output(start_capitalized(g->get_bezeichnung())) << " haben wir doch bereits in der Tasche." << endl;
            }
            else {
              g->set_akt_pos(0);
              schreibe_nimm_pos(g->get_bezeichnung());
            }
          }
          else {
            schreibe_nimm_neg(g->get_bezeichnung());
          }

        }
  //      cout << "\n";
        return true;

      case CMD_UNTERSUCHE:
        cout << "\n";
        if(!spielregeln.ausfuehren(anw.cmd_id, anw.obj1_id, anw.obj2_id)) {
          Gegenstand* g=gegenstaende.get_gegenstand_by_id(anw.obj1_id);
          schreibe_untersuche_neg(g->get_bezeichnung());
        }
  //      cout << "\n";
        return true;

#ifdef FDEBUG
      case -20: // ft (teleport)
        wechsel_raum(::stoi(anw.obj1_txt));
        return true;
      case -21: // fg (list gegenstnde)
        gegenstaende.schreibe_gegenstandsliste();
        return true;
      case -22: // fn (gegenstand nehmen)
        gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->set_sichtbar(true);
        gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->set_akt_pos(0);
        return true;
      case -23: // fu (gegenstand untersuchen)
        cout << "Name     : " << gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_bezeichnung() << endl;
        cout << "ID       : " << gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_id() << endl;
        cout << "Position : " << gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_akt_pos() << endl;
        cout << "Zustand  : " << gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_zustand() << endl;
        return true;
      case -24: // fsz (gegenstand zustand aendern)
        cout << anw.obj1_txt << " - " << anw.obj2_txt << endl;
        gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->set_zustand(::stoi(anw.obj2_txt));
        cout << gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_name() << " hat jetzt Zustand " << gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_zustand() << endl;
        return true;
      case -25: // fs (gegenstand sichtbar machen)
        gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->set_sichtbar(true);
        cout << gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_name() << " sichtbar gemacht." << endl;
        return true;
      case -26: // fi (gegenstand idenzifizieren)
        cout << "ID " << anw.obj1_txt << " ist " << convert_output(gegenstaende.get_gegenstand_by_id(::stoi(anw.obj1_txt))->get_name()) << endl;
        return true;
#endif

    }
  }
  return false;
}

void Spiel::erzeuge_befehle() {
//  befehle.add_objekt(new Befehl(this, CMD_UMSCHAUEN, "umschauen", 0, "umschauen", "Beschreibt den aktuellen Ort"));
  befehle.add_objekt(new Befehl(this, CMD_INVENTAR, "inventar", 0, "inventar", "Listet deine Habseligkeiten auf"));
  befehle.add_objekt(new Befehl(this, CMD_UNTERSUCHE, "untersuche", 1, "untersuche X", "Untersucht den Gegenstand genauer"));
  befehle.add_objekt(new Befehl(this, CMD_NIMM, "nimm", 1, "nimm X", "Nimmt den Gegenstand in dein Inventar auf"));
  befehle.add_objekt(new Befehl(this, CMD_GEHE, "gehe", 1, "gehe X", "Du gehst in die angegebene Richtung"));
  befehle.add_objekt(new Befehl(this, CMD_BENUTZE, "benutze", 1, "benutze X", "Du benutzt den Gegenstand X"));
//  befehle.add_objekt(new Befehl(this, CMD_RICHTUNGEN, "richtungen", 0, "richtungen", "Listet alle momentan gehbaren Richtungen auf"));
  befehle.add_objekt(new Befehl(this, CMD_KOMBINIERE, "verwende", 2, "verwende X + Y", "Verwendet/kombiniert/verknpft zwei Gegenstaende"));
  befehle.add_objekt(new Befehl(this, CMD_OEFFNE, "ffne", 1, "ffne X", "ffnet einen Gegenstand"));
  befehle.add_objekt(new Befehl(this, CMD_SCHLIESSE, "schliee", 1, "schliee X", "Schliet einen Gegenstand"));
  befehle.add_objekt(new Befehl(this, CMD_DRUECKE, "drcke", 1, "drcke X", "Drckt einen Gegenstand"));
  befehle.add_objekt(new Befehl(this, CMD_ZIEHE, "ziehe", 1, "ziehe X", "Zieht oder verschiebt einen Gegenstand"));
//  befehle.add_objekt(new Befehl(this, CMD_HOTSPOT, "hotspots", 0, "hotspots", "Listet alle interaktiven Objekte auf"));

  befehle.add_objekt(new Befehl(this, CMD_SPEICHERN, "speichern", 1, "speichern NR", "Speichert den Spielstand unter der angegebenen Nummer"));
  befehle.add_objekt(new Befehl(this, CMD_LADEN, "laden", 1, "laden NR", "Ldt den Spielstand mit der angegebenen Nummer"));
  befehle.add_objekt(new Befehl(this, CMD_HILFE, "hilfe", 0, "hilfe", "Listet alle Befehle auf"));
  befehle.add_objekt(new Befehl(this, CMD_ENDE, "ende", 0, "ende", "Beendet das Spiel"));
#ifdef FDEBUG
  befehle.add_objekt(new Befehl(this, -20, "ft", 1, "ft X", "Teleportiert zu Raum X"));
  befehle.add_objekt(new Befehl(this, -21, "fg", 0, "fg", "Listet alle Spielgegenstaende auf"));
  befehle.add_objekt(new Befehl(this, -22, "fn", 1, "fn X", "Nimm Gegenstand mit id X"));
  befehle.add_objekt(new Befehl(this, -23, "fu", 1, "fu X", "Untersuche Gegenstand mit id X"));
  befehle.add_objekt(new Befehl(this, -25, "fs", 1, "fs X", "Macht Gegenstand mit id X sichtbar"));
  befehle.add_objekt(new Befehl(this, -24, "fsz", 1, "fsz X + Y", "Gegenstand mit id X bekommt Zustand Y"));
  befehle.add_objekt(new Befehl(this, -26, "fi", 1, "fi X ", "Identifiziere Objekt mit id X"));
#endif


}

void Spiel::schreibe_zufallsreaktion(const vector<string>& txts, const string& bez) {
  int txt = get_zufallszahl(0, txts.size()-1);
  string line = txts[txt];
  unsigned int joker = line.find("%");
  while(joker!=string::npos) {
    if(joker==0)
      line.replace(joker,1, start_capitalized(bez));
    else
      line.replace(joker,1, bez);
    joker = line.find("%");
  }
  cout << fmt(Spiel::convert_output(line)) << "\n";
}

void Spiel::schreibe_untersuche_neg(const std::string& bez) {
  static vector<string> txts{ "% bleibt %, auch wenn man genauer hinsieht.",
                              "%, mehr nicht.",
                              "Ja, das ist %.",
                              "Auf den ersten Blick sieht es aus wie %. Auf den zweiten auch.",
                              "Du gehst immer nher ran und tatschlich, es ist %.",
                              "% sieht aus der Nhe auch nicht anders aus.",
                              "Bei genauerer Betrachtung siehst du... auch nicht mehr.",
                              "Nichts auergewhnliches zu sehen.",
                              "% wie alle anderen auch."
                     };
  schreibe_zufallsreaktion(txts, bez);
}

void Spiel::schreibe_nimm_neg(const std::string& bez) {
  static vector<string> txts{ "Das Ding nehmen wir nicht auch noch mit.",
                              "Nein, das lassen wir mal an Ort und Stelle.",
                              "Es hat bestimmt einen Grund, dass % an dieser Stelle ist.",
                              "Nein, nenn mir einen Grund, warum uns % helfen koennte.",
                              "Das sollten wir dort nicht wegnehmen.",
                              "% kommt uns nicht in die Tte.",
                              "% ist das Letzte, was wir jetzt brauchen."
                     };
  schreibe_zufallsreaktion(txts, bez);
}

void Spiel::schreibe_nimm_pos(const std::string& bez) {
  static vector<string> txts{ "Du hast jetzt einen Gegenstand mehr im Inventar.",
                              "Und wieder etwas mehr zu tragen.",
                              "Also, % macht sich wirklich gut in deiner Tasche.",
                              "Ok, % passt gerade noch.",
                              "%? Naja, wenigstens nicht so viel zu tragen."
                     };
  schreibe_zufallsreaktion(txts, bez);
}

void Spiel::schreibe_allgemein_neg() {
  static vector<string> txts{ "Auf den ersten Blick eher sinnlos. Auf den zweiten auch.",
                              "Das klappt nicht.",
                              "Gute Idee, hat aber leider nichts gebracht.",
                              "Das lassen wir besser.",
                              "Du hattest schon bessere Ideen.",
                              "Das bringt uns nicht weiter.",
                              "Das bringt uns keinerlei Vorteil.",
                              "Noch so ein Vorschlag und ich kndige.",
                              "Gib Bescheid, wenn dir was besseres einfllt.",
                              "Nein, das mache ich nicht.",
                              "Ich weigere mich, das zu tun.",
                              "Hatten wir das nicht schon probiert?",
                              "Du willst das nicht wirklich machen, oder?",
                              "Manche Dinge klappen auch beim x-ten Mal nicht."
                     };
  schreibe_zufallsreaktion(txts, "");
}

string Spiel::fmt(const string& s) {
  return text_layout(s, LINEWIDTH);
}

bool Spiel::xml_out(const string& datei) const {
  ofstream ostr(datei);
  if(!ostr.is_open())
    return false;
  ostr << "<game engine=\"" << ENGINE << "\" title=\"" << titel << "\" >\n";

  raeume.xml_out(ostr);
  ostr << "\n";
  gegenstaende.xml_out(ostr);
  ostr << "\n";
  spielregeln.xml_out(ostr);
  ostr << "<start room=\"" << akt_raum->get_id() << "\" >\n";
  ostr << "<description>\n";
  ostr << starttext<< "\n";
  ostr << "</description>\n";
  ostr << "</start>\n";

  ostr << "</game>\n";
  ostr.close();
  return true;
}
