/*
 * Raum.h
 *
 *  Created on: 10.05.2014
 *      Author: Andr Willms
 */

#ifndef RAUM_H_
#define RAUM_H_

#include "BenanntesObjekt.h"
#include "XMLObjekt.h"
#include <string>
#include <vector>

class Raum : public BenanntesObjekt, public XMLObjekt {
private:
//  std::string name;
  std::string beschreibung;
  std::vector<id_type> ausgaenge;

public:
  Raum(Spiel* spiel, id_type id, const std::string& n, const std::string& beschr);
  virtual ~Raum() {
  }

//  void schreibe_verfuegbare_richtungen() const;
  void schreibe_verfuegbare_richtungen_kurz() const;

  int get_ausgangid_by_partial_name_match(const std::string& s) const;

  virtual void analyse() const;


  std::string get_beschreibung() const {
    return beschreibung;
  }

//  std::string get_name() const {
//    return name;
//  }

  void add_ausgang(id_type id) {
    ausgaenge.push_back(id);
  }

  virtual void xml_out(std::ostream& ostr) const;

};

#endif /* RAUM_H_ */
