/*
 * Raum.cpp
 *
 *  Created on: 10.05.2014
 *      Author: Andr Willms
 */

#include "Raum.h"
#include "Objektanalyzer.h"
#include "Gegenstand.h"
#include "Spiel.h"
#include "Stringfunktionen.h"
#include "spiel_const.h"

#include <iostream>

using namespace std;

void Raum::analyse() const {Objektanalyzer::analyse(this); }

Raum::Raum(Spiel* spiel, id_type id, const std::string& n, const std::string& beschr)
    : BenanntesObjekt(spiel, id, n), beschreibung(beschr) {

}

/*
void Raum::schreibe_verfuegbare_richtungen() const {
  cout << "\nDu kannst in folgende Richtungen gehen:\n--------------------------------------------" << endl;

  for(auto iter=ausgaenge.begin(); iter!=ausgaenge.end(); ++iter) {
    Gegenstand* ptr = get_spiel()->get_gegenstaende()->get_gegenstand_by_id(*iter);
    if(ptr->ist_sichtbar())
      cout << start_capitalized(ptr->get_name()) << endl;
  }
  cout << endl;
}
*/

void Raum::schreibe_verfuegbare_richtungen_kurz() const {
  string out= "Richtungen: ";
  int anz=0;
  for(auto iter=ausgaenge.begin(); iter!=ausgaenge.end(); ++iter) {
    Gegenstand* ptr = get_spiel()->get_gegenstaende()->get_gegenstand_by_id(*iter);
    if(ptr->ist_sichtbar()) {
      if(++anz!=1)
        out+=", ";
      out+= start_capitalized(ptr->get_name());
#ifdef FDEBUG
      out+=" ("+::to_string(ptr->get_id())+","+::to_string(ptr->get_zustand())+")";
#endif
    }
  }
  cout << "\n" << Spiel::fmt(Spiel::convert_output(out));
}


int Raum::get_ausgangid_by_partial_name_match(const string& s) const {
  for(auto iter=ausgaenge.begin(); iter!=ausgaenge.end(); ++iter) {
    id_type id=*iter;
    Gegenstand* ptr=get_spiel()->get_gegenstaende()->get_gegenstand_by_id(id);
    if(ptr->ist_sichtbar() && ptr->partial_name_match(s))
      return id;
  }
  return -1;

}

void Raum::xml_out(std::ostream& ostr) const {
  ostr << "<room id=\"" << get_id() << "\" name=\"" << get_name() << "\" >\n";
  ostr << "<description>\n";
  ostr << beschreibung << "\n";
  ostr << "</description>\n";
  for(auto iter=ausgaenge.begin(); iter!=ausgaenge.end(); ++iter) {
    ostr << "<exit refid=\"" << *iter << "\" />\n";
  }

  ostr << "</room>\n";

}
