/*
 * IdObjektListe.h
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#ifndef IDOBJEKTLISTE_H_
#define IDOBJEKTLISTE_H_

//class IdObjekt;

#include <vector>
#include <memory>

#include "IdObjekt.h"

class IdObjektListe  {
public:
  typedef std::unique_ptr<IdObjekt> idobjekt_ptr;
  class id_not_found {public: id_type id; id_not_found(id_type i) : id(i) {} };
//  class objekt_not_found {};
  class duplicate_id { public: const IdObjekt* obj; duplicate_id(const IdObjekt* o) : obj(o) {} };

protected:
  std::vector<idobjekt_ptr> objekte;

public:
  IdObjektListe();
  virtual ~IdObjektListe() {  }

  bool ist_enthalten(id_type id) const;
  bool ist_enthalten(IdObjekt* obj) const;

  IdObjekt* get_objekt_by_id(id_type id) const;


  void add_objekt(IdObjekt* obj);

  int size() const {
    return objekte.size();
  }
};

#endif /* IDOBJEKTLISTE_H_ */
