/*
 * IdObjektListe.cpp
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#include "IdObjektListe.h"
#include "IdObjekt.h"

#include <algorithm>

IdObjektListe::IdObjektListe() {
}

//bool IdObjektListe::ist_enthalten(id_type id) const {
//  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter)
//    if((*iter)->ist_id(id)) return true;
//  return false;
//}
//
//bool IdObjektListe::ist_enthalten(IdObjekt* obj) const {
//  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter)
//    if((*iter).get()==obj) return true;
//  return false;
//}

bool IdObjektListe::ist_enthalten(id_type id) const {
  auto iter = find_if(objekte.begin(), objekte.end(), [&](const idobjekt_ptr& p){return p->ist_id(id); });
  return iter!=objekte.end();
}

bool IdObjektListe::ist_enthalten(IdObjekt* obj) const {
  auto iter = find_if(objekte.begin(), objekte.end(), [&](const idobjekt_ptr& p){return p.get()==obj; });
  return iter!=objekte.end();
}

IdObjekt* IdObjektListe::get_objekt_by_id(id_type id) const {
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter)
    if((*iter)->ist_id(id)) return (*iter).get();

  throw id_not_found(id);
  return (*objekte.end()).get();
}

void IdObjektListe::add_objekt(IdObjekt* obj) {
  if(ist_enthalten(obj->get_id()))
    throw duplicate_id(obj);
  objekte.push_back(idobjekt_ptr(obj));
}



