/*
 * GegenstandListe.h
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#ifndef GEGENSTANDLISTE_H_
#define GEGENSTANDLISTE_H_

#include "BenObjektListe.h"
#include "spiel_const.h"

class Gegenstand;
class Spiel;

class Gegenstandsliste : public BenObjektListe {
  int berechne_chk(const std::string& s, int v) const;

public:
  Gegenstandsliste();
  virtual ~Gegenstandsliste() {
  }

  Gegenstand* get_gegenstand_by_id(id_type id) const;

  int get_gegenstandid_by_available_and_partial_name_match(const std::string& s) const;

  void schreibe_inventar() const;

//  void schreibe_hotspots() const;
  void schreibe_hotspots_kurz() const;
  void schreibe_invisible_hotspots_kurz() const;


  bool serialisieren(Spiel* spiel, const std::string& datei) const;
  bool deserialisieren(Spiel* spiel, const std::string& datei);

  void xml_out(std::ostream& ostr) const;

#ifdef FDEBUG
  void schreibe_gegenstandsliste() const;
#endif

};



#endif /* GEGENSTANDLISTE_H_ */
