/*
 * GegenstandListe.cpp
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#include "Gegenstandsliste.h"
#include "Gegenstand.h"
#include <fstream>
#include <sstream>
#include <iostream>
#include "Stringfunktionen.h"

using namespace std;

Gegenstandsliste::Gegenstandsliste() {
  // TODO Auto-generated constructor stub

}

Gegenstand* Gegenstandsliste::get_gegenstand_by_id(id_type id) const {
  return dynamic_cast<Gegenstand*>(get_objekt_by_id(id));
}

int Gegenstandsliste::get_gegenstandid_by_available_and_partial_name_match(const string& s) const {
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
    if(ptr->ist_sichtbar() &&
      (ptr->in_akt_raum() || ptr->in_inventar()) &&
      ptr->partial_name_match(s))
      return ptr->get_id();
  }
  return -1;
}

void Gegenstandsliste::schreibe_inventar() const {
  cout << "\nDu besitzt folgende Dinge:\n" << separator_line(Spiel::LINEWIDTH) << endl;

  int anz=0;

  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
    if(ptr->ist_sichtbar() && ptr->in_inventar()) {
      string item=start_capitalized(Spiel::convert_output(ptr->get_bezeichnung()));
#ifdef FDEBUG
      item+=" ("+::to_string(ptr->get_id())+","+::to_string(ptr->get_zustand())+")";
#endif
      cout << item;
      if(anz++%2==0) {
        int seps=Spiel::LINEWIDTH/2-item.size();
        for(int i=0; i<seps; ++i)
          cout << " ";
      }
      else
        cout << endl;
    }
  }
  cout << "\n" << endl;
}

#ifdef FDEBUG
void Gegenstandsliste::schreibe_gegenstandsliste() const {
  cout << "\nGegenstandsliste:\n" << separator_line(Spiel::LINEWIDTH) << endl;

  int anz=0;

  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
      string item=start_capitalized(Spiel::convert_output(ptr->get_bezeichnung()));
      item+=" ("+::to_string(ptr->get_id())+","+::to_string(ptr->get_akt_pos())+","+::to_string(ptr->get_zustand())+")";
      cout << item;
      if(anz++%2==0) {
        int seps=Spiel::LINEWIDTH/2-item.size();
        for(int i=0; i<seps; ++i)
          cout << " ";
      }
      else
        cout << endl;

  }
  cout << "\n" << endl;
}
#endif

/*
void Gegenstandsliste::schreibe_hotspots() const {
  cout << "\nIn deiner Reichweite sind folgende interaktive Dinge:\n--------------------------------------------------------" << endl;

  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
    if(ptr->ist_sichtbar() && ptr->in_akt_raum())
      cout << start_capitalized(ptr->get_bezeichnung()) << endl;
  }
  cout << endl;
}
*/
void Gegenstandsliste::schreibe_hotspots_kurz() const {
  string out= "Objekte: ";
  int anz=0;
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
    if(ptr->ist_sichtbar() && ptr->in_akt_raum()) {
      if(++anz!=1)
        out+=", ";
      out+= start_capitalized(Spiel::convert_output(ptr->get_name()));
#ifdef FDEBUG
      out+=" ("+::to_string(ptr->get_id())+","+::to_string(ptr->get_zustand())+")";
#endif
    }
  }
  cout << "\n" << Spiel::fmt(out);
}

void Gegenstandsliste::schreibe_invisible_hotspots_kurz() const {
  string out= "Unsichtbare Objekte: ";
  int anz=0;
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
    if(!ptr->ist_sichtbar() && ptr->in_akt_raum()) {
      if(++anz!=1)
        out+=", ";
      out+= start_capitalized(Spiel::convert_output(ptr->get_name()));
#ifdef FDEBUG
      out+=" ("+::to_string(ptr->get_id())+","+::to_string(ptr->get_zustand())+")";
#endif
    }
  }
  cout << "\n" << Spiel::fmt(out);
}

int Gegenstandsliste::berechne_chk(const string&  s, int v) const {
  string lc = trim(s);
  int chk=0;
  for(unsigned int i=0; i<lc.size(); ++i)
    chk+=lc[i]*(i+v+1);

  return chk;
}


bool Gegenstandsliste::serialisieren(Spiel* spiel, const std::string& datei) const {

  stringstream sstr;
  sstr << objekte.size() << "," << spiel->get_akt_raum()->get_id();
  int chk=0;
  chk+=berechne_chk(sstr.str(),23);
  ofstream ostr(datei);
  if(!ostr.is_open())
    return false;
  ostr << sstr.str() << "\n";
  int lpos=0;
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter,++lpos) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
    chk+=berechne_chk(ptr->serialisieren(), lpos);
    ostr << ptr->serialisieren() << "\n";
  }

  ostr << chk << "\n";
  ostr.close();
  return true;

}

bool Gegenstandsliste::deserialisieren(Spiel* spiel, const std::string& datei) {
  ifstream istr(datei);
  if(!istr.is_open()) {
    cout << "\nDatei nicht gefunden!\n";
    return false;
  }

  int chk=0;
  string header;
  getline(istr, header);
  chk+=berechne_chk(header,23);
  auto headerdata = explode(header,",");
  unsigned int ganz=::stoi(headerdata[0]);
  int raum=::stoi(headerdata[1]);

  if(ganz!=objekte.size()) {
    cout << "Fehler: Savegame einer anderen Spielversion!" << endl;
    return false;
  }
//  ostringstream osstr;
  string inp;
  vector<string> lines;
  for(unsigned int i=0; i<ganz; ++i) {
    getline(istr, inp);
    chk+=berechne_chk(inp,i);
    lines.push_back(inp);
  }
  getline(istr, inp);
  if(::stoi(inp)!=chk) {
    cout << "\nDatei fehlerhaft!\n";
    return false;
  }
  istr.close();

  int lpos=0;
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter, ++lpos) {
    Gegenstand* ptr=dynamic_cast<Gegenstand*>((*iter).get());
    ptr->deserialisieren(lines[lpos]);
  }

  spiel->wechsel_raum(raum);

  return true;
}

void Gegenstandsliste::xml_out(std::ostream& ostr) const {
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    Gegenstand* r=dynamic_cast<Gegenstand*>((*iter).get());
    r->xml_out(ostr);
  }
}
