/*
 * Gegenstand.h
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#ifndef GEGENSTAND_H_
#define GEGENSTAND_H_

#include "Spiel.h"
#include "Raum.h"
#include "BenanntesObjekt.h"
#include "XMLObjekt.h"
#include <vector>

class Gegenstand : public BenanntesObjekt, public XMLObjekt {
  std::string bezeichnung;
  bool fest;
  bool ablegbar;
  bool sichtbar;

  id_type akt_pos, original_pos;  // -1 non-phys, 0 Inventar, 1- Rume
  int zustand;
  std::vector<int> variablen;

public:
  virtual void analyse() const;
  Gegenstand(Spiel* spiel, id_type id, std::string name, std::string bez, bool _fest, bool _ablegbar, bool _sichtbar, id_type pos, int z=0, int v1=0);
  virtual ~Gegenstand() {
  }

  std::string get_bezeichnung() const {
    return bezeichnung;
  }

  bool ist_sichtbar() const {
    return sichtbar;
  }

  void set_sichtbar(bool s) {
    sichtbar = s;
  }

  bool ist_fest() const {
    return fest;
  }

  id_type get_akt_pos() const {
    return akt_pos;
  }

  void set_akt_pos(id_type r) {
    akt_pos = r;
  }

  int get_zustand() const {
    return zustand;
  }

  void set_zustand(int z) {
    zustand = z;
  }

  bool in_inventar() const {
    return akt_pos==0;
  }

  bool an_org_pos() const {
    return akt_pos==original_pos;
  }

  bool in_akt_raum() const {
    return akt_pos==get_spiel()->get_akt_raum()->get_id();
  }


  std::string serialisieren() const;
  void deserialisieren(const std::string& s);

  virtual void xml_out(std::ostream& ostr) const;
};

#endif /* GEGENSTAND_H_ */
