/*
 * Gegenstand.cpp
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#include "Gegenstand.h"
#include "Spiel.h"
#include "Objektanalyzer.h"
#include "Stringfunktionen.h"

#include <iostream>

using namespace std;

void Gegenstand::analyse() const {Objektanalyzer::analyse(this); }

Gegenstand::Gegenstand(Spiel* spiel, id_type id, string name, string bez, bool _fest, bool _ablegbar, bool _sichtbar, id_type pos, int z, int v1)
 : BenanntesObjekt(spiel, id, name), bezeichnung(bez), fest(_fest), ablegbar(_ablegbar), sichtbar(_sichtbar), akt_pos(pos), original_pos(pos), zustand(z) {
  variablen.push_back(v1);

}

string Gegenstand::serialisieren() const {
  return ::to_string(get_id())+","+
         ::to_string(fest)+","+
         ::to_string(ablegbar)+","+
         ::to_string(sichtbar)+","+
         ::to_string(akt_pos)+","+
         ::to_string(zustand)+","+
         ::to_string(variablen[0]);
}

void Gegenstand::deserialisieren(const string& s) {
  auto werte = explode(s,",");
  if(get_id()!=::stoi(werte[0])) {
    cout << "ID stimmt nicht!" << endl;
    return;
  }
  fest=::stob(werte[1]);
  ablegbar=::stob(werte[2]);
  sichtbar=::stob(werte[3]);
  akt_pos=::stoi(werte[4]);
  zustand=::stoi(werte[5]);
  variablen[0]=::stoi(werte[6]);
}

void Gegenstand::xml_out(std::ostream& ostr) const {
  ostr << "<item id=\"" << get_id() << "\" name=\"" << get_name() << "\"" ;
  if(get_name()!=bezeichnung) ostr << " lname=\"" << bezeichnung << "\"";
  ostr << " state=\"" << zustand << "\"" ;
  ostr << " position=\"" << akt_pos << "\"" ;
  if(fest) ostr << " fixed=\"fixed\"";
  if(sichtbar) ostr << " visible=\"visible\"";
  if(ablegbar) ostr << " dropable=\"dropable\"";

  ostr << " />\n";
}

