/*
 * Flucht.cpp
 *
 *  Created on: 28.05.2014
 *      Author: Andr Willms
 */

#include "Flucht.h"
#include "AktionBedingt.h"
#include "Aktionen.h"
#include "Bedingungen.h"
#include "BedingungOder.h"
#include "spiel_const.h"
#include "flucht_const.h"
#include "Spiel.h"
#include "Spielregel.h"
#include "Spielregelliste.h"
#include "Gegenstand.h"
#include <iostream>

using namespace std;

Flucht::Flucht() {
  erzeuge_spielstruktur();

  set_titel("Flucht V0.86 (c) Andre Willms");
  set_starttext("Flucht V0.85 - Verlasse das Haus unverletzt und unbemerkt\n\nEin Text-Adventure von Andre Willms\n------------------------------------------------------------\n \n \nDumm gelaufen. Eigentlich wolltest du nur kurz klingeln und nach dem Weg "
          "fragen, als die Diebe aus dem Haus strmten, dich in den Flur schubsten "
          "und dreist auch noch hinter dir die Tr abschlossen.\n"
          "Jetzt musst du zusehen, "
          "wie du unbemerkt wieder aus dem Haus kommst, ansonsten denken alle, du "
          "wrst es gewesen. Viel Glck!\n");

#ifndef FDEBUG
  wechsel_raum(100);
#else
  wechsel_raum(100);
  // Testsituationen
/*
//  get_gegenstaende()->get_gegenstand_by_id(1814)->set_zustand(1); // Strom aus

  get_gegenstaende()->get_gegenstand_by_id(1133)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1133)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(1117)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1117)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(225)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(225)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(15)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(15)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(16)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(16)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(17)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(17)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(18)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(18)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(20)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(20)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(10)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(10)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(21)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(21)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(22)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(22)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(23)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(23)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(417)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(417)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(420)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(420)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(1515)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1515)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(1516)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1516)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(1930)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1930)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(26)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(26)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(660)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(660)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(660)->set_zustand(4);
  get_gegenstaende()->get_gegenstand_by_id(612)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(612)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(808)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(808)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(908)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(908)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(515)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(515)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(540)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(540)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(1530)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1530)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(2410)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(2410)->set_akt_pos(0);
//  get_gegenstaende()->get_gegenstand_by_id(27)->set_sichtbar(true);
//  get_gegenstaende()->get_gegenstand_by_id(27)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(2520)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(2520)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(906)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(906)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(2245)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(2245)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(1632)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1632)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(1706)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(1706)->set_akt_pos(0);
  get_gegenstaende()->get_gegenstand_by_id(27)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(27)->set_akt_pos(0);

  get_gegenstaende()->get_gegenstand_by_id(380)->set_sichtbar(true);
  get_gegenstaende()->get_gegenstand_by_id(385)->set_sichtbar(true);

  get_gegenstaende()->get_gegenstand_by_id(1630)->set_zustand(CEXT::ST_HUND_SCHLAEFT);
  get_gegenstaende()->get_gegenstand_by_id(807)->set_zustand(2);
*/
#endif

}

void Flucht::erzeuge_spielstruktur() {
  Spielregel* r=nullptr;
  AktionBedingt* a=nullptr;
  BedingungOder* b=nullptr;

/*
 *  Rume
 */

  erzeuge_raum(100, "Flur, Erdgeschoss", "Du befindest dich auf einem Flur im Erdgeschoss.");
  erzeuge_raum(200, "Flur, Erdgeschoss, hinterer Teil", "Du befindest dich im hinteren Teil des Flurs. Hier ist es schon etwas dunkler, aber alles ist noch gut zu erkennen.");
  erzeuge_raum(300, "Kche", "Die Kche besteht hauptschlich aus einer groen Kchenzeile mit Arbeitsflche, die sich an fast der gesamten Fensterwand und der Wand dir gegenber erstreckt.");
  erzeuge_raum(400, "Esszimmer", "Das Esszimmer ist wie geschaffen fer ein gemtliches Mahl im Kreise der Familie.\nDurch die rechte Wand fhrt ein Durchbruch direkt ins Wohnzimmer.");
  erzeuge_raum(500, "Wohnzimmer", "Der Wohnbereich des groen Zimmers ist spartanisch eingerichtet.");
  erzeuge_raum(600, "Toilette", "Das ist das Gsteklo des Hauses. Klein, aber fein.");
  erzeuge_raum(700, "Flur, 1. Stock", "Du steht im Flur des 1. Stocks. Von hier aus geht es wieder zu anderen Rumen.\nDurch den Durchgang links kommst du ins Bad.");
  erzeuge_raum(800, "Kellerflur", "Du bist im khlen Kellerflur. Die Decke ist hier sehr niedrig. Der Boden ist gefliest, die Betonwnde sind unverputzt.");
  erzeuge_raum(900, "Vorratsraum", "Dies ist der Vorratsraum des Hauses.");
  erzeuge_raum(1000, "Fernsehzimmer", "Das Fernsehzimmer macht seinem Namen alle Ehre. Die linke Wand ist komplett mit DVD-Regalen bedeckt.");
  erzeuge_raum(1100, "Schreibtisch", "Auf dem Schreibtisch steht alles, was man fer die Arbeit mit dem Computer braucht.");
  erzeuge_raum(1200, "Tastatur", "Der Ausgabe auf dem Bildschirm nach zu urteilen ist die Anzahl sinnvoller Eingaben bersichtlich.");
  erzeuge_raum(1300, "Werkecke", "Fr eine Werkecke sieht es hier ausgesprochen aufgerumt aus.");
  erzeuge_raum(1400, "Heizungsraum", "Der Heizungsraum ist nicht sehr gro.");
  erzeuge_raum(1500, "Lesebereich", "Du stehst im intellektuellen Teil des Wohnzimmers, der primr der Bildung dient.");
  erzeuge_raum(1600, "Garten", "Der Garten ist sehr gepflegt und stilvoll bepflanzt. An den eingrenzenden Mauern wachsen Rosen in unterschiedlichen Gelbtnen.");
  erzeuge_raum(1700, "Gartenhaus", "Die Germpelkammer des Gartens. Allerlei Gartenmbel und Grillaccessoires stehen herum.");
  erzeuge_raum(1800, "Sicherungskasten", "");
  erzeuge_raum(1900, "Lampengehuse", "");
  erzeuge_raum(2000, "Bad", "Die Wnde und der Boden des Bades sind vollstndig gefliest.\nAn der Frontwand ist ein Fenster, dessen Jalousien bis auf Lichtschlitze geschlossen sind.");
  erzeuge_raum(2100, "Schlafzimmer", "Das Schlafzimmer ist in warmen Rottnen gehalten.");
  erzeuge_raum(2200, "Kinderzimmer", "Das Zimmer ist kindgerecht eingerichtet. Die Tapeten sind bunt und auf den Teppich sind Straen gedruckt.");
  erzeuge_raum(2300, "Waschraum", "Der Waschraum ist verhltnismig leer.");
  erzeuge_raum(2400, "Schublade", "");
  erzeuge_raum(2500, "Nachtschrank", "");
  erzeuge_raum(2600, "Dachboden", "Hier oben staut sich die Hitze des Tages. Allerlei Kisten und Plunder stehen herum.");
  erzeuge_raum(2700, "Dach", "Du stehst auf dem Dach des Gartenhauses. Von hier aus fhrt die Grundstcksmauer direkt zur Terrasse des Hauses.");
  erzeuge_raum(2800, "Mauer", "Du balancierst auf der Grundstckmauer.");
  erzeuge_raum(2900, "Nachbargrundstck", "");
  erzeuge_raum(3000, "Vor dem Haus", "Du befindest dich vor dem Haus auf dem Weg zur Strae. Nicht mehr weit und du hast es geschafft.");
  erzeuge_raum(3100, "Strae", "");

/*
 * Raumbergnge
 */

  erzeuge_zweiweg_verbindung(100,200,     100000,"vor", true,   100010,"zurck", true);
  erzeuge_zweiweg_verbindung(100,300,     100020,"kche", true,   100030,"flur", true);
  erzeuge_zweiweg_verbindung(300,400,     100040,"esszimmer", true,   100050,"kche", true);
  erzeuge_zweiweg_verbindung(200,400,     100060,"esszimmer", true,   100070,"flur", true);
  erzeuge_zweiweg_verbindung(400,500,     100080,"wohnzimmer", true,   100090,"esszimmer", true);
  erzeuge_zweiweg_verbindung(100,600,     100100,"toilette", true,   100110,"flur", true);
  erzeuge_zweiweg_verbindung(100,700,     100120,"treppe", true,   100130,"treppe", true);
  erzeuge_zweiweg_verbindung(200,800,     100140,"treppe", true,   100150,"treppe", true);
  erzeuge_zweiweg_verbindung(800,900,     100160,"vorratsraum", true,   100170,"flur", true);
  erzeuge_zweiweg_verbindung(800,1000,    100180,"fernsehzimmer", true,   100190,"flur", true);
  erzeuge_zweiweg_verbindung(1000,1100,   100200,"schreibtisch", true,   100210,"fernsehzimmer", true);
  erzeuge_zweiweg_verbindung(900,1300,    100220,"werkecke", true,   100230,"vorratsraum", true);
  erzeuge_zweiweg_verbindung(900,1400,    100240,"heizungsraum", true,   100250,"vorratsraum", true);
  erzeuge_zweiweg_verbindung(500,1500,    100260,"lesebereich", true,   100270,"wohnbereich", true);
  erzeuge_zweiweg_verbindung(1500,1600,   100280,"garten", false,   100290,"wohnzimmer", false);
  erzeuge_zweiweg_verbindung(1600,1700,   100300,"gartenhaus", false,   100310,"garten", false);
  erzeuge_zweiweg_verbindung(700,2000,   100320,"bad", true,   100330,"flur", true);
  erzeuge_zweiweg_verbindung(700,2100,   100340,"schlafzimmer", false,   100350,"flur", false);
  erzeuge_zweiweg_verbindung(700,2200,   100360,"kinderzimmer", true,   100370,"flur", true);
  erzeuge_zweiweg_verbindung(800,2300,   100380,"waschraum", true,   100390,"flur", true);
  erzeuge_zweiweg_verbindung(2200,2600,   100400,"dachboden", false,   100410,"kinderzimmer", true);
  erzeuge_zweiweg_verbindung(1700,2700,   100420,"dach", false,   100430,"gartenhaus", true);
  erzeuge_zweiweg_verbindung(2700,2800,   100440,"mauer", true,   100450,"dach", true);
  erzeuge_einweg_verbindung(2800,2900,   100460,"nachbargrundstck", true);
  erzeuge_einweg_verbindung(2800,1500,   100470,"wohnzimmer", true);
  erzeuge_einweg_verbindung(2800,1600,   100480,"garten", true);
  erzeuge_zweiweg_verbindung(100,3000,   100490,"frontgarten", false,   100500,"hausflur", false);
  erzeuge_zweiweg_verbindung(3000,3100,   100510,"strae", true,   100520,"frontgarten", false);

/*
 * Tren
 */

// Flur EG - Kche

  r = erzeuge_oeffnen(200020, ST_TUER_GESCHLOSSEN, ""); {
    r->add_trigger(CMD_OEFFNE,200030, -1);
    r->add_aktion(new AktionObjektSetSichtbar(this, 380, false));
    a= new AktionBedingt(this, r, new BedingungObjektNichtInInventar(this, 385)); {
      a->add_aktion(new AktionObjektSetSichtbar(this, 385,false));
    }
  }
  r = erzeuge_schliessen(200020, ST_TUER_OFFEN, ""); {
    r->add_trigger(CMD_SCHLIESSE,200030, -1);
    r->add_aktion(new AktionObjektSetSichtbar(this, 380, true));
    a= new AktionBedingt(this, r, new BedingungObjektNichtInInventar(this, 385)); {
      a->add_aktion(new AktionObjektSetSichtbar(this, 385,true));
    }
  }

  erzeuge_tuer(100,300,100020,100030, 200020, 200030, ST_TUER_VERSCHLOSSEN, "Holztr", "eine Holztr", "Du ffnest die Tr. Der Weg zur Kche ist frei.", "Kchentr","eine Kchentr", "Du kannst jetzt wieder in den Flur.", "Du schliet die Kchentr.","");
  get_regeln()->add_regel(r=new Spielregel(this, CMD_BESCHREIBEN, -1, -1)); {
    r->add_bedingung(new BedingungObjektInAktRaum(this, 200020));
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 200020, ST_TUER_GESCHLOSSEN),
                                             new BedingungObjektHatZustand(this, 200020, ST_TUER_VERSCHLOSSEN)));
    r->add_aktion(new AktionTextausgabe(this, "An der linken Wand ist eine braune, aber geschlossene Holztr."));
  }
  erzeuge_beschreibung(200020, ST_TUER_OFFEN, "Links geht es in die Kche.");
  erzeuge_oeffnen(200020, ST_TUER_VERSCHLOSSEN, "Die Tr ist verschlossen.");
  erzeuge_untersuchung(200020, ST_TUER_VERSCHLOSSEN, POS_EGAL, "Ohne Schlssel ist da wohl nichts zu machen.");

// Flur EG - Gsteklo
  erzeuge_tuer(100,600,100100,100110, 200000, 200010, ST_TUER_GESCHLOSSEN, "klotr", "eine Klotr", "Du ffnest die Tr und siehst wie erwartet in die Gstetoilette.", "tr","eine Tr", "Der Weg zum Flur ist wieder frei.", "Die Toilettentr ist nun wieder geschlossen.","");
  erzeuge_beschreibung(200000, ST_TUER_GESCHLOSSEN, "Auf der rechten Seite siehst du eine ebenfalls braune Holztr. Dem auen angebrachten Lichtschalter nach zu urteilen fhrt sie zum Gsteklo.");
  erzeuge_beschreibung(200000, ST_TUER_OFFEN, "Die Tr zur Gstetoilette steht offen.");
  erzeuge_untersuchung(200000,-1,POS_EGAL, "Das ist die Tr zur Toilette.");

// Flur EG - Flur OG
  erzeuge_einseitige_tuer(100,100120,100130, 200040, ST_TUER_VERSCHLOSSEN, "Kindergitter", "ein Kindergitter", "Du ffnest das Gitter wie in der Anleitung beschrieben. Auf zur nchsten Etage.", "","Das Gitter lassen wir besser offen, nachher verlierst du noch die Anleitung.");
  get_regeln()->add_regel(r=new Spielregel(this, CMD_BESCHREIBEN, -1, -1)); {
    r->add_bedingung(new BedingungObjektInAktRaum(this, 200040));
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 200040, ST_TUER_GESCHLOSSEN),
                                             new BedingungObjektHatZustand(this, 200040, ST_TUER_VERSCHLOSSEN)));
    r->add_aktion(new AktionTextausgabe(this, "Ein Stck hinter der Toilettentr fhrt eine Treppe in die 1. Etage. Sie ist mit einem Kindergitter versperrt."));
  }
  erzeuge_beschreibung(200040, ST_TUER_OFFENBLOCKIERT, "Ein Stck hinter der Toilettentr fhrt eine Treppe in die 1. Etage.");
  r=erzeuge_oeffnen(200040, ST_TUER_VERSCHLOSSEN, "Du machst dich dran, den Mechanismus zu begreifen, aber scheiterst klglich. Mal ein wirklich sicheres Gitter."); {
    r->add_trigger(CMD_BENUTZE, 200040, -1);
  }
  r=erzeuge_kombination(26,200040, -1, ST_TUER_VERSCHLOSSEN, POS_EGAL, POS_EGAL, "Du schaust auf die Bauanleitung, dann auf das Gitter, dann wieder auf die Bauanleitung, und wieder auf das Gitter. So geht es eine Weile, bist du endlich den Mechanismus durchschaut hast."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 200040, ST_TUER_GESCHLOSSEN));
  }
  erzeuge_untersuchung(200040, -1 , POS_EGAL, "Das Kindergitter dient wohl dazu, Kinder nicht unbeaufsichtigt die Treppe gehen zu lassen.");

// Flur EG - Esszimmer
  r=erzeuge_oeffnen(200050, ST_TUER_GESCHLOSSEN); {
    r->add_aktion(new AktionObjektSetSichtbar(this,200, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,CEXT::OBJ_ESSSCHLUESSEL, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,202, false));
  }
  erzeuge_tuer(200,400,100060,100070, 200050, 200060, ST_TUER_VERSCHLOSSEN, "Holztr", "eine Holztr", "Du ffnest die Tr. So wie es aussieht, fhrt sie in das Esszimmer.", "tr","eine Tr", "Du kannst jetzt wieder in den Flur.", "","Wir lassen sie besser geffnet.");

// Flur KG - Fernsehraum
  erzeuge_tuer(800,1000,100180,100190, 200070, 200080, ST_TUER_GESCHLOSSEN, "tr", "eine Tr", "Du ffnest die Tr zum Fernsehraum.", "tr","eine Tr", "Der Weg zum Flur ist wieder frei.", "Die Tr ist nun wieder zu.","");

// Flur KG - Vorratsraum
  erzeuge_einseitige_tuer(800,100160,100170, 200090, ST_TUER_VERSCHLOSSEN, "metalltr", "eine Metalltr", "Du ffnest die massive Metalltr mit einem krftigen Ruck.", "","Es war schon schwer genug, sie auf zu drcken.");
//  erzeuge_tuer(800,900,100160,100170, 200090, 200100, ST_TUER_VERSCHLOSSEN, "metalltuer", "eine Metalltuer", "Du ffnest die massive Metalltuer mit einem krftigen Ruck.", "metalltuer","eine Metalltuer", "Der Weg zum Flur ist wieder frei.", "","Es war schon schwer genug, sie auf zu druecken.");

// Kueche - Esszimmer
  erzeuge_tuer(300,400,100040,100050, 200100, 200110, ST_TUER_VERSCHLOSSEN, "schiebetr", "eine Schiebetr", "Du schiebst die Tr auf und machst den Weg frei ins Esszimmer.", "schiebetr","eine Schiebetr", "Der Weg zur Kche ist frei.", "","Die bleibt besser aufgeschoben.");

// Flur OG - Kinderzimmer
  erzeuge_tuer(700,2200,100360,100370, 200120, 200130, ST_TUER_GESCHLOSSEN, "holztr", "eine Holztr", "Du ffnest die Tr und siehst in einen Raum, der aussieht wie das Kinderzimmer.", "tr","eine Holztr", "Der Weg in den Flur ist wieder frei.", "Du schliesst die Tr","");



/*
 * Objekte/Gegenstnde
 */

// Startinventar

  erzeuge_gegenstand(1,0,false,false,true,"Zettel", "ein Zettel");
  erzeuge_untersuchung(1,-1,POS_EGAL, "Auf dem Zettel steht:\n \nKarl-Ernst-von-Hallenbacken-Reuther-Str. 42\n \nDas ist die Adresse, nach der du fragen wolltest.");
  erzeuge_benutzung(1,-1,POS_EGAL, "Du weit immer noch nicht, wie du dort hin kommst...");

  erzeuge_gegenstand(2,0,false,false,true,"kleidung", "deine Kleidung", "", 0);
  r=erzeuge_untersuchung(2,0,POS_EGAL, "Siehst ja richtig schnieke aus."); {
    a=new AktionBedingt(this, r, new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN),
                                             new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_SAUBERGETRAGEN)));
    a->add_aktion(new AktionTextausgabe(this, "Die Schrze schmlert das Gesamterlebnis allerdings etwas."));
  }
  r=erzeuge_untersuchung(2,1,POS_EGAL, "Siehst ja richtig schnieke aus. Bis auf die Blutspritzer auf deinem Hemd..."); {
    a=new AktionBedingt(this, r, new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN),
                                             new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_SAUBERGETRAGEN)));
    a->add_aktion(new AktionTextausgabe(this, "Die Schrze schmlert das Gesamterlebnis zustzlich."));
  }
  erzeuge_benutzung(2, 0,POS_EGAL, "Was? Moment mal, so ein Spiel ist das hier nicht.");
  erzeuge_kombination(2, 640, -1, -1, POS_EGAL, POS_EGAL, "Bei deinen Ideen bekomme ich den Eindruck, das ist nicht das richtige Spiel fr dich.");
  erzeuge_kombination(CEXT::OBJ_FEUERZEUG, 2, -1, -1, POS_EGAL, POS_EGAL, "Bist du irre?");

  erzeuge_gegenstand(CEXT::OBJ_FEUERZEUG,0,false,false,false,"feuerzeug", "ein Feuerzeug","",5);
  get_regeln()->add_regel(r=new Spielregel(this, CMD_BENUTZE, CEXT::OBJ_FEUERZEUG, -1)); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du schaust vertrumt in die Flamme. Als dir klar wird, dass du gerade unntig Gas verbrauchst, machst du das Feuerzeug schnell wieder aus."));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1)); { // Zettel
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme an den Zettel, der sofort Feuer fngt und zu Asche verbrennt."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 102)); { // Haarknuel
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Das Haarknuel macht *wusch* und brig bleibt nur noch der Geruch verbrannter Haare."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 102, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 225)); { // Dbelschraube
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst die Schraube mit dem Dbel ber die Flamme und beobachtest das schmilzende Plastik. Beim Erkalten verklebt es vollstndig und unlsbar mit der Schraube."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 225, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 15, true));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1131)); { // Ausdrucke
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1132);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1133);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1134);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1135);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1136);
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Die Pappe der Visitenkarte braucht lnger, um Feuer zu fangen, aber schlussendlich verbrennt auch sie."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1131, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1132, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1133, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1134, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1135, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1136, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 18)); { // DINA4-Blatt
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst das Feuerzeug an eine Ecke des Blattes. Schnell wandert der Glutrand ber das Papier und hinterlsst nur noch schwarzgraue Asche. Zum Glck hat sonst nichts Feuer gefangen."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 18, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 21)); { // Metallstange
    r->add_bedingung(new BedingungObjektHatZustand(this, 21, 0));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme an die Metallstange und bist berrascht, wie schnell Metall Hitze bertrgt.\nMit einer Brandblase am Finger packst du die Stange wieder weg."));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 21)); { // Metallstange mit Plastikschutz
    r->add_bedingung(new BedingungObjektHatZustand(this, 21, 2));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme nochmal an das Plastik. Es verformt sich weiter, bis Teile davon von der Stange tropfen."));
    r->add_aktion(new AktionObjektNeuerZustand(this, 21, 3));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 21)); { // Metallstange mit Dbel
    r->add_bedingung(new BedingungObjektHatZustand(this, 21, 1));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du lsst die Flamme vorsichtig ber den Dbel wandern, bis sich das Plastik fast gleichmig ber das Metall legt."));
    r->add_aktion(new AktionObjektNeuerZustand(this, 21, 2));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1820)); { // Sicherungsnotizzettel
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Der Zettel verbrennt schneller als du Feuerwehr rufen kannst. Hoffentlich hast du ihn vorher gelesen."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1820, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 16)); { // Dbel
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Der Dbel zieht sich unter der Flamme zusammen zu einem kugelhnlichen Objekt."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 16, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 22, true));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 23)); { // Stromkabel
    r->add_bedingung(new BedingungObjektHatZustand(this, 23, 0));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du brennst das Plastik an den Enden ab und legst damit die Adern des Kabels frei."));
    r->add_aktion(new AktionObjektNeuerZustand(this, 23, 1));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 26)); { // Bauanleitung
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "So eine berraschung, die Anleitung brennt wie jedes andere Papier auch."));
    r->add_aktion(new AktionObjektSetSichtbar(this, 26, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, CEXT::OBJ_HANDTUCH)); { // Handtuch
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst das Handtuch an einer Ecke hoch und zndest es an einer unteren Ecke an. Schnell steht das Handtuch in Flammen. Mit Mhe verhinderst du ein berspringen des Feuers auf andere Gegenstnde."));
    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_HANDTUCH, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 2142)); { // Plastikschloss
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme dicht an das Schloss, aber es wird nicht hei genug, um zu schmilzen. Wenn wir nur einen Leiter htten."));
//    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_HANDTUCH, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 17)); { // Schraube in Inventar
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme an die Schraube und bist berrascht, wie schnell Metall Hitze bertrgt.\nMit einer Brandblase am Finger packst du die Schraube wieder weg."));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 2144)); { // Schraube im Schloss, halb drin
    r->add_bedingung(new BedingungObjektHatZustand(this, 2144, 0));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme an die Schraube. Das Plastikschloss wird weich an der Oberflche, aber die Hitze dringt nicht weit genug ein."));
//    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_HANDTUCH, false));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 2144)); { // Schraube im Schloss, ganz drin
    r->add_bedingung(new BedingungObjektHatZustand(this, 2144, 1));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionObjektZustandCountTo(this, CEXT::OBJ_FEUERZEUG, 0));

    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1007, 0));
    a->add_bedingung(new BedingungObjektHatZustand(this, 1540, 2));
    a->add_bedingung(new BedingungObjektHatZustand(this, 2150, 0));
    a->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme an die Schraube. Das Plastikschloss schmilzt komplett weg und schwarzer Rauch steigt auf, der sofort aus dem Fenster geweht wird."));
    a->add_aktion(new AktionObjektNeuerZustand(this, 2140, 1));
    a->add_aktion(new AktionObjektNeuerZustand(this, 2142, 3));
    a->add_aktion(new AktionObjektSetSichtbar(this, 2144, false));

    a=new AktionBedingt(this, r, b=new BedingungOder(this));
    b->add_bedingung(new BedingungObjektHatNichtZustand(this, 1007, 0));
    b->add_bedingung(new BedingungObjektHatNichtZustand(this, 1540, 2));
    b->add_bedingung(new BedingungObjektHatNichtZustand(this, 2150, 0));
    a->add_aktion(new AktionTextausgabe(this, "Du hltst die Flamme an die Schraube. Das Plastikschloss schmilzt komplett weg und schwarzer Rauch steigt auf. Auf diesen reagiert sofort der Rauchmelder, der die gesamte Nachbarschaft alarmiert."));
    a->add_aktion(new AktionSpielVerloren(this));
  }

  get_regeln()->add_regel(r=new Spielregel(this, CMD_BENUTZE, CEXT::OBJ_FEUERZEUG, -1)); { // Feuerzeug leer
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 102);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 225);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1131);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1132);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1133);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1134);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1135);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1136);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 18);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 1820);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 21);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 23);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 26);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, CEXT::OBJ_HANDTUCH);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 17);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 2142);
    r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FEUERZEUG, 2144);
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_FEUERZEUG, 0));
    r->add_aktion(new AktionTextausgabe(this, "Das Feuerzeug hat entweder kein Gas mehr oder ist nass geworden."));
  }

  erzeuge_kombination(CEXT::OBJ_FEUERZEUG, 205, -1, -1, POS_EGAL, POS_EGAL, "Dafr wrde das Feuerzeug nicht lange genug brennen.");
  erzeuge_druecken(CEXT::OBJ_FEUERZEUG,-1,POS_EGAL, "Wohin willst du es denn drcken? Benutz es lieber.");
  erzeuge_untersuchung(CEXT::OBJ_FEUERZEUG,5,POS_EGAL, "Eines dieser gasbetriebenen Sturmfeuerzeuge, die am besten fr kurze Flammen geeignet sind. Die Fllanzeige zeigt das Feuerzeug zu etwa einem Viertel gefllt.");
  erzeuge_untersuchung(CEXT::OBJ_FEUERZEUG,4,POS_EGAL, "Die Fllstandsanzeige zeigt weniger Gas an als vorher.");
  erzeuge_untersuchung(CEXT::OBJ_FEUERZEUG,3,POS_EGAL, "Du kannst bei jeder Benutzung frmlich zusehen, wie die Fllstandsanzeige sinkt.");
  erzeuge_untersuchung(CEXT::OBJ_FEUERZEUG,2,POS_EGAL, "Viel Gas ist nicht mehr drin. Ich hoffe, du nutzt das Feuerzeug sinnvoll.");
  erzeuge_untersuchung(CEXT::OBJ_FEUERZEUG,1,POS_EGAL, "Das Gas im Feuerzeug reicht bestenfalls noch fr einen Einsatz.");
  erzeuge_untersuchung(CEXT::OBJ_FEUERZEUG,0,POS_EGAL, "Das komplette Gas im Feuerzeug ist verbraucht.");

  erzeuge_gegenstand(15,0,false,false,false,"geschmolzenr Dbel", "ein geschmolzener Dbel");
  erzeuge_untersuchung(15,-1,POS_EGAL, "Sieht nicht so aus, als knnte dieser Klumpen noch sinnvoll genutzt werden.");

  erzeuge_gegenstand(16,0,false,false,false,"dbel", "ein Dbel");
  erzeuge_untersuchung(16,-1,POS_EGAL, "Ein Dbel zum dbeln. Abgesehen von einigen Putzresten sieht er aus wie neu.");
  erzeuge_benutzung(16,-1,POS_EGAL, "Und wie willst du ihn benutzen? Die Kleiderstange reparieren? Gute Idee. Wenn der Hausbesitzer kommt, kannst du sagen, du wrst vom skandinavischen Mbel-Notdienst.");

  erzeuge_gegenstand(17,0,false,false,false,"schraube", "eine Schraube");
  erzeuge_untersuchung(17,-1,POS_EGAL, "Eine silberne Metallschraube der Gre M6. Vielleicht etwas grer. Oder kleiner. Kann auch sein.");
  erzeuge_benutzung(17,-1,POS_EGAL, "Einen etwas ausgearbeiteteren Plan fnde ich gut.");

  erzeuge_gegenstand(18,0,false,false,false,"DIN-A4 Blatt", "ein DIN-A4 Blatt");
  erzeuge_untersuchung(18,-1,POS_EGAL, "Ein weies Blatt der Gre DIN A4. Die Dicke schtze ich auf 80 Gramm.");
  erzeuge_benutzung(18,-1,POS_EGAL, "Willst du ein Flugzeug mit falten? Lass das besser!");

  erzeuge_gegenstand(20,0,false,false,false,"bartschlssel", "ein Bartschlssel");
  erzeuge_untersuchung(20,-1,POS_EGAL, "Der Schlssel ist so alt, der hat schon einen Bart.");
  erzeuge_benutzung(20,-1,POS_EGAL, "Erst mal die passende Tr finden.");
  erzeuge_kombination(20,100,-1,-1,POS_EGAL, POS_EGAL, "Die Haustr hat ein modernes Schloss, da passt der nicht mal rein.");
  erzeuge_kombination(20,200020,-1,-1,POS_EGAL, POS_EGAL, "Du schiebst ihn in das Schloss, aber bekommst ihn nicht gedreht.");

  erzeuge_gegenstand(21,0,false,false,false,"Metallstange", "eine Metallstange","", 0);
  erzeuge_untersuchung(21,0,POS_EGAL, "Eine kleine Metallstange, das, was vom Esszimmerschlssel brig geblieben ist.");
  erzeuge_untersuchung(21,1,POS_EGAL, "Die kleine Metallstange hat jetzt ein Plastikhtchen auf.");
  erzeuge_untersuchung(21,2,POS_EGAL, "Ein Ende der Metallstange ist jetzt vollstndig mit Plastik umhllt.");
  erzeuge_untersuchung(21,3,POS_EGAL, "Das Plastik verdeckt das Stangenende nur noch teilweise.");
  r = erzeuge_kombination(16,21,-1,0,POS_EGAL, POS_EGAL, "Du schiebst den Dbel ber ein Ende der Metallstange."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 21, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 16, false));
  }

  erzeuge_gegenstand(22,0,false,false,false,"plastikklumpen", "ein Plastikklumpen");
  erzeuge_untersuchung(22,-1,POS_EGAL, "Ein kleiner, fast runder Klumpen grauen Plastiks. Das in einem Museum wre wohl Kunst. Aber in deiner Tasche ist es wohl eher Mll.");
  erzeuge_benutzung(16,-1,POS_EGAL, "Wre er runder, knnten wir Klicker mit spielen.");

  erzeuge_gegenstand(23,0,false,false,false,"stromkabel", "ein Stromkabel","",0);
  erzeuge_untersuchung(23,0,POS_EGAL, "Ein etwa 50cm langes Stck Stromkabel.");
  erzeuge_benutzung(23,0,POS_EGAL, "Willst du mir ein Freundschaftsbndchen flechten?");
  erzeuge_untersuchung(23,1,POS_EGAL, "Das Stromkabel hat jetzt freigelegte und an den Enden abisolierte Adern.");
  erzeuge_benutzung(23,1,POS_EGAL, "Die absisolierten Adern pieksen zu sehr.");

  erzeuge_gegenstand(24,0,false,false,false,"kreuzschrauben", "kreuzschrauben");
  erzeuge_untersuchung(24,-1,POS_EGAL, "Vier Kreuzschrauben, mit denen das Lampengehuse an die Halterung geschraubt wird.");
  erzeuge_benutzung(24,1,POS_EGAL, "Zum jonglieren sind sie zu klein.");

  erzeuge_gegenstand(25,0,false,false,false,"lampenfassung", "eine Lampenfassung");
  erzeuge_untersuchung(25,-1,POS_EGAL, "Eine vom Kabel abgeschnittene Lampenfassung.");
  erzeuge_benutzung(25,1,POS_EGAL, "Ich wei momentan nicht, was wir damit machen sollten.");

  erzeuge_gegenstand(26,0,false,false,false,"bauanleitung", "eine Bauanleitung");
  erzeuge_untersuchung(26,-1,POS_EGAL, "Offenbar die Bauanleitung fr das unsgliche Kindergitter. Vielleicht bekommst du es ja damit auf...");
  erzeuge_benutzung(26,1,POS_EGAL, "Es gibt hier schon eins, da baue ich nicht noch ein weiteres.");

  erzeuge_gegenstand(27,0,false,false,false,"steak", "ein Steak", "", 0);
  erzeuge_untersuchung(27,0,POS_EGAL, "Ein gut abgeschnittenes Stck Steakfleisch, etwa 300 Gramm.");
  erzeuge_untersuchung(27,1,POS_EGAL, "Ein gut abgeschnittenes Stck Steakfleisch, etwa 300 Gramm, fein gewrzt mit Schlaftabletten.");
  erzeuge_benutzung(27,-1,POS_EGAL, "So lange sind wir jetzt auch noch nicht hier, dass wir schon rohes Fleisch essen mssten.");
  erzeuge_kombination(420, 27, -1, -1, POS_EGAL, POS_EGAL, "Willst du deine Initialen reinritzen?");
  erzeuge_kombination(2520, 27, -1, 1, POS_EGAL, POS_EGAL, "Der Gebrauchsanweisung nach sind zwei Tabletten eine zuviel.");
  r =erzeuge_kombination(2520, 27, -1, 0, POS_EGAL, POS_EGAL, "Du holst eine der Schlaftabletten aus der Packung, zerbrselst sie und pkelst damit das Fleisch."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 27, 1));
  }





// 1 Flur, vorderer Teil

  r=erzeuge_kombination(1530, 200020, -1, ST_TUER_VERSCHLOSSEN,POS_EGAL, POS_EGAL,"Du gehst die Schlssel des Schlsselbundes durch und der dritte passt schlielich. Mit ihm schliet du die Tr auf."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 200020, ST_TUER_GESCHLOSSEN));
    r->add_aktion(new AktionObjektNeuerZustand(this, 200030, ST_TUER_GESCHLOSSEN));
  }

  erzeuge_gegenstand(100,100,true,false,true,"Haustr", "eine Haustr", "Von hinten scheint Licht durch eine verglaste Haustr.",ST_TUER_VERSCHLOSSEN);
  erzeuge_untersuchung(100,ST_TUER_VERSCHLOSSEN,POS_EGAL, "Wre sie nicht verschlossen, httest du das Spiel bereits gewonnen... Htte, htte, Fahrradkette.");
  erzeuge_untersuchung(100,ST_TUER_OFFEN,POS_EGAL, "Endlich, der Weg nach drauen ist frei.");
  r=erzeuge_benutzung(100,ST_TUER_VERSCHLOSSEN,POS_EGAL, "Sie lsst sich nicht ffnen."); {
    r->add_trigger(CMD_OEFFNE, 100, -1);
  }
  erzeuge_druecken(100,ST_TUER_VERSCHLOSSEN,POS_EGAL, "Du willst mit der Tr aus dem Haus fallen? Ich glaube, das wrde den Nachbarn auffallen.");
  erzeuge_kombination(1530, 100, -1, -1,POS_EGAL, POS_EGAL,"Keiner der Schlssel passt. Wre auch zu schn gewesen.");
  r=erzeuge_kombination(1706, 100, -1, -1,POS_EGAL, POS_EGAL,"Mit Trnen der Freude in den Augen schliet du die Haustr auf."); {
    r->add_aktion(new AktionObjektSetSichtbar(this,100490, true));
    r->add_aktion(new AktionObjektNeuerZustand(this,100, ST_TUER_OFFEN));
  }

  erzeuge_gegenstand(102,100,false,false,true,"Haarknuel", "ein Haarknuel", "Direkt neben der Treppe in einer kleinen Ecke haben sich Haare gesammelt. Nicht gerade sauber hier.");
  r=erzeuge_nehmen(102, -1, true, "Das fngt ja gut an. Wenn du jetzt alles mitnimmst, trgst du auch alles alleine. Aber vielleicht brauchen wir es ja."); {
    r->add_bedingung(new BedingungObjektNichtInInventar(this, 102));
  }
  erzeuge_untersuchung(102, -1, POS_INVENTAR, "Die Haare sehen nach Hund aus und riechen auch so. Irgendwie beunruhigend, dass einer im Haus sein knnte, oder?");
  erzeuge_untersuchung(102, -1, POS_RAUM, "Aus der Entfernung kann ich nicht viel sagen.");
  erzeuge_benutzung(102, -1, POS_RAUM, "Zu weit weg.");
  erzeuge_benutzung(102, -1, POS_INVENTAR, "Falls du lichtes Haar hast, solltest du nach anderen Alternativen suchen.");

  erzeuge_gegenstand(101,100,true,false,true,"Lampe", "eine Lampe", "ber dir an der Decke hngt eine Lampe in Silberoptik, geformt wie ein Ufo.");
  erzeuge_benutzung(101, -1, POS_EGAL, "Es gibt keinen Schalter.");
  r=erzeuge_untersuchung(101, -1, POS_EGAL, "Die Lampe brennt, aber du siehst nirgendwo einen Schalter. Das Lampengehuse wird mit vier Schrauben zusammengehalten."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
  }
  r=erzeuge_untersuchung(101, -1, POS_EGAL, "Die Lampe ist aus. Das Lampengehuse wird mit vier Schrauben zusammengehalten."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
  }
  r=erzeuge_kombination(1515, 101,-1, -1, POS_EGAL, POS_EGAL, "Du streckst dich nach oben, schraubst das Gehuse auf und packst die Schrauben in die Tasche." ); {
    r->add_aktion(new AktionObjektSetSichtbar(this,24, true));
    r->add_aktion(new AktionRaumwechsel(this,1900));

  }
  r=erzeuge_gehe(100490, "Du hast gerade die Haustr hinter dir geschlossen, als ein Taxi hlt und die Hausbesitzer aussteigen. Sie kommen den Weg hoch.\nAls sie vor dir stehen ruft die Frau \"Heinz! Der Mann hat unseren Ersatzschlssel in der Hand!\".\nOhne ein Wort zu verlieren ruft Heinz die Polizei."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 1706));
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r=erzeuge_gehe(100490, "Du hast gerade die Haustr hinter dir geschlossen, als ein Taxi hlt und die Hausbesitzer aussteigen. Sie kommen den Weg hoch.\nAls sie vor dir stehen fragt der Mann \"Kann ich Ihnen irgendwie helfen?\""); {
    r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1706));
  }


// 2 Flur, hinterer Teil

  get_regeln()->add_regel(r=new Spielregel(this, CMD_BESCHREIBEN, -1, -1)); {
    r->add_bedingung(new BedingungObjektInAktRaum(this, 200050));
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 200050, ST_TUER_GESCHLOSSEN),
                                             new BedingungObjektHatZustand(this, 200050, ST_TUER_VERSCHLOSSEN)));
    r->add_aktion(new AktionTextausgabe(this, "An der linken Wand ist eine braune Holztr."));
  }
  erzeuge_beschreibung(200050, ST_TUER_OFFEN, "Links fhrt eine Tr in das Esszimmer.");
  erzeuge_oeffnen(200050, ST_TUER_VERSCHLOSSEN, "Die Tr ist verschlossen.");
  r=erzeuge_untersuchung(200050, ST_TUER_VERSCHLOSSEN, POS_EGAL, "Auer der reichlich verzierten Trklinke und dem groen Spalt unter der Tr ist nichts aufflliges zu sehen."); {
    r->add_aktion(new AktionObjektSetSichtbar(this,200, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,202, true));
  }
  r=erzeuge_kombination(20, 200050, -1, ST_TUER_VERSCHLOSSEN, POS_EGAL, POS_EGAL, "Du schliet die Tr auf."); {
    r->add_trigger(CMD_KOMBINIERE, 20, 200);
    r->add_aktion(new AktionObjektNeuerZustand(this,200050, ST_TUER_GESCHLOSSEN));
  }

  erzeuge_gegenstand(200,200,true,false,false,"trschloss", "ein Trschloss", "Das Schlsselloch unter der verzierten Klinke ist fr alte Schlssel mit Bart gedacht.", 0);
  r=erzeuge_untersuchung(200, -1, POS_EGAL, "Du schaust durch das Schlsselloch, der Raum auf der anderen Seite sieht aus wie ein Esszimmer."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_STECKT));
    r->add_aktion(new AktionObjektSetSichtbar(this,CEXT::OBJ_ESSSCHLUESSEL, true));
  }
  r=erzeuge_untersuchung(200, -1, POS_EGAL, "Du schaust durch das Schlsselloch, siehst aber nicht viel, weil von der anderen Seite ein Schlssel steckt."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_STECKT));
    r->add_aktion(new AktionObjektSetSichtbar(this,CEXT::OBJ_ESSSCHLUESSEL, true));
  }
  r=erzeuge_kombination(17, 200, -1, -1,POS_EGAL, POS_EGAL, "Du kratzt ber die Blende des Trschlosses, aber nichts passiert."); {
    r->add_trigger(CMD_KOMBINIERE,16, 200);
    r->add_trigger(CMD_KOMBINIERE,15, 200);
    r->add_trigger(CMD_KOMBINIERE,225, 200);
    r->add_trigger(CMD_KOMBINIERE,CEXT::OBJ_ZANGE, 200);
  }
  erzeuge_druecken(200, -1, POS_EGAL, "Da sind meine Finger zu dick fr.");

  erzeuge_gegenstand(CEXT::OBJ_ESSSCHLUESSEL,200,true,false,false,"schlssel", "ein Schlssel", "", 0);
  erzeuge_untersuchung(CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_STECKT, POS_EGAL, "Der Schlssel steckt von der anderen Seite im Schlsselloch.");
  erzeuge_untersuchung(CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_BLATT, POS_EGAL, "Der Schlssel liegt auf der anderen Seite der Tr auf dem Blatt Papier.");
  erzeuge_nehmen(CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_STECKT, false, "Da komme ich von dieser Seite nicht dran.");
  erzeuge_beschreibung(CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_STECKT, "Darin steckt von der anderen Seite ein Schlssel.");
  r=erzeuge_kombination(15, CEXT::OBJ_ESSSCHLUESSEL, -1, CEXT::ST_ESSSCHLUESSEL_STECKT,POS_EGAL, POS_EGAL, "Das ist zu dick fr das Schlsselloch."); {
    r->add_trigger(CMD_KOMBINIERE,16, CEXT::OBJ_ESSSCHLUESSEL);
    r->add_trigger(CMD_KOMBINIERE,225, CEXT::OBJ_ESSSCHLUESSEL);
    r->add_trigger(CMD_KOMBINIERE,CEXT::OBJ_ZANGE, CEXT::OBJ_ESSSCHLUESSEL);
  }
  r=erzeuge_kombination(17, CEXT::OBJ_ESSSCHLUESSEL, -1, CEXT::ST_ESSSCHLUESSEL_STECKT,POS_EGAL, POS_EGAL, "Du schiebst die Schraube durch das Schlsselloch, bis der Schlssel aus dem Schloss fllt. Dem dumpfen Gerusch nach zu urteilen, muss er auf das Blatt gefallen sein."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 203));
    r->add_aktion(new AktionObjektNeuerZustand(this,CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_BLATT));
  }
  r=erzeuge_kombination(17, CEXT::OBJ_ESSSCHLUESSEL, -1, CEXT::ST_ESSSCHLUESSEL_STECKT,POS_EGAL, POS_EGAL, "Du schiebst die Schraube durch das Schlsselloch, bis der Schlssel aus dem Schloss fllt. Er schlgt klirrend auf den Fliesen auf und springt unerreichbar weit weg."); {
    r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 203));
    r->add_aktion(new AktionObjektNeuerZustand(this,CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_WEG));
    r->add_aktion(new AktionObjektSetSichtbar(this,CEXT::OBJ_ESSSCHLUESSEL, false));
  }

  erzeuge_gegenstand(202,200,true,false,false,"trspalt", "ein Trspalt", "Durch den auffllig groen Bodenspalt der Tr schimmert knstliches Licht.", 0);
  erzeuge_untersuchung(202, 0, POS_EGAL, "Du kniest dich auf den Boden und versuchst, unter den Trspalt zu schauen, aber mehr als die Fliesen, sowie Tisch- und Stuhlbeine sind nicht zu erkennen.");
  erzeuge_kombination(1, 202, -1, 0,POS_EGAL, POS_EGAL, "Wenn du das vorhast, was ich denke, dann ist der Zettel dafr zu klein.");
  r=erzeuge_kombination(1131, 202, -1, 0,POS_EGAL, POS_EGAL, "Wenn du das vorhast, was ich denke, dann ist die Visitenkarte dafr zu klein."); {
    r->add_trigger(CMD_KOMBINIERE, 1132, 202);
    r->add_trigger(CMD_KOMBINIERE, 1133, 202);
    r->add_trigger(CMD_KOMBINIERE, 1134, 202);
    r->add_trigger(CMD_KOMBINIERE, 1135, 202);
    r->add_trigger(CMD_KOMBINIERE, 1136, 202);
  }
  r=erzeuge_kombination(1131, 202, -1, 1,POS_EGAL, POS_EGAL, "Du hast doch schon etwas unter die Tr geschoben."); {
    r->add_trigger(CMD_KOMBINIERE, 1132, 202);
    r->add_trigger(CMD_KOMBINIERE, 1133, 202);
    r->add_trigger(CMD_KOMBINIERE, 1134, 202);
    r->add_trigger(CMD_KOMBINIERE, 1135, 202);
    r->add_trigger(CMD_KOMBINIERE, 1136, 202);
    r->add_trigger(CMD_KOMBINIERE, 1, 202);
  }
  r=erzeuge_kombination(18, 202, -1, 0,POS_EGAL, POS_EGAL, "Das hat keinen Sinn mehr."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_ESSSCHLUESSEL, 0));
    r->add_bedingung(new BedingungObjektHatZustand(this, 1007, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this,18, false));
  }
  r=erzeuge_kombination(18, 202, -1, 0,POS_EGAL, POS_EGAL, "Du schiebst das Blatt vorsichtig unter den Trspalt, aber als du es loslsst, wird es von einem Luftzug in den anderen Raum geblasen."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_STECKT));
    r->add_bedingung(new BedingungObjektHatZustand(this, 1007, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this,18, false));
  }
  r=erzeuge_kombination(18, 202, -1, 0,POS_EGAL, POS_EGAL, "Du schiebst das Blatt vorsichtig unter den Trspalt, so weit, dass du es immer noch wieder zurck ziehen kannst."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_STECKT));
    r->add_bedingung(new BedingungObjektHatZustand(this, 1007, 1));
    r->add_aktion(new AktionObjektNeuerZustand(this,202, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this,18, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,203, true));
  }
  r=erzeuge_nehmen(203, -1, false, "Du ziehst das Blatt unter der Tr hervor und packst es ein."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_BLATT));
    r->add_aktion(new AktionObjektNeuerZustand(this,202, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this,18, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,203, false));
  }
  r=erzeuge_nehmen(203, -1, false, "Du ziehst das Blatt mitsamt dem Schlssel unter der Tr hervor und packst beide ein."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_BLATT));
    r->add_aktion(new AktionObjektNeuerZustand(this,202, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this,18, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,203, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,20, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,CEXT::OBJ_ESSSCHLUESSEL, false));
  }


  erzeuge_gegenstand(203,200,true,false,false,"blatt", "ein Blatt", "Die Kante eines Blattes schaut unter der Tr hervor.", 0);
  erzeuge_untersuchung(203, 0, POS_EGAL, "Das Blatt ist zum berwiegenden Teil unter der Tr durchgeschoben worden.");

  erzeuge_gegenstand(205,200,true,false,true,"treppe", "eine Treppe", "Rechts fhrt eine Treppe in den Keller.");
  r = erzeuge_untersuchung(205, -1, POS_EGAL, "Sieht so aus als fhre die Treppe in bodenlose Schwrze."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 805, 0)); // Lampe im Keller aus
  }
  r = erzeuge_untersuchung(205, -1, POS_EGAL, "Das Licht im Keller ist eingeschaltet und du kannst die einzelnen Treppenstufen erkennen."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 805, 1)); // Lampe im Keller an
  }
  r = erzeuge_benutzung(205, -1, POS_EGAL, ""); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 805, 1)); // Lampe im Keller an
    r->add_aktion(new AktionRaumwechsel(this,800));
  }
  r = erzeuge_gehe(100140, "Du gehst immer weiter die Treppe hinab, obwohl es unten stockdunkel ist. Du verlierst den Halt, schlgst auf dem Boden auf und verlierst das Bewusstsein.\n \nAls du wieder zu dir kommst, siehst du den Hausbesitzer und einen Polizisten ber dich gebeugt."); {
    r->add_trigger(CMD_BENUTZE, 205, -1);
    r->add_bedingung(new BedingungObjektHatZustand(this, 805, 0)); // Lampe im Keller aus
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r = erzeuge_gehe(100150, "Whrend du die Treppe hinauf gehst, hrst du ein Klacken und siehst, wie es hinter dir wieder dunkel wird."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 805, 1)); // Lampe im Keller an
    r->add_aktion(new AktionObjektNeuerZustand(this,805,0));
  }
  r = erzeuge_gehe(100010, "Von hinten dringt ein leises Klacken aus dem Keller zu dir."); {
    r->add_trigger(CMD_GEHE, 100060, -1);
    r->add_bedingung(new BedingungObjektHatZustand(this, 805, 1)); // Lampe im Keller an
    r->add_aktion(new AktionObjektNeuerZustand(this,805,0));
  }

  erzeuge_gegenstand(210,200,true,false,true,"kleiderstange", "eine Kleiderstange", "Vor dir an der Wand hngt eine Kleiderstange aus Metall.",0);
  erzeuge_untersuchung(210, -1, POS_EGAL, "Solide skandinavische Verarbeitung, fest an die Wand gedbelt.");
  erzeuge_benutzung(210, -1, POS_EGAL, "Willst du dich etwa dran aufhngen? So schlecht luft es doch gar nicht. Und die Kleiderbgel wrden eh nicht halten.");
  r=erzeuge_druecken(210, 3, POS_EGAL, "Du packst an die Stange. Im selben Moment reit die Stange mit einem fiesen Knirschen von der Wand und trifft dich am Kopf.\n \nAls du im Krankenhaus wieder aufwachst, steht schon ein Polizist zur Vernehmung neben dir."); {
    r->add_trigger(CMD_ZIEHE,210,-1);
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r=erzeuge_druecken(210, 2, POS_EGAL, "Du solltest nicht mehr an der Stange rtteln. Sie kommt dir jeden Moment entgegen."); {
    r->add_trigger(CMD_ZIEHE,210,-1);
    r->add_aktion(new AktionObjektNeuerZustand(this, 210, 3));
  }
  erzeuge_ziehen(210, 2, POS_EGAL, "Mit Gewicht solltest du die Stange jetzt nicht mehr belasten.");
  erzeuge_druecken(210, 1, POS_EGAL, "Weiter hoch drcken hilft nicht. Die Aufhngung ist schon verbogen.");
  r=erzeuge_ziehen(210, 1, POS_EGAL, "Du ziehst die Stange wieder zurck in die ursprngliche Position. Es macht *pling* und eine Schraube mitsamt Dbel fllt aus der Wand."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 210, 2));
    r->add_aktion(new AktionObjektSetSichtbar(this, 225, true));
  }
  erzeuge_ziehen(210, 0, POS_EGAL, "Zieh ruhig, das Ding hlt. Die Schweden verstehen ihr Fach.");
  r=erzeuge_druecken(210, 0, POS_EGAL, "Du drckst die Stange entgegen der blichen Belastung. Material knirscht und etwas Putz rieselt auf den Boden."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 210, 1));
  }

  erzeuge_gegenstand(215,200,true,false,true,"jacken", "jacken", "An der Kleiderstange hngen dicht an dicht verschiedenste Jacken.",0);
  erzeuge_nehmen(215, -1, false, "Auch wenn wir dadurch ein paar Taschen mehr htten, wrde es auf Dauer zu warm.");
  erzeuge_benutzung(215, -1, POS_EGAL, "So kalt ist es auch nicht, dass du eine Jacke anziehen msstest.");
  erzeuge_untersuchung(215, 1, POS_EGAL, "Nichts mehr zu finden.");
  r=erzeuge_untersuchung(215, 0, POS_EGAL, "Du schaust dir die Jacken genau an und durchsuchst ihre Taschen. In der sommerlichen Damenjacke findest du ein Feuerzeug und nimmst es mit."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FEUERZEUG, true));
    r->add_aktion(new AktionObjektNeuerZustand(this, 215, 1));
  }
  r=erzeuge_ziehen(215, -1, POS_EGAL, "Du ziehst die Jacken auf eine Seite der Stange und entdeckst an der Wand einen Schalter."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 220, true));
  }

  erzeuge_gegenstand(220,200,true,false,false,"schalter", "ein Schalter", "Versteckt hinter den Jacken ist ein Schalter an der Wand angebracht.");
  erzeuge_benutzung(220, -1, POS_EGAL, "Du benutzt Schalter? Ich drcke sie meistens.");
  erzeuge_untersuchung(220, -1, POS_EGAL, "Sieht aus wie einer dieser Druckschalter in Treppenhusern, mit denen das Licht fr eine Weile eingeschaltet werden kann.");
  r=erzeuge_druecken(220, -1, POS_EGAL, "Du drckst den Schalter und hrst ein Klacken im Keller."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 805, 1));
  }

  erzeuge_gegenstand(225,200,false,false,false,"gedbelte Schraube", "eine gedbelte Schraube", "Auf dem Boden liegt eine aus der Wand gerissene Schraube mit Dbel.");
  erzeuge_untersuchung(225, -1, POS_EGAL, "Eine Schraube in einem Dbel.");
  erzeuge_benutzung(225, -1, POS_EGAL, "Soll ich mir die Schraube in die Nase dbeln?");







// 3 Kche


  erzeuge_gegenstand(310,300,true,false,true,"kchenzeile", "eine Kchenzeile", "", 0);
  erzeuge_benutzung(310, -1, POS_RAUM, "Zum Kochen bleibt keine Zeit.");
  erzeuge_untersuchung(310, 1, POS_EGAL, "Du suchst nochmal die ganze Zeile ab, findest sonst aber nichts.");
  r = erzeuge_untersuchung(310, 0, POS_EGAL, "Unter der Arbeitsflche findest du eine Schublade und einen groen Mlleimer."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 310, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 315, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 317, true));
  }

  erzeuge_gegenstand(315,300,true,false,false,"schublade", "eine Schublade", "",0);
  erzeuge_benutzung(315, -1, POS_RAUM, "Du spielst etwas am Griff der Schublade.");
  erzeuge_untersuchung(315, -1, POS_EGAL, "Da knnte was drin sein, hast du schon nachgeschaut?");
  r =erzeuge_oeffnen(315, -1, "Du ffnest die Schublade und schaust hinein."); {
    r->add_aktion(new AktionRaumwechsel(this, 2400));
  }

  erzeuge_gegenstand(CEXT::OBJ_MUELLEIMER,300,true,false,false,"mlleimer", "ein Mlleimer", "Unter der Arbeitsflche steht ein groer Mlleimer.",0);
  erzeuge_untersuchung(CEXT::OBJ_MUELLEIMER, -1, POS_EGAL, "Ein Mlleimer fr Kchenabflle.");
  r =erzeuge_benutzung(CEXT::OBJ_MUELLEIMER, -1,POS_EGAL, "Ich werde nicht im Mll fremder Menschen rumwhlen. Das mache ich nicht mal bei meinem eigenen."); {
    r->add_trigger(CMD_OEFFNE, CEXT::OBJ_MUELLEIMER, -1);
  }
  r = erzeuge_kombination(1706, CEXT::OBJ_MUELLEIMER, -1, 1, POS_EGAL, POS_EGAL, "Der Mlleimer ist voll."); {
    r->add_trigger(CMD_KOMBINIERE, 385, CEXT::OBJ_MUELLEIMER);
    r->add_trigger(CMD_KOMBINIERE, 612, CEXT::OBJ_MUELLEIMER);
    r->add_trigger(CMD_KOMBINIERE, 906, CEXT::OBJ_MUELLEIMER);
  }
  r = erzeuge_kombination(906, CEXT::OBJ_MUELLEIMER, -1, 0, POS_EGAL, POS_EGAL, "Du wirfst das Marmeladenglas in den Mlleimer."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 906, false));
  }
  r = erzeuge_kombination(1706, CEXT::OBJ_MUELLEIMER, -1, 0, POS_EGAL, POS_EGAL, "Du wirfst den Haustrschlssel in den Mlleimer."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 1706, false));
  }
  r = erzeuge_kombination(385, CEXT::OBJ_MUELLEIMER, -1, 0, POS_EGAL, POS_EGAL, "Du wirfst die Schrze in den Mlleimer."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 1706, false));
    r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_MUELLEIMER, 1));
  }
  erzeuge_kombination(612, CEXT::OBJ_MUELLEIMER, -1, 0, POS_EGAL, POS_EGAL, "Das Handtuch passt da nicht mehr rein.");
  erzeuge_kombination(908, CEXT::OBJ_MUELLEIMER, -1, -1, POS_EGAL, POS_EGAL, "Eine funktionsfhige Fernbedienung werfe ich nicht einfach weg. Am besten bringen wir sie an einen sinnvollen Platz.");


  erzeuge_gegenstand(320,300,true,false,true,"khlschrank", "ein Khlschrank", "Rechts an die Kchenzeile schliet der Khlschrank an.",0);
  erzeuge_untersuchung(320, -1, POS_EGAL, "Ein Khlschrank, gewissermaen ein Schrank zum Khlen.");
  get_regeln()->add_regel(r=new Spielregel(this, CMD_SCHLIESSE, 320, -1,false, true)); {
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 320,1));
    a->add_aktion(new AktionObjektNeuerZustand(this, 320, 0));
    a->add_aktion(new AktionObjektSetSichtbar(this, 324, false));
    a->add_aktion(new AktionTextausgabe(this, "Du schliet den Khlschrank wieder."));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 320,0));
    a->add_aktion(new AktionTextausgabe(this, "Der Khlschrank ist bereits geschlossen."));
  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_OEFFNE, 320, -1,false, true)); {
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 320,0));
    a->add_aktion(new AktionObjektNeuerZustand(this, 320, 1));
    a->add_aktion(new AktionObjektSetSichtbar(this, 324, true));
    a->add_aktion(new AktionTextausgabe(this, "Du ffnest den Khlschrank. Das einzig Nahrhafte darin ist ein dickes Stck Rindfleisch, mehrere Kilo schwer."));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 320,1));
    a->add_aktion(new AktionTextausgabe(this, "Der Khlschrank ist bereits geffnet."));
  }

  erzeuge_gegenstand(324,300,true,false,false,"fleischstck", "ein Fleischstck", "");
  erzeuge_untersuchung(324,-1, POS_EGAL, "Ich kenne mich nicht so aus, ich wrde aber sagen, gebraten wird es lecker sein.");
  erzeuge_nehmen(324, -1, false, "So einen dicken Klumpen Fleisch schleppe ich nicht mit mir rum. Das lockt noch die Tiere an.");
  erzeuge_benutzung(324, -1, POS_RAUM, "Willst du etwa ein Stck abbeien?");
  erzeuge_kombination(CEXT::OBJ_ZANGE, 324, -1, -1, POS_EGAL, POS_EGAL, "Das wrde ewig dauern. Du httest es vermutlich schneller durchgebissen.");
  erzeuge_kombination(420, 324, -1, -1, POS_EGAL, POS_EGAL, "Hast du schonmal ein Stck Fleisch mit einer Glasscherbe abgeschnitten? Wir fangen jetzt nicht damit an!");
  r = erzeuge_kombination(2410, 324, -1, -1, POS_EGAL, POS_EGAL, "Du hast bereits ein Stck dabei."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 27));
  }
  r = erzeuge_kombination(2410, 324, -1, -1, POS_EGAL, POS_EGAL, "Das Fleisch hat zwar keine Knochen, aber es wird wohl trotzdem gehen. Du schneidest ein schnes Stck Fleisch ab und packst es ein."); {
    r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 27));
    r->add_aktion(new AktionObjektSetSichtbar(this, 27, true));
    r->add_aktion(new AktionObjektNeuerZustand(this, 27, 0));
    a=new AktionBedingt(this, r, new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN),
                                             new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_SAUBERGETRAGEN)));
    a->add_aktion(new AktionTextausgabe(this, "Die Blutspritzer auf deiner Schrze zeugen von deiner Tat."));
    a->add_aktion(new AktionObjektNeuerZustand(this, 385,CEXT::ST_SCHUERZE_DRECKIGGETRAGEN));

    a=new AktionBedingt(this, r, new BedingungObjektHatNichtZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN));
    a->add_bedingung(new BedingungObjektHatNichtZustand(this, 385, CEXT::ST_SCHUERZE_SAUBERGETRAGEN));
    a->add_aktion(new AktionTextausgabe(this, "Die Blutspritzer auf deinem Hemd zeugen von deiner Tat."));
    a->add_aktion(new AktionObjektNeuerZustand(this, 2, 1));
  }

  erzeuge_beschreibung(200100,ST_TUER_VERSCHLOSSEN, "Daneben fhrt eine mit einem Riegel verschlossene Schiebetr in einen weiteren Raum.");
  erzeuge_beschreibung(200100,ST_TUER_GESCHLOSSEN, "Daneben fhrt eine Schiebetr in einen weiteren Raum.");
  erzeuge_beschreibung(200100,ST_TUER_OFFENBLOCKIERT, "Daneben fhrt ein Durchgang ins Esszimmer.");
  erzeuge_untersuchung(200100,ST_TUER_VERSCHLOSSEN, POS_EGAL, "Die Tr ist mit einem Riegel verschlossen.");
  erzeuge_untersuchung(200100,ST_TUER_GESCHLOSSEN, POS_EGAL, "Die Schiebetr ist geschlossen.");
  erzeuge_untersuchung(200100,ST_TUER_OFFENBLOCKIERT, POS_EGAL, "Die Schiebetr ist offen.");
  erzeuge_oeffnen(200100,ST_TUER_VERSCHLOSSEN, "Sie ist mit einem Riegel verschlossen.");

  erzeuge_gegenstand(330,300,true,false,true,"riegel", "ein Riegel", "",0);
  erzeuge_untersuchung(330, 0, POS_EGAL, "Der Riegel hlt die Schiebetr verschlossen.");
  erzeuge_untersuchung(330, 1, POS_EGAL, "Der Riegel ist offen.");
  erzeuge_druecken(330,0, POS_EGAL, "Noch strker verschlieen geht nicht.");
  erzeuge_druecken(330,1, POS_EGAL, "Wir sollten ihn offen lassen.");
  erzeuge_ziehen(330,1, POS_EGAL, "Er ist bereits offen.");
  r=erzeuge_ziehen(330,0, POS_EGAL, "Du entriegelst die Schiebetr."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 330, 1));
    r->add_aktion(new AktionObjektNeuerZustand(this, 200100, ST_TUER_GESCHLOSSEN));
    r->add_aktion(new AktionObjektNeuerZustand(this, 200110, ST_TUER_GESCHLOSSEN));
  }

  erzeuge_gegenstand(380,300,true,false,false,"hakenbrett", "ein Hakenbrett", "Vorher von der offenen Tr verdeckt, siehst du links ein Hakenbrett an der Wand.");
  erzeuge_untersuchung(380, -1, POS_EGAL, "Ein Brett mit Haken, an die man Dinge hngen kann.");
  erzeuge_benutzung(380, -1, POS_EGAL, "Willst du dich schon wieder aufhngen?");

  erzeuge_gegenstand(385,300,false,false,false,"schrze", "eine Schrze", "An einem der Haken hngt eine Schrze.", CEXT::ST_SCHUERZE_SAUBER);
  erzeuge_benutzung(385, -1, POS_RAUM, "Schonmal versucht, etwas anzuziehen, whrend es noch hngt?");
  r = erzeuge_nehmen(385, -1, true, "Du packst die Schrze in deine Tasche."); {
    r->add_bedingung(new BedingungObjektNichtInInventar(this, 385));
  }
  r = erzeuge_benutzung(385, -1, POS_INVENTAR, "Du trgst die Schrze bereits."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_SAUBERGETRAGEN),
                                             new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN)));
  }
  r = erzeuge_benutzung(385, -1, POS_INVENTAR, "Du ziehst die Schrze an."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_SAUBER),
                                             new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIG)));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 385,CEXT::ST_SCHUERZE_SAUBER));
    a->add_aktion(new AktionObjektNeuerZustand(this, 385, CEXT::ST_SCHUERZE_SAUBERGETRAGEN));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 385,CEXT::ST_SCHUERZE_DRECKIG));
    a->add_aktion(new AktionObjektNeuerZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN));
  }
  r = erzeuge_kombination(385, 380, -1, -1, POS_EGAL, POS_EGAL, "Du hngst die Schrze wieder an den Haken."); {
    r->add_aktion(new AktionObjektNeuePos(this, 385, 300));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 385,CEXT::ST_SCHUERZE_SAUBERGETRAGEN));
    a->add_aktion(new AktionObjektNeuerZustand(this, 385, CEXT::ST_SCHUERZE_SAUBER));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 385,CEXT::ST_SCHUERZE_DRECKIGGETRAGEN));
    a->add_aktion(new AktionObjektNeuerZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIG));
  }
  r = erzeuge_untersuchung(385, -1, POS_EGAL, "Eine weie Schrze mit Blmchenmuster."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_SAUBER),
                                             new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_SAUBERGETRAGEN)));
  }

  r = erzeuge_untersuchung(385, -1, POS_EGAL, "Eine weie Schrze mit Blmchenmuster, auf der einige Spritzer Blut hsslich rot leuchten."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIG),
                                             new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN)));
  }


  r=erzeuge_gehe(100040, "Als du die Kche verlsst, durchstringt ein markerschtterndes Piepen das Haus. Klingt nach der Auftauwarnung des Khlschranks. Hast du etwa die Tr offen gelassen?\nDie Nachbarn sind jedenfalls genervt und rufen den Hausbesitzer an."); {
    r->add_trigger(CMD_GEHE, 100030, -1);
    r->add_bedingung(new BedingungObjektHatZustand(this, 320, 1));
    r->add_aktion(new AktionSpielVerloren(this));
  }


// 4 Esszimmer

  erzeuge_gegenstand(405,400,true,false,true,"tisch", "ein Tisch", "In der Mitte des Raumes steht ein massiver Esstisch aus hellem Holz in schlichtem Design.");
  erzeuge_untersuchung(405, -1, POS_EGAL, "An seiner Stelle kommt er perfekt zur Geltung.");
  r=erzeuge_ziehen(405, -1, POS_RAUM, "Du willst doch jetzt nicht etwa umdekorieren."); {
    r->add_trigger(CMD_DRUECKE, 405, -1);
  }
  erzeuge_nehmen(440, -1, false, "Die sind zu sperrig.");

  erzeuge_gegenstand(415,400,true,false,true,"lampe", "eine Lampe", "",0);
  erzeuge_benutzung(415, 1, POS_EGAL, "Ohne Glhbirne bringt das schonmal gar nichts.");
  erzeuge_benutzung(415, 0, POS_EGAL, "Ich kann nirgendwo einen Lichtschalter finden.");
  r=erzeuge_kombination(CEXT::OBJ_ZANGE, 415, -1, -1,POS_EGAL, POS_EGAL,"Da hat irgendein Depp statt der Phase den Nullleiter ber den Schalter laufen lassen. Das Ergebnis sind jedenfalls schwarze Fingerngel und eine Ohnmacht, um die sich der Hausbesitzer spter kmmern wird."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 415, 0),
                                             new BedingungObjektHatZustand(this, 415, 1)));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r=erzeuge_kombination(CEXT::OBJ_ZANGE, 415, -1, -1,POS_EGAL, POS_EGAL,"Mit einem *schnipp* pitschst du das Kabel durch und die Lampe zerbricht auf dem Tisch."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 415, 0),
                                             new BedingungObjektHatZustand(this, 415, 1)));
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
    r->add_aktion(new AktionObjektNeuerZustand(this, 415, 2));
    a=new AktionBedingt(this, r, new BedingungObjektNichtInInventar(this, 417));
    new AktionBedingt(this, a, new BedingungObjektIstSichtbar(this, 417), new AktionTextausgabe(this, "Die Glhbirne geht dabei mit zu Bruch."));
    a->add_aktion(new AktionObjektSetSichtbar(this,417, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,420, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,421, true));
  }
  r=erzeuge_ziehen(415, -1, POS_EGAL, "Du reit die Lampe mitsamt Kabel aus der Decke. Sie fllt auf den Tisch und zerbricht."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 415, 0),
                                             new BedingungObjektHatZustand(this, 415, 1)));
    r->add_aktion(new AktionObjektNeuerZustand(this, 415, 2));
    a=new AktionBedingt(this, r, new BedingungObjektNichtInInventar(this, 417));
    new AktionBedingt(this, a, new BedingungObjektIstSichtbar(this, 417), new AktionTextausgabe(this, "Die Glhbirne geht dabei mit zu Bruch."));
    a->add_aktion(new AktionObjektSetSichtbar(this,417, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,420, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,421, true));
  }
  r=erzeuge_beschreibung(415, -1, "Dicht ber dem Tisch hngt eine Lampe an einem langen Kabel."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 415, 0),
                                             new BedingungObjektHatZustand(this, 415, 1)));
  }
  erzeuge_beschreibung(415, 2, "In der Mitte des Tisches liegen die Reste einer zerbrochenen Lampe.");
  erzeuge_untersuchung(415, 2, POS_EGAL, "Da gibt es nicht mehr viel zu untersuchen.");
  erzeuge_untersuchung(415, 1, POS_EGAL, "Eine Lampe ohne Birne.");
  r=erzeuge_untersuchung(415, 0, POS_EGAL, "In die Lampe ist eine dieser alten Glhbirnen eingedreht."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 417, true));
  }

  erzeuge_gegenstand(417,400,false,false,false,"glhbirne", "eine Glhbirne", "");
  erzeuge_untersuchung(417, -1, POS_EGAL, "Eine alte, Strom fressende, Hitze produzierende Glhbirne, 100 Watt steht drauf.");
  r=erzeuge_nehmen(417, -1, true, "Du schraubst die Glhbirne aus der Fassung und packst sie ein."); {
    r->add_bedingung(new BedingungObjektNichtInInventar(this, 417));
    r->add_aktion(new AktionObjektNeuerZustand(this, 415, 1));
  }

  erzeuge_gegenstand(420,400,false,false,false,"glasscherbe", "eine Glasscherbe", "");
  erzeuge_untersuchung(420, -1, POS_EGAL, "Ein Stck Glas von einem Lampenschirm.");
  erzeuge_benutzung(420, -1, POS_RAUM, "Nicht auf dem Tisch.");
  erzeuge_benutzung(420, -1, POS_INVENTAR, "Willst du dir die Pulsadern aufschneiden? So eine Sauerei. Versuchs lieber mit Strom, da kennst du dich mit aus ;-)");

  erzeuge_gegenstand(421,400,true,false,false,"stromkabel", "ein Stromkabel", "");
  erzeuge_untersuchung(421, -1, POS_EGAL, "Das Kabel hngt auf der einen Seite noch an der Deckenfassung und an der anderen Seite hngt die Lampenfassung.");
  erzeuge_benutzung(421, -1, POS_RAUM, "Da hngt zu viel Kram dran.");
  erzeuge_nehmen(421, -1, false, "Das Kabel hngt an den restlichen Lampenteilen fest.");
  r = erzeuge_kombination(CEXT::OBJ_ZANGE, 421, -1, -1, POS_EGAL, POS_EGAL, "Du schneidest ein Stck vom Kabel ab."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 23, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 421, false));
  }

  erzeuge_gegenstand(440,400,true,false,true,"sthle", "sthle", "Um den Tisch herum stehen 6 Sthle, jeweils zwei an der langen Seite und einer an den Kopfseiten.");
  erzeuge_untersuchung(440, -1, POS_EGAL, "Der Stil passt perfekt zum Tisch.");
  erzeuge_benutzung(440, -1, POS_RAUM, "Wir haben keine Zeit, uns hinzusetzen.");
  erzeuge_nehmen(440, -1, false, "Die sind zu sperrig.");
  r=erzeuge_ziehen(405, -1, POS_RAUM, "Du willst doch jetzt nicht etwa umdekorieren."); {
    r->add_trigger(CMD_DRUECKE, 405, -1);
  }

  r=erzeuge_beschreibung(200110, -1, "Auf der linken Seite befindet sich eine Schiebetr."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 200090, ST_TUER_GESCHLOSSEN),
                                             new BedingungObjektHatZustand(this, 200090, ST_TUER_VERSCHLOSSEN)));
  }
  erzeuge_beschreibung(200110,ST_TUER_OFFENBLOCKIERT, "Auf der linken Seite fhrt eine Schiebetr in die Kche.");
  erzeuge_untersuchung(200110,ST_TUER_VERSCHLOSSEN, POS_EGAL, "Die Tr ist von der anderen Seite verschlossen.");
  erzeuge_untersuchung(200110,ST_TUER_GESCHLOSSEN, POS_EGAL, "Die Schiebetr ist geschlossen.");
  erzeuge_untersuchung(200110,ST_TUER_OFFENBLOCKIERT, POS_EGAL, "Die Schiebetr ist offen.");
  erzeuge_oeffnen(200110,ST_TUER_VERSCHLOSSEN, "Sie ist von der anderen Seite verschlossen.");

  erzeuge_gegenstand(450,400,true,false,true,"Buffet", "ein Buffet", "Daneben steht ein Buffet, der den Rest der Wand fllt.",0);
  erzeuge_untersuchung(450, 1, POS_RAUM, "Ansonsten ist im Buffet nicht wichtiges mehr.");
  r = erzeuge_untersuchung(450, 0, POS_RAUM, "Im Buffet liegt ein quadratisches Frmchen."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FORM_QUADRAT, true));
    r->add_aktion(new AktionObjektNeuerZustand(this, 450, 1));
  }

  erzeuge_gegenstand(CEXT::OBJ_FORM_QUADRAT,400,false,false,false,"quadratisches Frmchen", "ein quadratisches Frmchen", "");
  erzeuge_untersuchung(CEXT::OBJ_FORM_QUADRAT, -1, POS_EGAL, "Ein quadratisches Frmchen. Sieht aus wie ein Teil eines Puzzles.");
  erzeuge_benutzung(CEXT::OBJ_FORM_QUADRAT, -1, POS_EGAL, "Ich sehe keinen Sandkasten.");







// 5 Wohnzimmer

  erzeuge_gegenstand(510,500,true,false,true,"sofa", "ein Sofa", "In der hinteren Ecke steht ein groes Ecksofa, dass einen Teil des Terrassenfensters verdeckt.");
  erzeuge_untersuchung(510, -1, POS_RAUM, "Auf dem Sofa kann man bestimmt geleichermaen gut sitzen und liegen.");
  erzeuge_benutzung(510, -1, POS_RAUM, "Besser nicht, sonst schlfst du wieder ein.");

  erzeuge_gegenstand(515,500,true,false,false,"murmel", "eine Murmel", "",0);
  erzeuge_beschreibung(515, 0, "Unter dem Sofa, fast an der Wand, liegt eine dicke Glasmurmel.");
  erzeuge_beschreibung(515, 1, "Seitlich vom Sofa liegt eine dicke Glasmurmel.");
  erzeuge_untersuchung(515, -1, POS_RAUM, "Ohne sie in der Hand zu halten, kann ich nicht viel sagen.");
  erzeuge_nehmen(515, 0, false, "Sie ist viel zu weit unter dem Sofa. Dort kommen wir nie dran.");
  r=erzeuge_nehmen(515, 1, true, "Du steckst die Murmel in deine Tasche."); {
    r->add_bedingung(new BedingungObjektNichtInInventar(this, 515));
  }

  erzeuge_gegenstand(520,500,true,false,true,"terrassenfenster", "ein Terrassenfenster", "");
  erzeuge_untersuchung(520, -1, POS_EGAL, "Du schaust durch das Fenster hinaus in den riesigen Garten mit akkurat geschnittenem Rasen. Er ist links und rechts von hohen Mauern eingefasst, an denen Rosenstcke wachsen. Etwas weiter hinten an der rechten Mauer steht ein Gartenhuschen.");

  erzeuge_gegenstand(530,500,true,false,true,"perser", "ein Perser", "Vor dem Sofa liegt ein ausladender Perser mit Beige und Bordeaux als den Hauptfarben.");
  erzeuge_untersuchung(530, -1, POS_EGAL, "Der Teppich ist so weich, dass man ihn als Konkurrenz zum Sofa verstehen kann.");
  erzeuge_benutzung(530, -1, POS_RAUM, "Bei deinem Ruhebedrfnis solltest du lieber ins Bett gehen als ein Spiel zu spielen.");

  erzeuge_gegenstand(540,500,false,false,true,"haargummi", "ein Haargummi", "Am Teppichrand liegt ein schwarzes Haargummi.");
  erzeuge_untersuchung(540, -1, POS_EGAL, "Damit bindet man Haare zusammen.");
  erzeuge_benutzung(540, -1, POS_RAUM, "Es ist zu weit weg, um etwas damit zu machen.");
  erzeuge_benutzung(540, -1, POS_INVENTAR, "Ich werde mir jetzt keine Zpfchen binden.");
  r=erzeuge_nehmen(540, -1, true, "Als du dich nach dem Haargummi bckst, siehst du unter dem Sofa eine tischtennisballgroe Glasmurmel liegen."); {
    r->add_bedingung(new BedingungObjektNichtInInventar(this, 540));
    r->add_aktion(new AktionObjektSetSichtbar(this, 515, true));
  }






// 6 Gsteklo

  erzeuge_gegenstand(603,600,true,false,true,"ablage", "eine Ablage", "Zu deiner linken ist das Waschbecken mit Ablage.",0);
  erzeuge_untersuchung(603, 1, POS_EGAL, "Sonst ist nichts mehr auf der Ablage.");
  r=erzeuge_untersuchung(603, 0, POS_EGAL, "Auf der Ablage steht ein Seifenspender."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 603, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_SEIFENSPENDER, true));
  }

  erzeuge_gegenstand(605,600,true,false,true,"spiegel", "ein Spiegel", "ber der Ablage hngt ein Spiegel mit verziertem Metallrahmen.");
  erzeuge_untersuchung(605, -1, POS_EGAL, "Eines dieser Dinger mit den Spiegelbildern.");
  erzeuge_benutzung(605, -1, POS_EGAL, "Du schaust in den Spiegel. Dein Haar sitzt perfekt. Aber du bist ja auch noch nicht aus dem Haus raus...");

  erzeuge_gegenstand(610,600,true,false,true,"halter", "ein Halter", "Neben dem Waschbenken ist ein schlanker Handtuchhalter angebracht.");
  erzeuge_untersuchung(610, 0, POS_EGAL, "Das ist nur eine waagerecht an die Wand montierte Stange mit Gelenk, nichts weiter.");

  erzeuge_gegenstand(CEXT::OBJ_HANDTUCH,600,false,false,true,"handtuch", "ein Handtuch", "Darber hngt ein frisches Handtuch.", CEXT::ST_HANDTUCH_SAUBER);
  erzeuge_untersuchung(CEXT::OBJ_HANDTUCH, CEXT::ST_HANDTUCH_SAUBER, POS_EGAL, "Ein graues, fluffiges Handtuch.");
  erzeuge_untersuchung(CEXT::OBJ_HANDTUCH, CEXT::ST_HANDTUCH_NASS, POS_EGAL, "Ein graues, tropfnasses Handtuch.");
  erzeuge_untersuchung(CEXT::OBJ_HANDTUCH, CEXT::ST_HANDTUCH_DRECKIG, POS_EGAL, "Das Handtuch ist dreckig und fhlt sich schmierig an.");
  erzeuge_benutzung(CEXT::OBJ_HANDTUCH, CEXT::ST_HANDTUCH_SAUBER, POS_EGAL, "Ich bin nicht nass.");

  erzeuge_gegenstand(640,600,true,false,true,"toilette", "eine Toilette", "In der rechten Ecke unter dem Fenster steht die Toilette.");
  erzeuge_untersuchung(640, -1, POS_EGAL, "Nein, keine Geheimtr wie in anderen Geschichten.");
  r = erzeuge_benutzung(640, -1, POS_EGAL, "Aber doch nicht mit offener Tr. Etwas Privatsphre muss sein."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 200010, ST_TUER_OFFEN));
  }
  r = erzeuge_benutzung(640, -1, POS_EGAL, "Du setzt dich hin, machst dein Geschft und stellst mit Schrecken fest, dass kein Klopapier vorhanden ist.\nUnfhig, so die Toilette zu verlassen bleibst du wie versteinert sitzen, bis die Hausbesitzer zurck sind. Dumm gelaufen."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 200010, ST_TUER_GESCHLOSSEN));
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r=erzeuge_kombination(1, 640,-1, -1, POS_EGAL, POS_EGAL, "Du wirfst den Zettel in die Schssel und bettigst die Splung."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 1, false));
  }
  r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 640,-1, -1, POS_INVENTAR, POS_EGAL, "Du stopfst das Handtuch in den Abfluss und ziehst ab. Es kommt, wie es kommen musste, der Abfluss verstopft, das Wasser fliet ber, unter der Toiletten- und Haustr durch, bis die Nachbarn aufmerksam werden."); {
    r->add_aktion(new AktionSpielVerloren(this));
  }
  erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 640,CEXT::ST_SEIFE_LEER, -1, POS_INVENTAR, POS_EGAL, "Der Seifenspender ist leer.");
  r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 640, -1, -1, POS_INVENTAR, POS_EGAL, "Du giet den Inhalt des Seifenspenders in die Toilette und ziehst ab."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_ORG));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_LEER));
    r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_LEER));
  }

  erzeuge_gegenstand(650,600,true,false,true,"fenster", "ein Fenster", "Das Fenster ist geschlossen.");
  erzeuge_untersuchung(650, -1, POS_EGAL, "Das Fenster ist vergittert, keine Chance da rauszukommen.");
  erzeuge_ziehen(650, -1, POS_EGAL, "Du ziehst dich schon und schaust wehmtig raus.");
  erzeuge_benutzung(650, -1, POS_EGAL, "Was hast du denn jetzt bitte gemacht, dass du meinst, lften zu mssen?");

  erzeuge_gegenstand(CEXT::OBJ_SEIFENSPENDER,600,false,false,false,"seifenspender", "ein Seifenspender", "",CEXT::ST_SEIFE_ORG);
  r=erzeuge_untersuchung(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_ORG, -1, "Der Seifenspender ist leer und verklebt."); {
    r->add_trigger(CMD_BENUTZE, CEXT::OBJ_SEIFENSPENDER, -1);
  }
  erzeuge_oeffnen(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_ORG, "Der Verschluss ist so verklebt, dass ich ihn nicht aufgedreht bekomme.");
  erzeuge_kombination(CEXT::OBJ_ZANGE, CEXT::OBJ_SEIFENSPENDER,-1, CEXT::ST_SEIFE_ORG, POS_EGAL, POS_EGAL, "Du packst den Verschluss mit der Zange, aber er sitzt so fest, dass die Zange durchdreht.");
  erzeuge_kombination(420, CEXT::OBJ_SEIFENSPENDER,-1, CEXT::ST_SEIFE_ORG, POS_EGAL, POS_EGAL, "Es knnte gehen, wenn du die Glasscherbe nur mit zwei Hnden halten knntest.");
  erzeuge_untersuchung(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_WASCHMITTEL, POS_INVENTAR, "Der Seifenspender ist zur Hlfte mit Waschmittel gefllt.");
  erzeuge_untersuchung(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_SEIFE, POS_INVENTAR, "Der Seifenspender enthlt eine seifenhnliche Mischung.");
  erzeuge_untersuchung(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_VOLLWASCHMITTEL, POS_INVENTAR, "Der Seifenspender ist voll mit Waschmittel.");
  erzeuge_untersuchung(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_WASSER, POS_INVENTAR, "Der Seifenspender ist zur Hlfte mit Wasser gefllt.");
  erzeuge_untersuchung(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_VOLLWASSER, POS_INVENTAR, "Der Seifenspender voll mit Wasser.");
  erzeuge_untersuchung(CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_LEER, POS_INVENTAR, "Nachdem der Verschluss abgeschnitten ist, sieht er aus wie eine kleine Vase.");
  erzeuge_benutzung(CEXT::OBJ_SEIFENSPENDER, -1, POS_INVENTAR, "Womit soll ich ihn benutzen?");
  r =erzeuge_oeffnen(CEXT::OBJ_SEIFENSPENDER, -1, "Er ist bereits offen, um nicht zu sagen, aufgeschnitten."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_ORG));

  }





// 7 Flur, 1. Etage

  erzeuge_beschreibung(200120, ST_TUER_GESCHLOSSEN, "Rechts ist eine dieser hinlnglich bekannten Holztren.");
  erzeuge_beschreibung(200120, ST_TUER_OFFEN, "Rechts fhrt eine Tr in das Kinderzimmer.");

  erzeuge_gegenstand(705,700,true,false,true,"schiebetr", "eine Schiebetr", "", ST_TUER_VERSCHLOSSEN);
  erzeuge_beschreibung(705, ST_TUER_VERSCHLOSSEN, "Direkt vor dir versperrt eine Schiebetr den Weg in einen Raum.");
  erzeuge_beschreibung(705, ST_TUER_OFFEN, "Durch die Schiebetr geradeaus geht es in das Schlafzimmer.");
  erzeuge_untersuchung(705, -1, POS_EGAL, "Eine Schiebetr, die muss man schieben. Diese hier macht allerdings einen elektrischen Eindruck.");
  r=erzeuge_oeffnen(705, -1, "Mechanisch ist da nichts zu machen, die Schiebetr funktioniert vermutlich elektrisch."); {
    r->add_trigger(CMD_DRUECKE, 705, -1);
    r->add_trigger(CMD_ZIEHE, 705, -1);
  }
  erzeuge_schliessen(705, ST_TUER_VERSCHLOSSEN, "Sie ist bereits geschlossen.");
  erzeuge_schliessen(705, ST_TUER_OFFEN, "Das geht alles elektrisch.");

  erzeuge_gegenstand(710,700,true,false,true,"schalter", "ein Schalter", "Neben der Schiebetr ist ein Druckschalter angebracht.", 0);
  erzeuge_untersuchung(710, -1, POS_EGAL, "Mit diesem Schalter bedient man wohl die Schiebetr.");
  r=erzeuge_druecken(710, -1, POS_EGAL, "Die Tr ist bereits offen."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 705,ST_TUER_OFFEN));

  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_DRUECKE, 710, -1)); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 705,ST_TUER_VERSCHLOSSEN));
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
    r->add_aktion(new AktionObjektNeuerZustand(this, 705, ST_TUER_OFFEN));
    r->add_aktion(new AktionObjektSetSichtbar(this, 100340, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 100350, true));
    r->add_aktion(new AktionTextausgabe(this, "Du drckst den Schalter und mit einem Summen fhrt die Schiebetr auf."));
  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_DRUECKE, 710, -1)); {
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
    r->add_aktion(new AktionTextausgabe(this, "Du drckst auf den Schalter. Nichts passiert."));
  }
  r = erzeuge_gehe(100340, "Du betrittst das Schlafzimmer. Hinter dir fhrt die Schiebetr wieder zu."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 705, ST_TUER_VERSCHLOSSEN));
    r->add_aktion(new AktionObjektSetSichtbar(this, 100340, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 100350, false));
  }




// 8 Kellerflur

  erzeuge_gegenstand(803,800,true,false,true,"pendeltr", "eine Pendeltr", "Nach links geht es durch eine Pendeltr in den Waschraum.");
  erzeuge_oeffnen(803, -1, "Da gibt es nichts zu ffnen. Einfach durchgehen.");
  erzeuge_benutzung(803, -1, POS_EGAL, "Willst du sie pendeln lassen? Das schaffst du, indem du durch gehst.");
  erzeuge_untersuchung(803, -1, POS_EGAL, "Eine Pendeltr. Die pendelt, wenn man durch geht.");

  erzeuge_gegenstand(805,800,true,false,true,"lampe", "eine Lampe", "Direkt ber deinem Kopf hngt wieder eine dieser Ufo-Leuchten und taucht den Keller in steriles Sparlampenlicht.");
  erzeuge_untersuchung(805, -1, POS_EGAL, "Ohne diese Lampe wrden wir hier im Flur berhaupt nichts sehen.");
  erzeuge_kombination(1515,805, -1, -1, POS_EGAL, POS_EGAL, "Du willst doch wohl nicht die einzige Lampe hier unten abschrauben?");
  erzeuge_benutzung(805, -1, POS_EGAL, "Sie leuchtet doch schon.");

  erzeuge_beschreibung(200070, ST_TUER_GESCHLOSSEN, "Auf der rechten Seite siehst du eine geschlossene Tr.");
  erzeuge_beschreibung(200070, ST_TUER_OFFEN, "Rechts geht es zum Fernsehraum.");
  erzeuge_untersuchung(200070, -1, POS_EGAL, "Eine dieser in diesem Haus in fast jedem Zimmer verbauten braunen Holztren.");

  erzeuge_gegenstand(807,800,true,false,true,"schrank", "ein Schrank", "", 0);
  erzeuge_oeffnen(807, -1, "Der Schrank ist leer.");
  erzeuge_beschreibung(807, 0, "Rechts hinter dir unter der Treppe steht ein Schrank.");
  erzeuge_beschreibung(807, 2, "Mitten im Flur steht ein Schrank.");
  erzeuge_untersuchung(807, 0, POS_EGAL, "Hinter dem Schrank steht noch etwas, ich kann es aber nicht genau erkennen.");
  erzeuge_untersuchung(807, 1, POS_EGAL, "Der Schrank steht jetzt auf seifigem Boden.");
  erzeuge_untersuchung(807, 2, POS_EGAL, "Du hast den Schrank in die Mitte des Flurs gezogen.");
  erzeuge_druecken(807, 2, POS_EGAL, "Nach der Mhe schiebe ich ihn nicht wieder unter den Schrank.");
  erzeuge_ziehen(807, 2, POS_EGAL, "Wohin willst du ihn denn jetzt noch ziehen?");
  r=erzeuge_druecken(807, -1, POS_EGAL, "Ich glaube nicht, dass wir ihn weiter unter die Treppe geschoben bekommen."); {
  r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 807, 0),
                                           new BedingungObjektHatZustand(this, 807, 1)));
  }
  erzeuge_ziehen(807, 0, POS_EGAL, "Der ist so schwer und scheint frmlich am Boden zu kleben. So bekommen wir den nicht raus.");
  r=erzeuge_ziehen(807, 1, POS_EGAL, "Du ziehst den Schrank unter der Treppe hervor in die Mitte des Flurs. Unter der Treppe steht eine Leiter."); {
    r->add_aktion(new AktionObjektNeuerZustand(this,807,2));
    r->add_aktion(new AktionObjektSetSichtbar(this,808,true));
  }
  r = erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 807, -1, 0, POS_EGAL, POS_EGAL, "Von der Idee her ja ganz gut, aber so?"); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_SEIFE));
  }
  r = erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 807, CEXT::ST_SEIFE_SEIFE, 0, POS_EGAL, POS_EGAL, "Du stemmst dich gegen den Schrank, sodass er leicht nach hinten kippt, und schmierst die Seife unter ihn auf den Boden."); {
    r->add_aktion(new AktionObjektNeuerZustand(this,CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_LEER));
    r->add_aktion(new AktionObjektNeuerZustand(this,807,1));
  }

  // zum Fernsehraum
  r = erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 200070, CEXT::ST_SEIFE_SEIFE, -1, POS_EGAL, POS_EGAL, "Du verteilst die Seife auf den Flur bis ins Fernsehzimmer."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 100180));
    r->add_aktion(new AktionObjektNeuerZustand(this,CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_LEER));
    r->add_aktion(new AktionObjektNeuerZustand(this,100180,1));
  }
  r = erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 200070, CEXT::ST_SEIFE_SEIFE, -1, POS_EGAL, POS_EGAL, "Die Tr ist geschlossen."); {
    r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 100180));
  }
  r = erzeuge_kombination(807, 200070, 2, ST_TUER_OFFEN, POS_EGAL, POS_EGAL, "Den bekommen wir nicht einfach mal so ber die Fliesen geschoben."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, 100180, 1));
  }
  r = erzeuge_kombination(807, 200070, 2, ST_TUER_OFFEN, POS_EGAL, POS_EGAL, "Du schiebst den Schrank ber den seifigen Boden ins Fernsehzimmer."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100180, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this,807,false));
    r->add_aktion(new AktionObjektSetSichtbar(this,1020,true));
  }

  // zum Vorratsraum
  r = erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 200090, CEXT::ST_SEIFE_SEIFE, -1, POS_EGAL, POS_EGAL, "Du verteilst die Seife auf den Flur bis in den Vorratsraum."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 100160));
    r->add_aktion(new AktionObjektNeuerZustand(this,CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_LEER));
    r->add_aktion(new AktionObjektNeuerZustand(this,100160,1));
  }
  r = erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 200090, CEXT::ST_SEIFE_SEIFE, -1, POS_EGAL, POS_EGAL, "Die Tr ist geschlossen."); {
    r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 100160));
  }
  r = erzeuge_kombination(807, 200090, 2, ST_TUER_OFFENBLOCKIERT, POS_EGAL, POS_EGAL, "Den bekommen wir nicht einfach mal so ber die Fliesen geschoben."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, 100160, 1));
  }
  r = erzeuge_kombination(807, 200090, 2, ST_TUER_OFFENBLOCKIERT, POS_EGAL, POS_EGAL, "Du schiebst den Schrank ber den seifigen Boden in den Vorratsraum."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100160, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this,807,false));
    r->add_aktion(new AktionObjektSetSichtbar(this,913,true));
  }

  // zum Waschraum
  r = erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 803, CEXT::ST_SEIFE_SEIFE, -1, POS_EGAL, POS_EGAL, "Du verteilst die Seife auf den Flur bis in den Waschraum."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 100380));
    r->add_aktion(new AktionObjektNeuerZustand(this,CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_LEER));
    r->add_aktion(new AktionObjektNeuerZustand(this,100380,1));
  }
  r = erzeuge_kombination(807, 803, 2, -1, POS_EGAL, POS_EGAL, "Den bekommen wir nicht einfach mal so ber die Fliesen geschoben."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, 100380, 1));
  }
  r = erzeuge_kombination(807, 803, 2, -1, POS_EGAL, POS_EGAL, "Du schiebst den Schrank ber den seifigen Boden in den Waschraum."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100380, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this,807,false));
    r->add_aktion(new AktionObjektSetSichtbar(this,2340,true));
  }


  erzeuge_gegenstand(808,800,false,false,false,"leiter", "eine Leiter", "");
  erzeuge_untersuchung(808, -1, POS_EGAL, "Eine von diesen Klappleitern, die man verwendet, um an Dinge heran zu kommen, fr die man sonst zu klein ist.");
  erzeuge_benutzung(808, -1, POS_EGAL, "Jetzt einfach hier unter die Decke klettern? Besser nicht.");

  erzeuge_gegenstand(810,800,true,false,true,"Sicherungskasten", "ein Sicherungskasten", "An der gegenberliegenden Wand ist ein groer Sicherungskasten befestigt.");
  erzeuge_untersuchung(810, -1, POS_EGAL, "Ich bin kein Elektriker, aber da knnten Sicherungen drin sein.");
  erzeuge_benutzung(810, -1, POS_EGAL, "Mir fllt nicht so viel ein, was man mit einem geschlossenen Sicherungskasten machen kann.");
  r = erzeuge_oeffnen(810, -1, "Du trittst an den Sicherungskasten und ffnest ihn."); {
    r->add_aktion(new AktionRaumwechsel(this,1800));
  }

  r=erzeuge_beschreibung(200090, -1, "Links daneben ist eine wuchtige Metalltr in die Wand eingelassen."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 200090, ST_TUER_GESCHLOSSEN),
                                             new BedingungObjektHatZustand(this, 200090, ST_TUER_VERSCHLOSSEN)));
  }
  erzeuge_beschreibung(200090, ST_TUER_OFFENBLOCKIERT, "Links daneben ist der Eingang zum Vorratsraum.");
  r = erzeuge_oeffnen(200090, ST_TUER_VERSCHLOSSEN, "Die Tr ist verriegelt, siehst du das nicht?"); {
    r->add_trigger(CMD_DRUECKE, 200090, -1);
  }
  r = erzeuge_oeffnen(200090, ST_TUER_OFFENBLOCKIERT); {
    r->add_aktion(new AktionObjektSetSichtbar(this,815,false));
  }
  r = erzeuge_untersuchung(200090, ST_TUER_VERSCHLOSSEN, POS_EGAL, "Die Metalltr ist mit einem Riegel verschlossen, der mit einem vierstelligen Zahlenschloss gesichert ist."); {
    r->add_aktion(new AktionObjektSetSichtbar(this,815,true));
  }
  erzeuge_untersuchung(200090, ST_TUER_GESCHLOSSEN, POS_EGAL, "Der Trriegel ist jetzt geffnet.");
  erzeuge_untersuchung(200090, ST_TUER_OFFENBLOCKIERT, POS_EGAL, "Sie fhrt in den Vorratsraum.");
  erzeuge_druecken(200090, ST_TUER_GESCHLOSSEN, POS_EGAL, "Knnen wir sie nicht einfach ffnen?");

  erzeuge_gegenstand(815,800,true,false,false,"Zahlenschloss", "ein Zahlenschloss", "Rechts an der Tr ist ein Riegel mit Zahlenschloss festgenietet.",0);
  erzeuge_oeffnen(815,0, "Ich habe den Code nicht im Kopf.");
  erzeuge_kombination(1133, 815, -1, 1, POS_EGAL, POS_EGAL, "Ganz ruhig, das Schloss ist schon offen.");
  erzeuge_benutzung(815, 0, POS_EGAL, "Alle 10000 Mglichkeiten ausprobieren wrde zu lange dauern. Wrde auch keinen guten Eindruck machen, wenn uns die Hausbesitzer dabei berraschten.");
  erzeuge_benutzung(815, 1, POS_EGAL, "Jetzt, wo das Schloss schon offen ist... Tolle Hilfe.");
  erzeuge_untersuchung(815, 0, POS_EGAL, "Ohne den Zahlencode kommen wir hier nicht weiter.");
  erzeuge_untersuchung(815, 1, POS_EGAL, "Das Schloss ist offen.");
  r = erzeuge_kombination(1133, 815, -1, 0, POS_EGAL, POS_EGAL, "Du stellst den auf der Visitenkarte angegebenen Code ein und siehe da, das Schloss lsst sich ffnen."); {
    r->add_aktion(new AktionObjektNeuerZustand(this,815,1));
    r->add_aktion(new AktionObjektNeuerZustand(this,200090,ST_TUER_GESCHLOSSEN));
  }
  r = erzeuge_kombination(1131, 815, -1, 0, POS_EGAL, POS_EGAL, "Du stellst den auf dem Ausdruck angegebenen Code am Zahlenschloss ein und ziehst am Bgel. Nichts.\nEs muss ein anderer Code sein."); {
    r->add_trigger(CMD_KOMBINIERE,1132, 815);
    r->add_trigger(CMD_KOMBINIERE,1134, 815);
    r->add_trigger(CMD_KOMBINIERE,1135, 815);
    r->add_trigger(CMD_KOMBINIERE,1136, 815);
  }

  r = erzeuge_gehe(100150, "Als du die Treppe hochkommst, durchstringt ein markerschtterndes Piepen das Haus. Klingt nach der Auftauwarnung des Eisschranks. Hast du etwa den Strom abgestellt?\nhnliche berlegungen stellen auch die Nachbarn an, die in diesem Moment mit dem Hausbesitzer telefonieren."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1812, 1)); // Kchensicherung aus
    r->add_aktion(new AktionSpielVerloren(this));
  }

  r = erzeuge_gehe(100180, "Auf dem Weg in das Fernsehzimmer rutschst du auf dem seifigen Boden aus und schlgst mit dem Kopf auf. Du bist gerade lange genug ohnmchtig, um dem Hausbesitzer \"Guten Tag\" zu sagen."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100180, 1));
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r = erzeuge_gehe(100160, "Auf dem Weg in den Vorratsraum rutschst du auf dem seifigen Boden aus und schlgst mit dem Kopf auf. Du bist gerade lange genug ohnmchtig, um dem Hausbesitzer \"Guten Tag\" zu sagen."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100160, 1));
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r = erzeuge_gehe(100380, "Auf dem Weg in den Waschraum rutschst du auf dem seifigen Boden aus und schlgst mit dem Kopf auf. Du bist gerade lange genug ohnmchtig, um dem Hausbesitzer \"Guten Tag\" zu sagen."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100380, 1));
    r->add_aktion(new AktionSpielVerloren(this));
  }
  r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 200070, CEXT::ST_HANDTUCH_NASS, ST_TUER_OFFEN, POS_EGAL, POS_EGAL, "Du wischst den Flur bis in den Fernsehraum."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100180, 1));
    r->add_aktion(new AktionObjektNeuerZustand(this, 100180, 0));
  }
  r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 200090, CEXT::ST_HANDTUCH_NASS, ST_TUER_OFFENBLOCKIERT, POS_EGAL, POS_EGAL, "Du wischst den Flur bis in den Vorratsraum."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100160, 1));
    r->add_aktion(new AktionObjektNeuerZustand(this, 100160, 0));
  }
  r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 803, CEXT::ST_HANDTUCH_NASS, -1, POS_EGAL, POS_EGAL, "Du wischst den Flur bis in die Waschkche."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100380, 1));
    r->add_aktion(new AktionObjektNeuerZustand(this, 100380, 0));
  }
  r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 200070, CEXT::ST_HANDTUCH_SAUBER, ST_TUER_OFFEN, POS_EGAL, POS_EGAL, "Du wischst mit dem trockenen Handtuch ber den Boden und verteilst die Seife gleichmig."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100180, 1));
  }
  r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 200090, CEXT::ST_HANDTUCH_SAUBER, ST_TUER_OFFENBLOCKIERT, POS_EGAL, POS_EGAL, "Du wischst mit dem trockenen Handtuch ber den Boden und verteilst die Seife gleichmig."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100160, 1));
  }
  r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 803, CEXT::ST_HANDTUCH_SAUBER, -1, POS_EGAL, POS_EGAL, "Du wischst mit dem trockenen Handtuch ber den Boden und verteilst die Seife gleichmig."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 100380, 1));
  }



// 9 Vorratsraum


  erzeuge_gegenstand(905,900,true,false,true,"regal", "ein Regal", "",0);
  r=erzeuge_beschreibung(905, -1,"Das umgestrzte Regal hat sich fast im gesamten Raum verteilt."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 905, 2),
                                             new BedingungObjektHatZustand(this, 905, 3)));
  }
  r=erzeuge_beschreibung(905, -1,"Das sprlich gefllte Regal zieht sich lngst fast durch den gesamten Raum."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 905, 0),
                                             new BedingungObjektHatZustand(this, 905, 1)));
  }

  r = erzeuge_druecken(905, -1, POS_EGAL, "Ich finde, in diesem Raum haben wir schon genug Schaden angerichtet."); {
    r->add_trigger(CMD_ZIEHE, 905, -1);
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 905, 2),
                                             new BedingungObjektHatZustand(this, 905, 3)));
    r->add_aktion(new AktionObjektNeuerZustand(this,905,2));
    r->add_aktion(new AktionObjektNeuerZustand(this,912,1));
    r->add_aktion(new AktionObjektSetSichtbar(this,100240, false));
  }
  r = erzeuge_druecken(905, -1, POS_EGAL, "Du drckst krftig gegen das Regal, bis es mit einem Scheppern umfllt und den Weg in den Heizungsraum versperrt."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 905, 0),
                                             new BedingungObjektHatZustand(this, 905, 1)));
    r->add_aktion(new AktionObjektNeuerZustand(this,905,2));
    r->add_aktion(new AktionObjektNeuerZustand(this,912,1));
    r->add_aktion(new AktionObjektNeuerZustand(this,908,1));
    r->add_aktion(new AktionObjektSetSichtbar(this,100240, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,920, false));
    a=new AktionBedingt(this, r, new BedingungObjektNichtInInventar(this, 906), new AktionObjektSetSichtbar(this,906, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,907, false));
  }
  r = erzeuge_ziehen(905, -1, POS_EGAL, "Du ziehst mit aller Kraft am Regal und kannst gerade noch wegspringen, als die gesamte Konstruktion auf die Werkbank fllt."); {
    r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 905, 0),
                                             new BedingungObjektHatZustand(this, 905, 1)));
    r->add_aktion(new AktionObjektNeuerZustand(this,905,3));
    r->add_aktion(new AktionObjektNeuerZustand(this,910,1));
    r->add_aktion(new AktionObjektNeuerZustand(this,908,1));
    r->add_aktion(new AktionObjektSetSichtbar(this,100220, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,920, false));
    a=new AktionBedingt(this, r, new BedingungObjektNichtInInventar(this, 906), new AktionObjektSetSichtbar(this,906, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,907, false));
  }
  erzeuge_untersuchung(905, 1, POS_EGAL, "Ich kann keine weiteren Gegenstnde finden.");
  r=erzeuge_untersuchung(905, 0, POS_EGAL, "Du suchst die einzelnen Reihen des Regals ab und findest nichts ntzliches auer einem Marmeladenglas, einem Papierstapel und etwas, das aussieht wie eine Fernbedienung."); {
    r->add_aktion(new AktionObjektNeuerZustand(this,905,1));
    r->add_aktion(new AktionObjektSetSichtbar(this,906, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,907, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,908, true));
  }
  erzeuge_untersuchung(905, 2, POS_EGAL, "Die Stahlstreben des Regals sind so unglcklich vor den Heizungsraum gefallen, dass der Eingang versperrt ist.");
  erzeuge_untersuchung(905, 3, POS_EGAL, "Die Regalbretter mit allerlei Plunder verdecken die Werkecke. Bei dem Gewicht ist Wegrumen keine Option.");

  erzeuge_gegenstand(920,900,true,false,false,"leiter", "eine Leiter", "Vor dem Regal steht eine Klappleiter.",0);
  erzeuge_untersuchung(920, -1, POS_EGAL, "Die Leiter steht vor dem Regal und ermglicht auch das Erreichen der obersten Reihen.");
  r=erzeuge_kombination(808,905,-1,-1, POS_EGAL, POS_EGAL, "Du stellst die Leiter vor das Regal."); {
    r->add_aktion(new AktionObjektSetSichtbar(this,920, true));
    r->add_aktion(new AktionObjektSetSichtbar(this,808, false));
  }
  r=erzeuge_nehmen(920, -1, false, "Du packst die Leiter wieder in dein Gepck"); {
    r->add_aktion(new AktionObjektSetSichtbar(this,920, false));
    r->add_aktion(new AktionObjektSetSichtbar(this,808, true));

  }

  erzeuge_gegenstand(906,900,false,false,false,"marmeladenglas", "ein Marmeladenglas", "Links in der Mitte des Regals steht ein Marmeladenglas.");
  erzeuge_untersuchung(906, -1, POS_RAUM, "Aus der Entfernung kann ich nichts nheres erkennen.");
  erzeuge_benutzung(906, -1, POS_RAUM, "Erst mal haben, das Glas.");
  r=erzeuge_nehmen(906, -1, true, "Mit Vorfreude auf den Inhalt nimmst du das Glas aus dem Regal"); {
    r->add_bedingung(new BedingungObjektNichtInInventar(this, 906));
  }
  erzeuge_untersuchung(906, -1, POS_INVENTAR, "Sieht nach Erdbeere aus. Oder Kirsche. Vielleicht auch Himbeere. knnte auch Heidelbeere sein. Ich wei nicht, was drin ist. Der Aufkleber auf dem Deckel ist jedenfalls nicht mehr lesbar.");
  r=erzeuge_benutzung(906, -1, POS_INVENTAR, "Du ffnest das Glas, steckst einen Finger rein und leckst ihn ab. Im ersten Moment echt lecker, im zweiten Moment nicht mehr ganz so. Danach wird dir eher flau, dicht gefolgt von speibel. Wie gut, dass der Hausbesitzer schnell den Notarzt rief, nachdem er dich mit Schaum vor dem Mund im Vorratsraum gefunden hatte.\nZumindest weit du jetzt, warum das Etikett verblasst war."); {
    r->add_aktion(new AktionSpielVerloren(this));
  }


  erzeuge_gegenstand(907,900,false,false,false,"papierstapel", "ein Papierstapel", "Ganz unten neben einem Rudel Kochtpfe steht ein Papierstapel.");
  erzeuge_untersuchung(907, -1, POS_RAUM, "Ein Stapel mit weien Blttern im Format A4.");
  r=erzeuge_nehmen(907, -1, false, "Du hast doch schon eins."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 18));
  }
  r=erzeuge_nehmen(907, -1, false, "Du nimmst ein Blatt vom Stapel und packst es in die Tasche."); {
    r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 18));
    r->add_aktion(new AktionObjektSetSichtbar(this,18, true));
  }

  erzeuge_gegenstand(908,900,false,false,false,"fernbedienung", "eine Fernbedienung", "",0);
  erzeuge_beschreibung(908, 0, "Auf dem obersten Regalbrett ganz rechts liegt eine Fernbedienung.");
  erzeuge_beschreibung(908, 1, "Mitten unter den Regaltrmmern liegt eine Fernbedienung.");
  erzeuge_untersuchung(908, -1, POS_RAUM, "Ich kann von hier keine Details erkennen.");
  erzeuge_benutzung(908, -1, POS_RAUM, "Zu weit weg.");
  erzeuge_untersuchung(908, -1, POS_INVENTAR, "Knnte die Fernbedienung von einem DVD-Player oder einem Fernseher sein.");
  erzeuge_benutzung(908, -1, POS_INVENTAR, "Mit welchem Gert soll ich sie denn benutzen?");
  r=erzeuge_nehmen(908,0,false, "Ich komme da nicht dran."); {
    r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 920));
  }
  r=erzeuge_nehmen(908,0,true, "Du kletterst auf die Leiter und nimmst die Fernbedienung vom Regal."); {
    r->add_bedingung(new BedingungObjektNichtInInventar(this, 908));
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 920));
  }


  erzeuge_gegenstand(910,900,true,false,true,"werkecke", "eine Werkecke", "An der Wand links hinter dir ist eine Werkecke eingerichtet.",0);
  erzeuge_benutzung(910, 0, POS_EGAL, "Wir gehen besser nher ran.");
  erzeuge_untersuchung(910, 0, POS_EGAL, "Vielleicht finden wir dort hilfreiche Werkzeuge.");
  erzeuge_untersuchung(910, 1, POS_EGAL, "Die ganze Werkbank ist von der Regalkonstruktion verdekct, da ist kein Rankommen mehr.");

  erzeuge_gegenstand(912,900,true,false,true,"heizungsraum", "der Heizungsraum", "Hinten rechts geht es in den Heizungsraum.",0);
  erzeuge_untersuchung(912, 0, POS_EGAL, "Ich mag mich tuschen, aber ich glaube, im Heizungsraum werden wir die Heizung finden.");
  erzeuge_untersuchung(912, 1, POS_EGAL, "Dort wre es zum Heizungsraum gegangen, wenn du nicht das Regal davor gepoltert httest.");

  erzeuge_gegenstand(913,900,true,false,false,"schrank", "ein Schrank", "Neben dem Durchgang zum Heizungsraum steht der Schrank, den du aus dem Flur hierher geschoben hast.");
  erzeuge_oeffnen(913, -1, "Der Schrank ist leer.");
  r = erzeuge_untersuchung(913, -1, POS_EGAL, "Vom Schieben ber die hubbeligen Fliesen sind zwei Fe abgebrochen. Den bekommen wir hier nicht mehr weg."); {
    r->add_trigger(CMD_DRUECKE, 913, -1);
    r->add_trigger(CMD_ZIEHE, 913, -1);
  }

  erzeuge_gegenstand(915,900,true,false,true,"lichtschacht", "ein Lichtschacht", "An der linken Wand fast unter der Decke ist ein mit Styropor verschlossener Lichtschacht.");
  erzeuge_untersuchung(915, -1, POS_EGAL, "Das Styropor lsst keinerlei Licht in den Raum.");






// 10 Fernsehraum

  erzeuge_gegenstand(1005,1000,true,false,true,"lichtschacht", "ein Lichtschacht", "Dir gegenber fllt schwaches Sonnenlicht durch einen abgedunkelten Lichtschacht in den Raum.");
  erzeuge_untersuchung(1005, -1, POS_EGAL, "Der Lichtschacht ist oben vergittert.");

  erzeuge_gegenstand(1007,1000,true,false,true,"fenster", "ein Fenster", "Vor den Lichtschacht ist ein Fenster gesetzt.",0);
  erzeuge_untersuchung(1007, 0, POS_EGAL, "Das Fenster ist gekippt. Ein warmer Luftzug strmt in den Raum.");
  erzeuge_untersuchung(1007, 1, POS_EGAL, "Das Fenster ist geschlossen. Deshalb ist die Luft hier auch so stickig.");
  r=erzeuge_oeffnen(1007, 1); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_ESSSCHLUESSEL, CEXT::ST_ESSSCHLUESSEL_BLATT));
    r->add_aktion(new AktionObjektSetSichtbar(this, 203, false));
  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_SCHLIESSE, 1007, -1,false, true)); {
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1007,0));
    a->add_aktion(new AktionObjektNeuerZustand(this, 1007, 1));
    a->add_aktion(new AktionTextausgabe(this, "Du schliet das Fenster."));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1007,1));
    a->add_aktion(new AktionTextausgabe(this, "Das Fenster ist bereits geschlossen."));
  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_OEFFNE, 1007, -1,false, true)); {
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1007,1));
    a->add_aktion(new AktionObjektNeuerZustand(this, 1007, 0));
    a->add_aktion(new AktionTextausgabe(this, "Du ffnest das Fenster und kippst es."));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1007,0));
    a->add_aktion(new AktionTextausgabe(this, "Das Fenster ist bereits geffnet."));
  }

  erzeuge_gegenstand(1010,1000,true,false,true,"TV", "ein TV", "Darunter ist ein riesiger 3D-Flachbildschirm mit integriertem Bluray-Player und Verstrker an die Wand montiert.");
  erzeuge_untersuchung(1010, -1, POS_EGAL, "Der Fernseher besitzt keine offensichtlichen Knpfe zur Bedienung.");
  erzeuge_benutzung(1010, -1, POS_EGAL, "Dazu bruchten wir wohl eine Fernbedienung.");
  erzeuge_nehmen(1010, -1, false, "Ich wei, wirklich verlockend, aber unsere Tasche ist einfach nicht gro genug.");
  r=erzeuge_kombination(908,1010,-1,-1,POS_EGAL, POS_EGAL, "Du schaltest den Fernseher mit der Fernbedienung ein. Der Bass hmmert so laut aus dem Subwoofer, dass es dir im Bauch schmerzt. Schnell schaltest du das Fernsehgert wieder aus."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1013, 0));
    a=new AktionBedingt(this, r, new BedingungObjektIstSichtbar(this, 1515));
    a->add_aktion(new AktionTextausgabe(this, "Du denkst nach. ber dir ist doch das Wohnzimmer. Dir kommt eine Idee."));
  }
  r=erzeuge_kombination(908,1010,-1,-1,POS_EGAL, POS_EGAL, "Du schaltest den Fernseher mit der Fernbedienung ein. Ohne einen korrekt angeschlossenen Subwoofer klingt der Sound dnn wie eine Nhmaschine. Enttuscht schaltest du wieder aus."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1013, 1));
  }
  r=erzeuge_kombination(908,1010,-1,-1,POS_EGAL, POS_EGAL, "Du schaltest den Fernseher mit der Fernbedienung ein. Mit voller Kraft hmmert der Subwoofer gegen die Decke. Du gibst dem ganzen Versuch eine Minute, dann schaltest du den Fernseher wieder aus."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1013, 2));
    r->add_aktion(new AktionObjektNeuerZustand(this, 515, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 515, true));
  }

  erzeuge_gegenstand(1012,1000,true,false,true,"sofa", "ein Sofa", "Ein kuscheliges dreisitziges Sofa vor dem Fernseher ldt zu gemtlichen Filmabenden ein.");
  erzeuge_untersuchung(1012, -1, POS_EGAL, "Das Sofa macht einen so gemtlichen Eindruck, dass man beim Betrachten schon fast einschlft.");
  r = erzeuge_benutzung(1012, -1, POS_EGAL, "Du setzt dich auf das Sofa. Unglaublich, wie gemtlich das ist.\nDu kannst nicht anders und legst dich hin. Und dann schlfst du ein.\nAufgeweckt wirst du vom freundlichen Hausbesitzer, allerdings nicht mit Kaffee."); {
    r->add_aktion(new AktionSpielVerloren(this));
  }

  erzeuge_gegenstand(1013,1000,true,false,true,"subwoofer", "ein Subwoofer", "",0);
  erzeuge_beschreibung(1013, 0, "Hinter der Rckenlehne des Sofas ist der gewaltige Subwoofer des Audiosystems platziert.");
  erzeuge_beschreibung(1013, 1, "Hinter der Rckenlehne des Sofas steht der gewaltige Subwoofer dicht unter der Decke auf einem Schrank.");
  erzeuge_untersuchung(1013, 0, POS_EGAL, "Der Wrfel mit 1 Meter Kantenlnge hat einen enormen Basslautsprecher eingebaut, der auf dich gerichtet ist.");
  erzeuge_untersuchung(1013, 1, POS_EGAL, "Der Subwoofer ist tot, weil das Boxenkabel nicht angeschlossen ist.");
  erzeuge_untersuchung(1013, 2, POS_EGAL, "Der Subwoofer ist angeschlossen und einsatzbereit.");
  erzeuge_benutzung(1013, -1, POS_EGAL, "Was soll ich machen? Mir das Lautsprecherkabel in die Nasenlcher stecken und singen?");
  r = erzeuge_druecken(1013, -1, POS_EGAL, "Ich werde das Ding jetzt nicht durch den Raum schieben."); {
    r->add_trigger(CMD_ZIEHE, 1013, -1);
  }
  erzeuge_nehmen(1013, -1, false, "Ist mir echt zu schwer.");
  r=erzeuge_kombination(1013, 1020, 0, -1, POS_EGAL, POS_EGAL, "Du hievst den Subwoofer mit dem Basslautsprecher nach oben auf den Schrank. Dabei reit das Lautsprecherkabel aus der Box."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1013, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1025, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1020, false));
  }

  erzeuge_gegenstand(1025,1000,true,false,false,"boxenkabel", "ein Boxenkabel", "Neben dem Schrank endet das abgerissene Boxenkabel.",0);
  erzeuge_untersuchung(1025, 0, POS_EGAL, "Am Ende des Boxenkabels sind zwei abisolierte Litzen. Das Kabel war wohl zu kurz.");
  erzeuge_untersuchung(1025, 1, POS_EGAL, "Durch die Verlngerung mit dem Stromkabel sollte das Boxenkabel jetzt lang genug sein.");
  erzeuge_kombination(1025, 1013, 0, -1, POS_EGAL, POS_EGAL, "Du versuchst, das Boxenkabel wieder am Subwoofer anzuschlieen, aber es ist einfach zu kurz.");
  erzeuge_kombination(1025, 23, 0, 0, POS_EGAL, POS_EGAL, "Das geht nicht, dazu bruchte das Kabel abisolierte Enden.");
  r=erzeuge_kombination(1025, 23, 0, 1, POS_EGAL, POS_EGAL, "Du nimmst vom Stromkabel zwei Adern und verbindest sie mit dem Boxenkabel."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1025, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 23, false));
  }
  r=erzeuge_kombination(1025, 1013, 1, -1, POS_EGAL, POS_EGAL, "Das verlngerte Kabel reicht gerade bis zum Subwoofer. Du schliet es wieder an. Keine optimale Lsung fr Hifi-Liebhaber, aber es muss gehen."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1013, 2));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1025, false));
  }

  erzeuge_gegenstand(1020,1000,true,false,false,"schrank", "ein Schrank", "Fast in der Mitte des Raums steht der Schrank, den du aus dem Flur hierher geschoben hast.");
  erzeuge_oeffnen(1020, -1, "Der Schrank ist leer.");
  r = erzeuge_untersuchung(1020, -1, POS_EGAL, "Vom Schieben ber die hubbeligen Fliesen sind zwei Fe abgebrochen. Den bekommen wir hier nicht mehr weg."); {
    r->add_trigger(CMD_DRUECKE, 1020, -1);
    r->add_trigger(CMD_ZIEHE, 1020, -1);
  }

  erzeuge_gegenstand(1015,1000,true,false,true,"Schreibtisch", "ein Schreibtisch", "Links von dir an der Wand steht ein Schreibtisch mit Computeranlage.");
  erzeuge_nehmen(1015, -1, false, "Ich bin kein Spediteur.");
  erzeuge_untersuchung(1015, -1, POS_EGAL, "Die Computeranlage knnte fr uns interessant sein.");
  erzeuge_benutzung(1015, -1, POS_EGAL, "Da komme ich von hier nicht dran.");




// 11 Schreibtisch

  erzeuge_gegenstand(1105,1100,true,false,true,"tastatur", "eine Tastatur", "Direkt vor dir auf dem Schreibtisch steht eine schwarze Tastatur.",0);
  erzeuge_untersuchung(1105, -1, POS_EGAL, "So wie die Tastatur aussieht, sind die Kontakte bestimmt vergoldet.");
  erzeuge_nehmen(1105, -1, false, "Die werden wir bestimmt noch hier am PC brauchen.");
  erzeuge_benutzung(1105, 0, POS_EGAL, "Weit du, was wir eintippen sollen? Ich nicht. Ich habe bisher nicht mal auf den Monitor gesehen...");
  get_regeln()->add_regel(r=new Spielregel(this, CMD_BENUTZE, 1105, -1)); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1105, 1));
    r->add_aktion(new AktionRaumwechsel(this, 1200));
  }

  erzeuge_gegenstand(1110,1100,true,false,true,"maus", "eine Maus", "Rechts daneben liegt eine dazu passende schwarze Maus mit neun Tasten.",0);
  erzeuge_untersuchung(1110, -1, POS_EGAL, "Bei einer Maus mit so vielen Tasten wird hier vermutlich nur gespielt.");
  erzeuge_nehmen(1110, -1, false, "Die ist viel zu protzig fr uns Programmierer.");
  erzeuge_benutzung(1110, 0, POS_EGAL, "Keine Ahnung, was ich mit dem Ding machen soll. Vielleicht steht was auf dem Bildschirm.");
  erzeuge_benutzung(1110, 1, POS_EGAL, "Das ist ein DOS-Programm, da hilft die Maus nicht weiter.");

  erzeuge_gegenstand(1115,1100,true,false,true,"monitor", "ein Monitor", "Der LED-Monitor dahinter hat stolze 26\" mit HD-Auflsung.",0);
  erzeuge_benutzung(1115, -1, POS_EGAL, "Wir lassen ihn besser eingeschaltet, dann sehen wir mehr.");
  r=erzeuge_untersuchung(1115, 0, POS_EGAL, "Es luft wohl gerade ein DOS-Programm (scheint wieder in Mode zu kommen). Auf dem Bildschirm steht:\n \nDie Antwort auf alles mit sich selbst konfrontiert.\n1 - 0784\n2 - 1225\n3 - 1764\n4 - 2401\n5 - 3136\n6 - 3969"); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1105, 1));
    r->add_aktion(new AktionObjektNeuerZustand(this, 1110, 1));
  }

  erzeuge_gegenstand(CEXT::OBJ_ZANGE,1100,false,false,true,"zange", "eine Zange", "Auf dem Monitorfu liegt eine Zange.",0);
  erzeuge_untersuchung(CEXT::OBJ_ZANGE, -1, POS_EGAL, "Eine gute alte Kombizange aus massivem Metall.");
  erzeuge_benutzung(CEXT::OBJ_ZANGE, -1, POS_EGAL, "Du willst dir doch wohl keinen Zahn ziehen.");
  erzeuge_kombination(CEXT::OBJ_ZANGE, 815, -1, -1, POS_EGAL, POS_EGAL, "Das Schloss ist aus Stahl, nicht aus Plastik.");
  erzeuge_kombination(CEXT::OBJ_ZANGE, 15, -1, -1, POS_EGAL, POS_EGAL, "Keine Chance, das Plastik von der Schraube abzubekommen.");
  erzeuge_kombination(CEXT::OBJ_ZANGE, 225, -1, -1, POS_EGAL, POS_EGAL, "Du ziehst mit der Zange am Dbel, aber mit den Fingern lsst sich die Schraube nicht krftig genug festhalten.");

  erzeuge_gegenstand(1120,1100,true,false,true,"drucker", "ein Drucker", "Der Laserdrucker links auf dem Tisch der Firma Go kann sogar farbig drucken.",0);
  erzeuge_benutzung(1120, -1, POS_EGAL, "Wenn du drucken willst, musst du das ber den PC machen.");
  erzeuge_untersuchung(1120, 0, POS_EGAL, "Alles bereit zum Drucken, du musst nur sagen, was.");
  erzeuge_untersuchung(1120, 1, POS_EGAL, "Der Drucker hat kein Papier mehr.");

  erzeuge_gegenstand(1131,1100,false,false,false,"visitenkarte", "eine Visitenkarte", "Auf der Ablageflche des Druckers liegt eine Visitenkarte.");
  erzeuge_untersuchung(1131, -1, POS_EGAL, "Auf der Visitenkarte steht 0784 in schwarz gedruckt.");
  erzeuge_gegenstand(1132,1100,false,false,false,"visitenkarte", "eine Visitenkarte", "Auf der Ablageflche des Druckers liegt eine Visitenkarte.");
  erzeuge_untersuchung(1132, -1, POS_EGAL, "Auf der Visitenkarte steht 1225 in schwarz gedruckt.");
  erzeuge_gegenstand(1133,1100,false,false,false,"visitenkarte", "eine Visitenkarte", "Auf der Ablageflche des Druckers liegt eine Visitenkarte.");
  erzeuge_untersuchung(1133, -1, POS_EGAL, "Auf der Visitenkarte steht 1764 mit bunten Ziffern gedruckt.");
  erzeuge_gegenstand(1134,1100,false,false,false,"visitenkarte", "eine Visitenkarte", "Auf der Ablageflche des Druckers liegt eine Visitenkarte.");
  erzeuge_untersuchung(1134, -1, POS_EGAL, "Auf der Visitenkarte steht 2401 in schwarz gedruckt.");
  erzeuge_gegenstand(1135,1100,false,false,false,"visitenkarte", "eine Visitenkarte", "Auf der Ablageflche des Druckers liegt eine Visitenkarte.");
  erzeuge_untersuchung(1135, -1, POS_EGAL, "Auf der Visitenkarte steht 3136 in schwarz gedruckt.");
  erzeuge_gegenstand(1136,1100,false,false,false,"visitenkarte", "eine Visitenkarte", "Auf der Ablageflche des Druckers liegt eine Visitenkarte.");
  erzeuge_untersuchung(1136, -1, POS_EGAL, "Auf der Visitenkarte steht 3969 in schwarz gedruckt.");

  erzeuge_gegenstand(1150,1100,true,false,true,"schreibtisch", "ein Schreibtisch", "");
  erzeuge_untersuchung(1150, -1, POS_EGAL, "Das ist der Schreibtisch fr die Computeranlage.");
  r=erzeuge_kombination(908, 1150, -1, -1, POS_EGAL, POS_EGAL, "Du legst die Fernbedienung auf den Schreibtisch."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 908, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1160, true));
  }

  erzeuge_gegenstand(1160,1100,true,false,false,"fernbedienung", "eine Fernbedienung", "Direkt am Tischrand liegt eine Fernbedienung.");
  erzeuge_untersuchung(1160, -1, POS_EGAL, "Das ist die Fernbedienung fr den Fernseher.");
  erzeuge_benutzung(1160, -1, POS_EGAL, "Dazu halte ich sie lieber in der Hand.");
  r = erzeuge_nehmen(1160, -1, false, "Du packst die Fernbedienung wieder in deine Tasche."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 908, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1160, false));
  }





// 12 Tastatur

  r=erzeuge_druecken(1205, -1, POS_EGAL, "Du drckst die Taste.\nDer Drucker macht ein merkwrdiges Gerusch und piept dreimal laut. Offenbar ist kein Papier mehr im Fach."); {
    r->add_trigger(CMD_DRUECKE, 1206,-1);
    r->add_trigger(CMD_DRUECKE, 1207,-1);
    r->add_trigger(CMD_DRUECKE, 1208,-1);
    r->add_trigger(CMD_DRUECKE, 1209,-1);
    r->add_trigger(CMD_DRUECKE, 1210,-1);
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 1));
    r->add_aktion(new AktionRaumwechsel(this, 1100));
  }

  erzeuge_gegenstand(1205,1200,true,false,true,"taste 1", "die Taste 1", "");
  r=erzeuge_druecken(1205, -1, POS_EGAL, "Du drckst die Taste 1."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 0));
//    r->add_aktion(new AktionObjektNeuerZustand(this, 1120, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1131, 1));
  }

  erzeuge_gegenstand(1206,1200,true,false,true,"taste 2", "die Taste 2", "");
  r=erzeuge_druecken(1206, -1, POS_EGAL, "Du drckst die Taste 2."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 0));
//    r->add_aktion(new AktionObjektNeuerZustand(this, 1120, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1132, 1));
  }

  erzeuge_gegenstand(1207,1200,true,false,true,"taste 3", "die Taste 3", "");
  r=erzeuge_druecken(1207, -1, POS_EGAL, "Du drckst die Taste 3."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 0));
//    r->add_aktion(new AktionObjektNeuerZustand(this, 1120, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1133, 1));
  }

  erzeuge_gegenstand(1208,1200,true,false,true,"taste 4", "die Taste 4", "");
  r=erzeuge_druecken(1208, -1, POS_EGAL, "Du drckst die Taste 4."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 0));
//    r->add_aktion(new AktionObjektNeuerZustand(this, 1120, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1134, 1));
  }

  erzeuge_gegenstand(1209,1200,true,false,true,"taste 5", "die Taste 5", "");
  r=erzeuge_druecken(1209, -1, POS_EGAL, "Du drckst die Taste 5."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 0));
//    r->add_aktion(new AktionObjektNeuerZustand(this, 1120, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1135, 1));
  }

  erzeuge_gegenstand(1210,1200,true,false,true,"taste 6", "die Taste 6", "");
  r=erzeuge_druecken(1210, -1, POS_EGAL, "Du drckst die Taste 6."); {
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 0));
//    r->add_aktion(new AktionObjektNeuerZustand(this, 1120, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1136, 1));
  }

  erzeuge_gegenstand(1211,1200,true,false,true,"Enter", "die Taste Enter", "");
  r=erzeuge_druecken(1211, -1, POS_EGAL, "Du drckst Enter. Und nichts passiert."); {
    r->add_aktion(new AktionRaumwechsel(this, 1100));
  }

  r=erzeuge_druecken(1205, -1, POS_EGAL, ""); {
    r->add_trigger(CMD_DRUECKE, 1206,-1);
    r->add_trigger(CMD_DRUECKE, 1207,-1);
    r->add_trigger(CMD_DRUECKE, 1208,-1);
    r->add_trigger(CMD_DRUECKE, 1209,-1);
    r->add_trigger(CMD_DRUECKE, 1210,-1);
    r->add_bedingung(new BedingungObjektHatZustand(this, 1120, 0));
    r->add_aktion(new AktionObjektNeuerZustand(this, 1120, 1));
    r->add_aktion(new AktionRaumwechsel(this, 1100));
    r->add_aktion(new AktionTextausgabe(this, "Das Geblse des Druckers beginnt zu rauschen. Kurz darauf spuckt er eine Visitenkarte auf die Ablage."));
  }


// 13 Werkecke

  erzeuge_gegenstand(1305,1300,true,false,true,"Schraubstock", "ein Schraubstock", "Direkt vor dir wurde ein Schraubstock fest auf die Arbeitsplatte montiert.", 0);
  erzeuge_untersuchung(1305, 0, POS_EGAL, "Der Schraubstock hat zwei Backen und ein Drehrad zum Festspannen. Mehr braucht er auch nicht.");
  erzeuge_benutzung(1305, 0, POS_RAUM, "Du hltst deinen Finger zwischen die Backen des Schraubstocks und spannst so lange, bis du schreist. Dann lockerst du ihn wieder und schaust dir deinen roten Daumen an.");
  erzeuge_benutzung(1305, 1, POS_RAUM, "Ohne Werkzeug geht es wohl nicht.");

  // geschmolzener Duebel
  r=erzeuge_untersuchung(1305, 1, POS_EGAL, "Du hast den geschmolzenen Dbel in den Schraubstock eingespannt."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 1311));
  }
  erzeuge_kombination(15, 1305, -1, 1, POS_INVENTAR, POS_RAUM, "Da ist schon etwas eingespannt.");
  r=erzeuge_kombination(15, 1305, -1, 0, POS_INVENTAR, POS_RAUM, "Du spannst den geschmolzenen Dbel in den Schraubstock ein."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1311, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 15, false));
  }
  r=erzeuge_nehmen(1311,1, false, "Du nimmst den geschmolzenen Dbel wieder aus dem Schraubstock. Eigentlich knntest du ihn gleich wegwerfen."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1311, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 15, true));
  }
  erzeuge_kombination(CEXT::OBJ_ZANGE, 1311, -1, -1, POS_INVENTAR, POS_RAUM, "Du packst den Dbel mit der Zange und ziehst wie verrckt, aber du bekommst das geschmolzene Plastik einfach nicht ab.");


  // geduebelte Schraube
  r=erzeuge_untersuchung(1305, 1, POS_EGAL, "Du hast die gedbelte Schraube in den Schraubstock eingespannt."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 1310));
  }
  erzeuge_kombination(225, 1305, -1, 1, POS_INVENTAR, POS_RAUM, "Da ist schon etwas eingespannt.");
  r=erzeuge_kombination(225, 1305, -1, 0, POS_INVENTAR, POS_RAUM, "Du spannst die gedbelte Schraube in den Schraubstock ein."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1310, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 225, false));
  }
  r=erzeuge_nehmen(1310,1, false, "Du nimmst die Schraube mit Dbel wieder aus dem Schraubstock."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1310, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 225, true));
  }
  r=erzeuge_kombination(CEXT::OBJ_ZANGE, 1310, -1, -1, POS_INVENTAR, POS_RAUM, "Du packst den Dbel mit der Zange und drehst und ziehst mit aller Kraft. Nach einer endlos erscheinenden Zeit hast du ihn endlich von der Schraube runter und packst beides in deine Tasche."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1310, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 225, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 16, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 17, true));
  }

  //Seifenspender
  r=erzeuge_untersuchung(1305, 1, POS_EGAL, "Du hast den Seifenspender in den Schraubstock eingespannt."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 1312));
  }
  r =erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 1305, -1 , -1, POS_INVENTAR, POS_RAUM, "Hier knnen wir mit dem Seifenspender nichts mehr machen."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_ORG));

  }
  erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 1305, CEXT::ST_SEIFE_ORG, 1, POS_INVENTAR, POS_RAUM, "Da ist schon etwas eingespannt.");
  r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 1305, CEXT::ST_SEIFE_ORG, 0, POS_INVENTAR, POS_RAUM, "Du spannst den Seifenspender in den Schraubstock ein."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1312, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_SEIFENSPENDER, false));
  }
  r=erzeuge_nehmen(1312,1, false, "Du nimmst den Seifenspender wieder aus dem Schraubstock."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1312, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_SEIFENSPENDER, true));
  }
  erzeuge_kombination(CEXT::OBJ_ZANGE, 1312,-1, -1, POS_EGAL, POS_EGAL, "Du packst den Verschluss mit der Zange, aber er sitzt so fest, dass er sich keinen Millimeter bewegt.");
  r=erzeuge_kombination(420, 1312, -1, -1, POS_INVENTAR, POS_RAUM, "Du greifst die Glasscherbe mit beiden Hnden und schneidest mit aller Kraft den Verschluss vom Seifenspender ab. Zufrieden mit dem Ergebnis packst du den Seifenspender wieder ein."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1312, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_SEIFENSPENDER, true));
    r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_LEER));
  }

  //Bartschluessel
  r=erzeuge_untersuchung(1305, 1, POS_EGAL, "Du hast den Bartschlssel in den Schraubstock eingespannt."); {
    r->add_bedingung(new BedingungObjektIstSichtbar(this, 1313));
  }
  r =erzeuge_kombination(21, 1305, -1 , -1, POS_INVENTAR, POS_RAUM, "Besser bekomme ich sie beim zweiten Mal auch nicht hin."); {
  }
  erzeuge_kombination(20, 1305, -1, 1, POS_INVENTAR, POS_RAUM, "Da ist schon etwas eingespannt.");
  r=erzeuge_kombination(20, 1305, -1, 0, POS_INVENTAR, POS_RAUM, "Du spannst den Bartschlssel in den Schraubstock ein."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1313, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 20, false));
  }
  r=erzeuge_nehmen(1313,1, false, "Du nimmst den Bartschlssel wieder aus dem Schraubstock."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1313, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 20, true));
  }
  r=erzeuge_kombination(2410, 1313, -1, -1, POS_INVENTAR, POS_RAUM, "Eigentlich ist sie nicht dafr gedacht, aber es scheint zu funktionieren. Du sgst den Bart und den Schlsselgriff ab und erhltst eine kleine Metallstange, die du in deine Tasche packst."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1305, 0));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1313, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 21, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 20, false));
  }
  r=erzeuge_kombination(420, 1313, -1, -1, POS_INVENTAR, POS_RAUM, "Du setzt mit der Glasscherbe am Schlssel an und drckst mit aller Kraft. Doch das Metall ist strker und zerbricht die Glasscherbe in kleine Stcke."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 420, false));
  }
  erzeuge_kombination(CEXT::OBJ_ZANGE, 1313, -1, -1, POS_INVENTAR, POS_RAUM, "Du versuchst, mit der Zange den Bart abzubrechen, aber keine Chance.");

  erzeuge_gegenstand(1310,1300,false,false,false,"gedbelte Schraube", "eine gedbelte Schraube", "Im Schraubstock ist die Schraube mit Dbel eingespannt.", 1);
  erzeuge_untersuchung(1310, 1, POS_EGAL, "Die gedbelte Schraube ist im Schraubstock eingespannt.");

  erzeuge_gegenstand(1311,1300,false,false,false,"geschmolzener Dbel", "eine geschmolzener Dbel", "Im Schraubstock ist der geschmolzene Dbel eingespannt.", 1);
  erzeuge_untersuchung(1311, 1, POS_EGAL, "Der gescmolzene Dbelklumpen ist im Schraubstock eingespannt.");

  erzeuge_gegenstand(1312,1300,false,false,false,"seifenspender", "ein Seifenspender", "Im Schraubstock ist der Seifenspender eingespannt.", 1);
  erzeuge_untersuchung(1312, 1, POS_EGAL, "Der Seifenspender ist im Schraubstock eingespannt.");

  erzeuge_gegenstand(1313,1300,false,false,false,"bartschlssel", "ein Bartschlssel", "Im Schraubstock ist der Bartschlssel eingespannt.", 1);
  erzeuge_untersuchung(1313, 1, POS_EGAL, "Das ist der Bartschlssel fr die Tr vom Flur ins Esszimmer.");





// 14 Heizungsraum

  erzeuge_gegenstand(1410,1400,true,false,true,"Lampe", "eine Lampe", "", 0);
  erzeuge_beschreibung(1410, 0, "An der Decke hngt eine kaputte Lampe.");
  erzeuge_beschreibung(1410, 1, "An der Decke hngt eine Lampe, die den Raum angenehm ausleuchtet.");
  erzeuge_untersuchung(1410, 0, POS_EGAL, "Die Lampe besteht nur aus einer nackten Fassung an einem Stromkabel. So dunkel, wie es ist, muss die Birne kaputt sein.");
  erzeuge_untersuchung(1410, 1, POS_EGAL, "Die reparierte Lampe versieht ihren Dienst wieder ordnungsgem.");
  erzeuge_kombination(417,1410, -1, -1,POS_EGAL,POS_EGAL, "Die Fassung ist fr diese Birne zu klein.");
  erzeuge_kombination(CEXT::OBJ_ZANGE,1410, -1, 1,POS_EGAL,POS_EGAL, "Jetzt, wo sie so schn leuchtet, knnen wir sie auch hngen lassen.");
  r=erzeuge_kombination(CEXT::OBJ_ZANGE,1410, -1, 0,POS_EGAL,POS_EGAL, "Du pitschst das Kabel kurz ber der Lampenfassung durch und packst sie ein."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 25, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1410, false));
  }
  r=erzeuge_kombination(1930,1410, -1, 0,POS_EGAL,POS_EGAL, "Du tauschst die kaputte Birne aus mit der aus der Flurlampe herausgedrehten."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1410, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1930, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1430, true));
  }

  erzeuge_gegenstand(1415,1400,true,false,true,"heiwasserkessel", "ein Heiwasserkessel", "Abgesehen von einem gelegentlichen thermischen Klicken des Heiwasserkessels in der hintersten Ecke ist es hier vollkommen ruhig.");
  erzeuge_benutzung(1420, -1, POS_EGAL, "Hier wird das heie Wasser nur gemacht. Bekommen tust du es an einem Wasserhahn.");
  r=erzeuge_untersuchung(1415, -1, POS_EGAL, "In der Dunkelheit ist nichts zu erkennen."); {
    r->add_trigger(CMD_UNTERSUCHE, 1420, -1);
    r->add_bedingung(new BedingungObjektHatZustand(this, 1410, 0));
  }
  r=erzeuge_untersuchung(1415, -1, POS_EGAL, "An dem Gert ist nichts auergewhnliches festzustellen."); {
    r->add_trigger(CMD_UNTERSUCHE, 1420, -1);
    r->add_bedingung(new BedingungObjektHatZustand(this, 1410, 1));
  }

  erzeuge_gegenstand(1420,1400,true,false,true,"heizung", "eine Heizung", "Direkt neben dem Heiwasserkessel steht die Heizung.");
  erzeuge_benutzung(1420, -1, POS_EGAL, "Ich dachte, dir wre vor Aufregung schon warm genug.");

  erzeuge_gegenstand(1430,1400,true,false,false,"karton", "ein Karton.", "Auf der Heizung steht ein Karton.", 0);
  erzeuge_untersuchung(1430, 0, POS_EGAL, "Ein groer Karton, der rumdum mit Paketband verklebt ist.");
  erzeuge_untersuchung(1430, 1, POS_EGAL, "Der Karton ist oben aufgeschnitten.");
  r=erzeuge_druecken(1430, -1, POS_EGAL, "Wenn er runter fllt, geht noch was kaputt."); {
    r->add_trigger(CMD_ZIEHE, 1430, -1);
  }
  erzeuge_oeffnen(1430, 0, "Mit bloen Hnden bekomme ich den nicht auf.");
  erzeuge_oeffnen(1430, 1, "Er ist bereits offen.");
  r=erzeuge_kombination(CEXT::OBJ_ZANGE, 1430, -1, 0,POS_EGAL,POS_EGAL, "Ich wei nicht, wo ich mit der Zange zum Aufreien anpacken knnte.");
  r=erzeuge_kombination(420, 1430, -1, 1,POS_EGAL,POS_EGAL, "Er ist schon offen, du musst ihn nicht gleich shreddern.");
  r=erzeuge_kombination(420, 1430, -1, 0,POS_EGAL,POS_EGAL, "Du schneidest den Karton auf und findest darin eine Anleitung. Du packst sie zu deinen anderen Sachen."); {
    r->add_aktion(new AktionObjektNeuerZustand(this, 1430, 1));
    r->add_aktion(new AktionObjektSetSichtbar(this, 26, true));
  }





// 15 Lesebereich

  erzeuge_gegenstand(1510,1500,true,false,true,"regalwand", "eine Regalwand", "Die vordere Wand ist komplett von einer Regalwand eingenommen, die vollgepfropft ist mit Bchern und Krimskram.", 0);
  r = erzeuge_druecken(1510, -1, POS_EGAL, "In so einer gemtlichen Ecke sollten wir nicht randalieren."); {
    r->add_trigger(CMD_ZIEHE, 1510, -1);
  }
  erzeuge_untersuchung(1510, 1, POS_EGAL, "Sonst gibt das Regal nichts interessantes her.");
  r=erzeuge_untersuchung(1510, 0, POS_EGAL, "Du suchst die Reihen des Regals ab. Unter dem Tand und den Bchern findest du ein Buch, dessen Titel dich besonders anspricht, und einen Schraubendreher."); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 1515, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1516, true));
    r->add_aktion(new AktionObjektNeuerZustand(this, 1510, 1));
  }
  r=erzeuge_kombination(808, 1510, -1,-1, POS_EGAL, POS_EGAL, "Auf eine Leiter, die auf einem solch wackeligen Teppich steht, bekommen mich keine zehn Pferde."); {
    r->add_trigger(CMD_KOMBINIERE,808, 1518);
  }

  erzeuge_gegenstand(1512,1500,true,false,true,"vase", "eine Vase", "Ganz oben auf dem Regal steht eine mit Glasmurmeln gefllte Vase. Obenauf liegt ein Schlsselbund.", 0);
  erzeuge_untersuchung(1512, -1, POS_RAUM, "Schlssel knnen wir immer gut gebrauchen. Hoffentlich sind es nicht die Ersatzschlssel der Nachbarn.");
  erzeuge_nehmen(1512, -1, false, "So weit oben komme ich nicht dran. Die Decken sind nicht so niedrig wie in den Fluren.");
  r=erzeuge_kombination(515, 1512, -1,-1, POS_EGAL, POS_EGAL, "Du wirfst mit der Glasmurmel nach der Vase. Die Vase zerspringt unter der Wucht des Aufpralls. Die Glasmurmeln fallen und verteilen sich auf dem Boden. Der Schlsselbund fllt vor das Regal"); {
    r->add_aktion(new AktionObjektSetSichtbar(this, 1530, true));
    r->add_aktion(new AktionObjektSetSichtbar(this, 1512, false));
    r->add_aktion(new AktionObjektSetSichtbar(this, 515, false));
  }

  erzeuge_gegenstand(1515,1500,false,false,false,"schraubendreher", "ein Schraubendreher", "", 0);
  erzeuge_benutzung(1515, -1, POS_RAUM, "Das ist kein ferngesteuerter Schraubendreher.");
  erzeuge_untersuchung(1515, -1, POS_RAUM, "Ich sehe von hier nicht mal, ob es ein Schlitz- oder Kreuzschlitzschraubendreher ist.");
  erzeuge_benutzung(1515, 0, POS_INVENTAR, "Hast du etwa eine Schraube locker?");
  erzeuge_untersuchung(1515, -1, POS_INVENTAR, "Ein mittelgroer Kreuzschlitzschraubendreher.");

  erzeuge_gegenstand(1516,1500,false,false,false,"buch", "ein Buch", "", 0);
  r =erzeuge_benutzung(1516, -1, POS_RAUM, "Ich habe kein Opernglas dabei."); {
    r->add_trigger(CMD_UNTERSUCHE,1516,-1);
  }
  erzeuge_benutzung(1516, 0, POS_INVENTAR, "Das Buch hat etwa 1100 Seiten, ich lese die jetzt nicht auf Verdacht alle durch.");
  erzeuge_untersuchung(1516, 0, POS_INVENTAR, "Das Buch hat den Titel \"Ausbrechen leicht gemacht\". Wenn das kein Zeichen ist.");

  erzeuge_gegenstand(1518,1500,true,false,true,"teppich", "ein Teppich", "Vor dem Regal liegt in voller Breite einer dieser extrem weichen und kuscheligen Langhaarteppiche.");
  erzeuge_untersuchung(1518, 0, POS_EGAL, "Manche wren froh, sie htten so lange Haare.");
  erzeuge_ziehen(1518, 0, POS_EGAL, "Auf dem Rand des Teppichs steht das Regal, keine Chance, den wegzuziehen.");
  erzeuge_benutzung(1518, 0, POS_EGAL, "Du lsst keine Schlafmglichkeit aus, was?");

  erzeuge_gegenstand(1520,1500,true,false,true,"sessel", "ein Sessel", "Rechts davor steht ein gemtlicher Lehnensessel, in dem schon so manches Buch durchgelesen wurde.", 0);
  erzeuge_untersuchung(1520, 0, POS_RAUM, "Der Sessel ist auf der Sitzflche und den Lehnen stark abgenutzt. Er hat schon viele Stunden in Begleitung verbracht.");
  erzeuge_benutzung(1520, 0, POS_RAUM, "Du setzt dich kurz hin. Er ist wirklich so bequem, wie er aussieht. Schnell stehst du auf, bevor du einschlfst.");
  r = erzeuge_druecken(1520, -1, POS_EGAL, "Ich finde, er steht an dieser Stelle pefekt."); {
    r->add_trigger(CMD_ZIEHE, 1520, -1);
  }

  erzeuge_gegenstand(1530,1500,false,false,false,"schlsselbund", "ein Schlsselbund", "", 0);
  r=erzeuge_benutzung(1530, 0, POS_RAUM, "Erst mal aufheben."); {
    r->add_trigger(CMD_UNTERSUCHE, 1530, -1);
  }
  erzeuge_benutzung(1530, 0, POS_INVENTAR, "Zeig mir die Tr, ich schliee sie auf.");
  erzeuge_untersuchung(1530, 0, POS_INVENTAR, "Da sind fnf Schlssel dran. Bei unserem Glck passen die auf keine Tr.");

  erzeuge_gegenstand(1540,1500,true,false,true,"terrassentr", "eine Terrassentr Sessel", "Links fhrt eine Terrassentr in den Garten.", 0);
  erzeuge_untersuchung(1540, 0, POS_EGAL, "Die Terrassentr ist gekippt.");
  erzeuge_untersuchung(1540, 1, POS_EGAL, "Die Terrassentr ist geffnet.");
  erzeuge_untersuchung(1540, 2, POS_EGAL, "Die Terrassentr ist geschlossen.");
  get_regeln()->add_regel(r=new Spielregel(this, CMD_SCHLIESSE, 1540, -1,false, true)); {
    a=new AktionBedingt(this, r, new BedingungObjektHatNichtZustand(this, 1540,2));
    a->add_aktion(new AktionObjektNeuerZustand(this, 1540, 2));
    a->add_aktion(new AktionTextausgabe(this, "Du schliet die Terrassentr."));
    a->add_aktion(new AktionObjektSetSichtbar(this, 100280, false));
    a->add_aktion(new AktionObjektSetSichtbar(this, 100290, false));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1540,2));
    a->add_aktion(new AktionTextausgabe(this, "Du hast die Terrassentr bereits geschlossen."));
  }
  r=erzeuge_oeffnen(1540, -1, "Du hast die Tr noch nicht ganz geffnet, da springt ein Kalb von einem Hund freudig ins Wohnzimmer. Als er merkt, dass du nicht das Herrchen bist, weicht die Freude einem unverdeckten Misstrauen.\nDer Hund drngt dich langsam in eine Ecke des Wohnzimmers und lsst dich nicht gehen, bis der Hausbesitzer zurck ist, der wissen will, warum der Hund noch kein Futter bekommen hat."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, 1540, 1));
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_WACH));
    r->add_aktion(new AktionSpielVerloren(this));

  }
  r=erzeuge_oeffnen(1540, -1, "Du ffnest die Tr, trittst in den Garten und siehst den Hund auf dich zutorkeln. Er wirkt sichtlich benommen, aber auch berzeugt, du knntest etwas mit seiner Verfassung zu tun haben. Er ist jedenfalls schon wieder fit genug, dich bis zum Eintreffen des Hausbesitzers in den Rosen festzusetzen."); {
    r->add_bedingung(new BedingungObjektHatNichtZustand(this, 1540, 1));
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_AUFGEWACHT));
    r->add_aktion(new AktionSpielVerloren(this));

  }
  get_regeln()->add_regel(r=new Spielregel(this, CMD_OEFFNE, 1540, -1,false, true)); {
    r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_SCHLAEFT)); // Hund schlft
    a=new AktionBedingt(this, r, new BedingungObjektHatNichtZustand(this, 1540,1));
    a->add_aktion(new AktionObjektNeuerZustand(this, 1540, 1));
    a->add_aktion(new AktionTextausgabe(this, "Du ffnest die Terrassentr."));
    a->add_aktion(new AktionObjektSetSichtbar(this, 100280, true));
    a->add_aktion(new AktionObjektSetSichtbar(this, 100290, true));
    a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1540,1));
    a->add_aktion(new AktionTextausgabe(this, "Du hast die Terrassentr bereits geffnet."));
  }





  // 16 Garten

    r=erzeuge_gehe(100290, "Du gehst zurck ins Wohnzimmer und schliet sicherheitshalber die Terrassentr. Du hast der Pharmaindustrie noch nie vertraut."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_AUFGEWACHT));
      r->add_aktion(new AktionObjektNeuerZustand(this, 1540, 2));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100280, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100290, false));
      a=new AktionBedingt(this, r, new BedingungObjektIstSichtbar(this, 1665));
      a->add_aktion(new AktionObjektSetSichtbar(this, 1665, false));
      a->add_aktion(new AktionObjektSetSichtbar(this, 1655, false));
  //    a=new AktionBedingt(this, a, new BedingungObjektHatZustand(this, CEXT::OBJ_TROCKNER,CEXT::ST_TROCKNER_TROCKNET)); // Trockner abschalten
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_TROCKNET));
      a->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_TROCKNER,CEXT::ST_TROCKNER_FERTIG));
      a->add_aktion(new AktionTextausgabe(this, "Dir fllt auf, dass du schon lnger nicht mehr nach dem Trockner gesehen hast."));
     }

    erzeuge_gegenstand(CEXT::OBJ_HUND,1600,true,false,true,"hund", "ein Hund", "", CEXT::ST_HUND_WACH);
    erzeuge_beschreibung(CEXT::OBJ_HUND, CEXT::ST_HUND_SCHLAEFT, "Links auf der Terrasse liegt ein schlafender Hund und schnarcht gelegentlich.");
    erzeuge_untersuchung(CEXT::OBJ_HUND, CEXT::ST_HUND_SCHLAEFT, POS_EGAL, "Schlafende Hunde sehen immer so friedlich aus.");
    r=erzeuge_druecken(CEXT::OBJ_HUND, CEXT::ST_HUND_SCHLAEFT, POS_EGAL, "Ich werde den Hund garantiert nicht anpacken. Bei meinem Glck stellt er sich nur schlafend."); {
      r->add_trigger(CMD_ZIEHE, CEXT::OBJ_HUND, -1);
      r->add_trigger(CMD_BENUTZE, CEXT::OBJ_HUND, -1);
    }

    erzeuge_gegenstand(1632,1600,true,false,true,"quietscheente", "eine Quietscheente", "Direkt vor dem Hund liegt eine quietschgelbe Quietscheente." );
    erzeuge_untersuchung(1632, -1, POS_EGAL, "Bei den Bissspuren ist es wohl ein bevorzugtes Spielzeug des Hundes.");
    erzeuge_benutzung(1632, -1, POS_EGAL, "Ich spiele doch nicht mit Quietscheenten. Es sei denn, ich bade.");
    r = erzeuge_nehmen(1632, -1, true, "Mutig gehst du auf den Hund zu und packst die Quietscheente in deine Tasche."); {
      r->add_bedingung(new BedingungObjektNichtInInventar(this, 1632));
      r->add_bedingung(new BedingungObjektHatNichtZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN));
      r->add_bedingung(new BedingungObjektHatZustand(this, 2, 0));
    }
    r = erzeuge_nehmen(1632, -1, false, "Vorsichtig nherst du dich dem Hund und willst die Ente greifen. Pltzlich hebt der Hund wie in Trance den Kopf und seine Nase richtet sich auf die Blutflecken an dir. Schnell ist er wieder bei Bewusstein, sieht seine Ente bedroht und bellt dich solange an, bis ihm die Nachbarn zu Hilfe eilen."); {
      r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN),
                                               new BedingungObjektHatZustand(this, 2, 1)));
      r->add_aktion(new AktionSpielVerloren(this));
    }

    erzeuge_gegenstand(1640,1600,true,false,true,"mauer", "eine Mauer", "Gleich rechts von dir verluft eine der Begrenzungsmauern." );
    erzeuge_untersuchung(1640, -1, POS_EGAL, "Die Mauer ist zu hoch, um drueber zu klettern.");
    erzeuge_benutzung(1640, -1, POS_EGAL, "Selbst wenn wir rueber kmen, vielleicht wartet dort ein Hund, der nicht schlft?");

    erzeuge_gegenstand(CEXT::OBJ_FORM_RUND,1600,true,false,true,"rundes Frmchen", "ein rundes Frmchen", "An der Grenze zwischen Terrasse und Rasen an der Mauer liegt ein rundes Frmchen.");
    erzeuge_untersuchung(CEXT::OBJ_FORM_RUND, -1, POS_EGAL, "Ein rundes Frmchen. Sieht aus wie ein Teil eines Puzzles.");
    erzeuge_benutzung(CEXT::OBJ_FORM_RUND, -1, POS_EGAL, "Ich sehe keinen Sandkasten.");
    r=erzeuge_nehmen(CEXT::OBJ_FORM_RUND, -1, false, "Du willst nach dem Frmchen greifen, als dich die Spinne attackiert. Wenigstens war es keine giftige Spinne. Nur eine betubende. Wenn du wieder wach wirst, kannst du dich beim Hausbesitzer ber mangelhafte Schdlingsbekmpfung beschweren."); {
      r->add_bedingung(new BedingungObjektIstSichtbar(this, 1655));
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r=erzeuge_nehmen(CEXT::OBJ_FORM_RUND, -1, true, "Nachdem die Spinne endlich weg ist, hebst du das Frmchen auf und packst es weg."); {
      r->add_bedingung(new BedingungObjektNichtInInventar(this, CEXT::OBJ_FORM_RUND));
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1655));
    }

    erzeuge_gegenstand(1655,1600,true,false,true,"spinne", "eine Spinne", "Auf dem Frmchen sitzt eine Gartenspinne." );
    erzeuge_untersuchung(1655, -1, POS_EGAL, "Ein schwarze, behaarte Spinne mit einfach zu vielen Augen. Ich will nicht sagen, sie ist riesig, aber auf ein 50 cent Stck passt sie locker.");
    r=erzeuge_benutzung(1655, -1, POS_EGAL, "Bevor du sie mit dem Finger berhren kannst, springst sie dich an und beit dir in den Finger. Du fhlst, wie du langsam wegdmmerst und dann von der feuchten Schnauze des Hundes geweckt wirst. Er erklrt sich bereit, auf dich aufzupassen, bis der Hausbesitzer da ist."); {
      r->add_trigger(CMD_DRUECKE, 1655, -1);
      r->add_trigger(CMD_ZIEHE, 1655, -1);
      r->add_aktion(new AktionSpielVerloren(this));
    }
    erzeuge_nehmen(1655, -1, false, "Diese Krawallspinne willst du doch nicht ernsthaft in deiner Tasche haben.");
    r=erzeuge_kombination(906, 1655, -1, -1, POS_EGAL, POS_EGAL, "Du bietest der Spinne etwas Marmelade an. Sie begngt sich mit deinem Finger. Die Konsequenz: Ohnmacht, bis der Hausbesitzer kommt." ); {
      r->add_aktion(new AktionSpielVerloren(this));
    }
    erzeuge_kombination(CEXT::OBJ_ZANGE, 1655, -1, -1, POS_EGAL, POS_EGAL, "Du versuchst, die Spinne mit der Zange zu erwischen, aber sie springt schneller weg, als du \"Przisionswerkzeug\" sagen kannst." );
    r=erzeuge_kombination(540, 1655, -1, -1, POS_EGAL, POS_EGAL, "Du zielst mit dem Haargummi nach ihr. Aber du verfehlst sie. Das Haargummi findest du auch nicht mehr wieder." ); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 540, false));
    }
    r=erzeuge_kombination(1, 1655, -1, -1, POS_EGAL, POS_EGAL, "Du glaubst doch nicht ernsthaft, sie bleibt auf dem Papier sitzen..." ); {
      r->add_trigger(CMD_KOMBINIERE, 18, 1655);
    }

    erzeuge_gegenstand(1660,1600,true,false,true,"sandhaufen", "ein Sandhaufen", "Etwas weiter die Mauer entlang fllt dir ein kleiner Sandhaufen auf.",0 );
    erzeuge_untersuchung(1660, 0, POS_EGAL, "Bei genauerer Betrachtung erkennst du oben auf dem Haufen ein Loch, in das Ameisen ein- und ausgehen.");
    erzeuge_untersuchung(1660, 1, POS_EGAL, "Das Loch des Ameisenbaus ist nun geschlossen. Es kommen keine Ameisen mehr heraus und die vereinzelt drauen herumlaufenden kommen nicht mehr hinein.");
    r=erzeuge_benutzung(1660, 1, POS_EGAL, "Ich glaube, die Ameisen haben deinen Standpunkt begriffen."); {
      r->add_trigger(CMD_DRUECKE, 1660, -1);
      r->add_trigger(CMD_ZIEHE, 1660, -1);
      r->add_aktion(new AktionObjektNeuerZustand(this, 1660, 1));
    }
    r=erzeuge_benutzung(1660, 0, POS_EGAL, "Du bewegst den Sand des Haufens hin und her, bis das Loch geschlossen ist."); {
      r->add_trigger(CMD_DRUECKE, 1660, -1);
      r->add_trigger(CMD_ZIEHE, 1660, -1);
      r->add_aktion(new AktionObjektNeuerZustand(this, 1660, 1));
    }
    erzeuge_kombination(906, 1660, -1, 1, POS_EGAL, POS_EGAL, "Da laufen kaum noch Ameisen rum." );
    r=erzeuge_kombination(906, 1660, -1, 0, POS_EGAL, POS_EGAL, "Noch mehr Marmelade und die Ameisen sind an Diabetes gestorben, bevor sie die Spinne erreicht haben." ); {
      r->add_bedingung(new BedingungObjektIstSichtbar(this, 1665));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1665, true));
    }
    r=erzeuge_kombination(906, 1660, -1, 0, POS_EGAL, POS_EGAL, "Du ziehst eine dnne Spur aus Marmelade vom Sandhaufen zur Spinne." ); {
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1665));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1665, true));
    }

    erzeuge_gegenstand(1665,1600,true,false,false,"marmeladenspur", "eine Marmeladenspur", "Vom Sandhaufen zur Spinne fhrt eine sehr dnne Spur aus Marmelade.",0);
    erzeuge_untersuchung(1665, 0, POS_EGAL, "Wenn die Ameisen nicht vllig aus der Art geschlagen sind, sollten sie der Zuckerspur folgen und schlielich die Spinne vertreiben. Gibt es eigentlich ameisenfressende Spinnen?");

    erzeuge_gegenstand(1670,1600,true,false,true,"gartenhaus", "ein Gartenhaus", "Fast am Ende des Gartens steht ein kleines Gartenhaus.",ST_TUER_VERSCHLOSSEN);
    erzeuge_untersuchung(1670, -1, POS_EGAL, "Ein einfaches Gartenhaus ohne Fenster und mit einer Tr. Das Flachdach ist etwa zwei Meter hoch und grenzt direkt an die Mauer.");
    erzeuge_oeffnen(1670, ST_TUER_VERSCHLOSSEN, "Die Tr des Gartenhauses ist verschlossen.");
    r=erzeuge_oeffnen(1670, ST_TUER_GESCHLOSSEN, "Du ffnest das Gartenhaus."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 1670, ST_TUER_OFFEN));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100300, true));
    }
    r=erzeuge_kombination(2245, 1670, -1, ST_TUER_VERSCHLOSSEN, POS_EGAL, POS_EGAL, "Du schliet das Schloss der Gartenhaustr auf." ); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 1670, ST_TUER_GESCHLOSSEN));
    }
    r=erzeuge_gehe(100300, "Du betrittst das Gartenhaus und schliet hinter dir die Tr. Kann nicht schaden." ); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 1670, ST_TUER_GESCHLOSSEN));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100300, false));
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_AUFGEWACHT));
    }






  // 17 Gartenhaus

    erzeuge_gegenstand(1700,1700,true,false,true,"tr", "eine Tr", "Hinter dir fhrt eine Tr in den Garten.", 0);
    r=erzeuge_oeffnen(1700, 1, "Nachdem du die Tr ein zweites Mal ffnest, steht der Hund bereits davor, drngt dich weiter ins Gartenhaus und hlt dich dort in Schach, bis sein Herrchen nach Hause kommt."); {
      r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_AUFGEWACHT));
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r=erzeuge_oeffnen(1700, 0, "Du ffnest die Tr in den Garten, da siehst du, wie der Hund langsam aufsteht. Du berlegst, ob du es noch bis ins Haus schaffst, entscheidest dich dann aber dafr, die Tr des Gartenhauses wieder zu schlieen."); {
      r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_AUFGEWACHT));
      r->add_aktion(new AktionObjektNeuerZustand(this, 1700, 1));
    }

    erzeuge_gegenstand(1705,1700,true,false,true,"schlsselbrett", "ein Schlsselbrett", "Neben der Tr ist ein Schlsselbrett an die Wand geschraubt.", 0);
    r=erzeuge_untersuchung(1705, 0, POS_EGAL, "An dem Brett hngt nur ein einziger Schlssel. Auf seinem Schild steht \"Haustrschlssel\". Wir haben es tatschlich geschafft."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 1705, 1));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1706, true));
    }

    erzeuge_gegenstand(1706,1700,false,false,false,"haustrschlssel", "der Haustrschlssel", "Am Schlsselbrett hngt der lang gesuchte Schlssel zur Haustr.");
    erzeuge_untersuchung(1706, -1, POS_EGAL, "Die ganze Arbeit nur wegen dieses Schlssels.");
    erzeuge_benutzung(1706, -1, POS_EGAL, "Dazu mssen wir wohl wieder zur Haustr zurck.");
    r=erzeuge_nehmen(1706, -1, true, "Mit einem ergriffenen Seufzen packst du den Schlssel in die Tasche."); {
      r->add_bedingung(new BedingungObjektNichtInInventar(this, 1706));
    }

    erzeuge_gegenstand(1710,1700,true,false,true,"luke", "eine Luke", "Oben an der Decke fhrt eine Luke auf das Dach.", 0);
    erzeuge_untersuchung(1710, -1, POS_EGAL, "Eine Luke, die einfach zu ffnen ist, wenn man sie erreichen kann.");
    r=erzeuge_benutzung(1710, -1, POS_EGAL, "An die Luke kommst du so nicht ran."); {
      r->add_trigger(CMD_OEFFNE, 1710, -1);
      r->add_trigger(CMD_BENUTZE, 1710, -1);
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1715));
    }
    r=erzeuge_benutzung(1710, -1, POS_EGAL, "Du steigst durch die Luke auf das Dach des Gartenhauses."); {
      r->add_trigger(CMD_OEFFNE, 1710, -1);
      r->add_trigger(CMD_BENUTZE, 1715, -1);
      r->add_bedingung(new BedingungObjektIstSichtbar(this, 1715));
      r->add_aktion(new AktionRaumwechsel(this, 2700));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100420, true));
    }

    erzeuge_gegenstand(1715,1700,true,false,false,"leiter", "eine Leiter", "Unter der Luke steht eine Leiter.");
    erzeuge_untersuchung(1715, -1, POS_EGAL, "ber die Leiter kommst du an die Luke.");
    r=erzeuge_kombination(808, 1710,-1, -1, POS_EGAL, POS_EGAL, " Auf die rutschige lpftze kann ich die Leiter nicht stellen. Und daneben ist sie zu weit weg von der Luke."); {
      r->add_bedingung(new BedingungObjektIstSichtbar(this, 1720));
    }
    r=erzeuge_kombination(808, 1710,-1, -1, POS_EGAL, POS_EGAL, " Du stellst die Leiter unter die Luke."); {
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1720));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1715, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, 808, false));
    }
    r = erzeuge_nehmen(1715, -1, false, "Du packst die Leiter wieder ein."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 1715, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, 808, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100420, false));
    }

    erzeuge_gegenstand(1720,1700,true,false,true,"lache", "eine lache", "Auf dem Boden unter der Luke hat sich eine Lache aus l und Wasser gebildet.");
    erzeuge_untersuchung(1720, -1, POS_EGAL, "Darauf knnen wir keine Leiter stellen. Das mssen wir irgendwie wegwischen.");
    erzeuge_kombination(CEXT::OBJ_HANDTUCH, 1720,CEXT::ST_HANDTUCH_NASS, -1, POS_EGAL, POS_EGAL, "Mit dem nassen Handtuch verteilst du das Geschmiere nur noch besser.");
    r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 1720,CEXT::ST_HANDTUCH_SAUBER, -1, POS_EGAL, POS_EGAL, "Du wischst das l soweit es geht mit dem Handtuch auf."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_HANDTUCH, CEXT::ST_HANDTUCH_DRECKIG));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1720, false));
    }




  // 18 Sicherungskasten

    erzeuge_gegenstand(1800,1800,true,false,true,"sicherungskasten", "ein Sicherungskasten", "Hier wurde auch schon lnger nicht mehr sauber gemacht. Eine Menge Staub hat sich auf dem Boden angesammelt.", 0);
    erzeuge_benutzung(1800, -1, POS_EGAL, "Wir benutzen ihn gerade in diesem Moment.");
    r = erzeuge_schliessen(1800, -1, "Du schliet den Kasten wieder und gehst einen Schritt zurck."); {
      r->add_aktion(new AktionRaumwechsel(this,800));
      a=new AktionBedingt(this, r, new BedingungObjektInInventar(this, 1820));
      a->add_bedingung(new BedingungObjektIstSichtbar(this, 1820));
      a->add_aktion(new AktionObjektNeuePos(this, 1820, 1800));
      a->add_aktion(new AktionTextausgabe(this, "Der Ordnung halber legst du den Notizzettel vorher wieder zurck."));
    }
    erzeuge_untersuchung(1800, 1, POS_EGAL, "Mehr ist nicht zu finden.");
    r=erzeuge_untersuchung(1800, 0, POS_EGAL, "Unter dem ganzen Dreck und Staub liegt ein kleiner Notizzettel."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 1820, true));
      r->add_aktion(new AktionObjektNeuerZustand(this, 1800, 1));
    }

    erzeuge_gegenstand(1805,1800,true,false,true,"schalttafel", "eine Schalttafel", "Mitten in diesem groen Kasten hngt verloren eine kleine Schalttafel mit drei Schaltern.",0);
    erzeuge_benutzung(1805, 0, POS_EGAL, "Ich werde jetzt nicht wild an den Schaltern rumspielen.");
    erzeuge_benutzung(1805, 1, POS_EGAL, "Jetzt, wo du die Schalterbelegung kennst, solltest du die Schalter direkt bedienen.");
    erzeuge_untersuchung(1805, 0, POS_RAUM, "Es ist nirgendwo zu erkennen, wozu die Schalter gut sind.");
    erzeuge_untersuchung(1805, 1, POS_RAUM, "Am besten, wir bedienen die Sicherungen direkt.");

    erzeuge_gegenstand(1810,1800,true,false,false,"KG-Sicherung", "die KG-Sicherung", "Links ist die Sicherung fr das Kellergeschoss angebracht.",0);
    erzeuge_untersuchung(1810, -1, POS_RAUM, "Mit dieser Sicherung wird der Strom im gesamten Keller ein- und ausgeschaltet.");
    r=erzeuge_druecken(1810, -1, POS_EGAL, "Du schaltest den Strom im Keller aus. Schlagartig wird es dunkel und du kannst die Hand nicht mehr vor den Augen sehen. Du gertst in Panik, drehst dich hastig um und stt mit dem Kopf gegen die Kante der Treppe.\nZum Glck wusste der Hausbesitzer, wie man in der Dunkelheit die Sicherung wieder einschaltet."); {
      r->add_trigger(CMD_BENUTZE, 1810, -1);
      r->add_aktion(new AktionSpielVerloren(this));
    }

    erzeuge_gegenstand(1812,1800,true,false,false,"Kchensicherung", "die Kchensicherung", "Der Schalter daneben ist fr die Kche.",0);
    erzeuge_untersuchung(1812, -1, POS_RAUM, "Mit dieser Sicherung wird der Strom in der Kche ein- und ausgeschaltet.");
    get_regeln()->add_regel(r=new Spielregel(this, CMD_DRUECKE, 1812, -1,false, true)); {
      r->add_trigger(CMD_BENUTZE, 1812, -1);
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1812,0));
      a->add_aktion(new AktionObjektNeuerZustand(this, 1812, 1));
      a->add_aktion(new AktionTextausgabe(this, "Du schaltest den Strom in der Kche ab."));
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1812,1));
      a->add_aktion(new AktionObjektNeuerZustand(this, 1812, 0));
      a->add_aktion(new AktionTextausgabe(this, "Du schaltest den Strom in der Kche wieder ein."));
    }
    r = erzeuge_kombination(CEXT::OBJ_ZANGE, 1812, -1, -1, POS_EGAL, POS_EGAL, "Man kann Schalter auch mit einem Finger bedienen."); {
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_ZANGE, 1810);
    }


    erzeuge_gegenstand(CEXT::OBJ_FUSE,1800,true,false,false,"Haussicherung", "die Haussicherung", "Ganz rechts lsst sich der Strom des restlichen Hauses ein- und ausschalten.",CEXT::ST_FUSE_ORG);
    erzeuge_untersuchung(CEXT::OBJ_FUSE, CEXT::ST_FUSE_REPARIERT, POS_RAUM, "Das sieht doch gut aus. Auch wenn jetzt keine Sicherung mehr verbaut ist, haben wir wenigstens Strom.");
    erzeuge_untersuchung(CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS, POS_RAUM, "Solange das hier nicht repariert ist, haben die meisten Rume im Haus keinen Strom.");
    erzeuge_untersuchung(CEXT::OBJ_FUSE, CEXT::ST_FUSE_ORG, POS_RAUM, "Mit dieser Sicherung wird der Strom im gesamten Haus, auer Kche und Keller, ein- und ausgeschaltet.");
    r=erzeuge_druecken(CEXT::OBJ_FUSE, CEXT::ST_FUSE_REPARIERT, POS_EGAL, "Der Mechanismus steht immer noch unter Strom, gerade weil das Haus jetzt wieder welchen hat. Aber du kannst die Finger ja nicht davon lassen."); {
      r->add_trigger(CMD_BENUTZE, CEXT::OBJ_FUSE, -1);
      r->add_trigger(CMD_DRUECKE, 1816, -1);
      r->add_trigger(CMD_BENUTZE, 1816, -1);
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r=erzeuge_druecken(CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS, POS_EGAL, "Du drckst mit dem Finger dort hin, wo vorher der Schalter war. Zuerst denkst du \"Lustiges Gefhl\". Dann denkst du \"Mist, 230 Volt\".\nDas nicht genug, stellt dir der Hausbesitzer spter die Sicherung in Rechnung."); {
      r->add_trigger(CMD_BENUTZE, CEXT::OBJ_FUSE, -1);
      r->add_bedingung(new BedingungObjektIstSichtbar(this, 1816));
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r=erzeuge_druecken(CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS, POS_EGAL, "Du versuchst, die Sicherung wieder reinzudrcken, aber der Schalter findet keinen Halt und schnappt immer wieder in die AUS-Position zurck."); {
      r->add_trigger(CMD_BENUTZE, CEXT::OBJ_FUSE, -1);
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1816));
    }
    r=erzeuge_druecken(CEXT::OBJ_FUSE, CEXT::ST_FUSE_ORG, POS_EGAL, "Du schaltest den Strom im Haus aus. Der Schalter macht dabei ein ungesundes Gerusch."); {
      r->add_trigger(CMD_BENUTZE, CEXT::OBJ_FUSE, -1);
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
    }
    r=erzeuge_ziehen(CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS, POS_EGAL, "Willst du das Ding etwa auseinander reien? Na gut. Du ziehst am Schalter, aber rutschst immer wieder ab. So gibt das nichts."); {
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1816));
    }
    erzeuge_ziehen(CEXT::OBJ_FUSE, CEXT::ST_FUSE_ORG, POS_EGAL, "Also ich bettige Schalter meistens uber Drcken...");
    r = erzeuge_kombination(CEXT::OBJ_ZANGE, CEXT::OBJ_FUSE, -1, CEXT::ST_FUSE_AUS, POS_EGAL, POS_EGAL, "Du versuchst, die Metallteile zurecht zu biegen. Dummerweise ist eine Seite stromfhrend. Und das war leider nicht zielfhrend. Wie der Hausbesitzer besttigte, als er dich mit deiner neuen Frisur auf den Fliesen fand."); {
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_ZANGE, 1816);
      r->add_bedingung(new BedingungObjektIstSichtbar(this, 1816));
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r = erzeuge_kombination(CEXT::OBJ_ZANGE, CEXT::OBJ_FUSE, -1, CEXT::ST_FUSE_REPARIERT, POS_EGAL, POS_EGAL, "Du kannst es nicht lassen, oder? Vielleicht solltest du dir zum Geburtstag ein Reizstromgert wnschen."); {
      r->add_trigger(CMD_KOMBINIERE,CEXT::OBJ_ZANGE,1816);
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r = erzeuge_kombination(CEXT::OBJ_ZANGE, CEXT::OBJ_FUSE, -1, CEXT::ST_FUSE_AUS, POS_EGAL, POS_EGAL, "Du ziehst mit der Zange krftig am Schalter, bis er aus der Verankerung reit."); {
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 1816));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1816, true));
    }
    r = erzeuge_kombination(CEXT::OBJ_ZANGE, CEXT::OBJ_FUSE, -1, CEXT::ST_FUSE_ORG, POS_EGAL, POS_EGAL, "Man kann Schalter auch mit einem Finger bedienen.");

    erzeuge_gegenstand(1816,1800,true,false,false,"Schaltmechanismus", "ein Schaltmechanismus", "Dort, wo vorher der Schalter war, ist nun der Blick frei auf den Schaltmechanismus.",0);
    erzeuge_untersuchung(1816, 1, POS_RAUM, "Mit der Metallstange zwischen den Klammern fliet wieder Strom im Haus.");
    erzeuge_untersuchung(1816, 0, POS_RAUM, "Der Mechanismus besteht aus zwei Metallklammern, die der Schalter beim Einschalten mit einer Sicherung verbunden hatte.");
    r=erzeuge_druecken(1816, 0, POS_EGAL, "Du versuchst, die Metallklammern so zu verbiegen, dass sie sich berhren und fungierst dabei fr einen Moment selbst als Sicherung. Das allerdings schaltet dir den Strom ab. Wenigstens hast du eine spannende Geschichte, die du dem Hausbesitzer erzhlen kannst."); {
      r->add_trigger(CMD_BENUTZE, 1816, -1);
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r = erzeuge_kombination(20, 1816, -1, 0, POS_EGAL, POS_EGAL, "Der Schlssel ist zu lang und der Bart ist im Weg.");
    r = erzeuge_kombination(17, 1816, -1, 0, POS_EGAL, POS_EGAL, "Die Schraube ist zu kurz.");
    r = erzeuge_kombination(225, 1816, -1, 0, POS_EGAL, POS_EGAL, "Durch das Ende mit dem Dbel wrde kein Strom flieen.");
    r = erzeuge_kombination(16, 1816, -1, 0, POS_EGAL, POS_EGAL, "Etwas nicht leitendes als Leiter verwenden? Komm, das kannst du besser."); {
      r->add_trigger(CMD_KOMBINIERE, 1131, 1816);
      r->add_trigger(CMD_KOMBINIERE, 1132, 1816);
      r->add_trigger(CMD_KOMBINIERE, 1133, 1816);
      r->add_trigger(CMD_KOMBINIERE, 1134, 1816);
      r->add_trigger(CMD_KOMBINIERE, 1135, 1816);
      r->add_trigger(CMD_KOMBINIERE, 1136, 1816);
    }
    r = erzeuge_kombination(21, 1816, 3, 0, POS_EGAL, POS_EGAL, "Dann httest du die Metallstange auch komplett ohne Dbel anfassen knnen. Bestell dem Hausbesitzer einen schnen Gru."); {
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r = erzeuge_kombination(21, 1816, 2, 0, POS_EGAL, POS_EGAL, "Du hltst die Metallstange vorsichtig am isolierenden Plastik und verwendest sie als Verbindung zwischen den beiden Klammern. Bingo, das Haus hat wieder Strom."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_REPARIERT));
      r->add_aktion(new AktionObjektNeuerZustand(this, 1816, 1));
      r->add_aktion(new AktionObjektSetSichtbar(this, 21, false));
      a= new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 1920,1)); {
        a->add_aktion(new AktionTextausgabe(this, "Du hrst einen Knall. Kurz darauf ohrenbetubendes Piepen. Scheint so, als htte das von dir durchgeschnittene Lampenkabel einen Kurzschluss verursacht und die Rauchmelder ausgelst.\nDummerweise sind das diese neuen, die direkt eine SMS an die Feuerwehr senden. Und an den Hausbesitzer."));
        a->add_aktion(new AktionSpielVerloren(this));
      }
    }
    r = erzeuge_kombination(21, 1816, 1, 0, POS_EGAL, POS_EGAL, "Ein guter Versuch, aber du hast dir einen Dbel noch nie richtig angesehen, oder? Die haben Lcher, besonders die gebrauchten. Die Konsequenz daraus bietet dir ein spannungsreiches Erlebnis. Und damit meine ich nicht den Hausbesitzer."); {
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r = erzeuge_kombination(21, 1816, 0, 0, POS_EGAL, POS_EGAL, "Du drckst die Metallstange in die Klammern. Auf den ersten Blick eine gute Idee, weil Metall Strom leitet. Aber dann doch wieder nicht, weil du das Metall dabei festhltst.\nIch bin gespannt, wie du dem Hausbesitzer erklrst, wieso sein abgesgter Esszimmerzimmerschlssel in seiner zerstrten Haussicherung steckt."); {
      r->add_aktion(new AktionSpielVerloren(this));
    }
    erzeuge_kombination(23, 1816, 0, 0, POS_EGAL, POS_EGAL, "Die Kabel sind isoliert, damit man sie anfassen kann, ohne eine gewischt zu bekommen. Warum willst du ein isoliertes Kabel als Leiter verwenden?");
    r = erzeuge_kombination(23, 1816, 1, 0, POS_EGAL, POS_EGAL, "Du versuchst, die abisolierten Enden um die Klammern zu zwirbeln, vergisst aber, dass eine Seite unter Strom steht.\nDas machst du extra, oder?"); {
      r->add_aktion(new AktionSpielVerloren(this));
    }


    erzeuge_gegenstand(1820,1800,false,false,false,"notizzettel", "ein Notizzettel", "Aus dem Staub ragt die Ecke eines Notizzettels.", 0);
    erzeuge_benutzung(1820, -1, POS_EGAL, "Du spielst gerne mit Zetteln, oder?");
    erzeuge_untersuchung(1820, -1, POS_RAUM, "Die Schrift ist zu klein, um sie von hier lesen zu knnen.");
    r=erzeuge_untersuchung(1820, -1, POS_INVENTAR, "Auf dem Zettel ist die Schalterbelegung erklrt.\nDemnach sind es die Sicherungen fr den Keller, fr die Kche und fr den Rest des Hauses."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 1805, 1));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1810, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1812, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FUSE, true));
    }


    // 19 Lampengehuse

    r = erzeuge_kombination(1515, 24, -1, -1, POS_EGAL, POS_EGAL, "Du schraubst das Lampengehuse wieder fest."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 24, false));
      r->add_aktion(new AktionRaumwechsel(this, 100));
    }

    erzeuge_gegenstand(1910,1900,true,false,true,"lampenhalterung", "eine Lampenhalterung", "Die Lampenhalterung ist fest an die Decke geschraubt.", 0);
    erzeuge_untersuchung(1910, -1, POS_RAUM, "Die Lampenhalterung ist an die Decke geschraubt, damit daran das Lampengehuse fest gemacht werden kann.");
    erzeuge_kombination(1515, 1910, -1, -1, POS_EGAL, POS_EGAL, "Wir wollen die Lampe nicht komplett demontieren.");

    erzeuge_gegenstand(1920,1900,true,false,true,"kabel", "ein Kabel", "Aus der Decke fhrt ein Kabel zur Lampenfassung.", 0);
    erzeuge_untersuchung(1920, 1, POS_RAUM, "Das Kabel ist durchgetrennt.");
    erzeuge_untersuchung(1920, 0, POS_RAUM, "Das Kabel dient wohl der Stromversorgung der Lampe.");
    erzeuge_kombination(CEXT::OBJ_ZANGE, 1920, -1, 1, POS_EGAL, POS_EGAL, "Du hast das Kabel bereits durchgetrennt.");
    r = erzeuge_kombination(CEXT::OBJ_ZANGE, 1920, -1, 0, POS_EGAL, POS_EGAL, "Du trennst das Kabel mit der Zange durch. Diese entpuppt sich als guter Stromleiter. Du wiederum entpuppst dich als schlechter Widerstand und fllst um.\nNachdem der Hausbesitzer Mhe hatte, die Haustr aufzubekommen, weil du davor lagst, kannst du nun die ganze Geschichte erzhlen."); {
      r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r = erzeuge_kombination(CEXT::OBJ_ZANGE, 1920, -1, 0, POS_EGAL, POS_EGAL, "Du trennst das Kabel mit der Zange durch."); {
      r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
      r->add_aktion(new AktionObjektNeuerZustand(this, 1920, 1));
    }

    erzeuge_gegenstand(1930,1900,true,false,true,"Kerzenbirne", "eine Kerzenbirne", "In der Fassung sitzt eine alte Kerzenbirne.", 0);
    r = erzeuge_untersuchung(1930, -1, POS_RAUM, "Die Lampe leuchtet hell und hei."); {
      r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
    }
    r = erzeuge_untersuchung(1930, -1, POS_RAUM, "Die Lampe ist aus."); {
      r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
    }
    r = erzeuge_nehmen(1930, -1, false, "Du willst die Birne aus der Fassung drehen, packst sie an, sprst die sengende Hitze an deinen Fingern und beginnst so laut zu schreien, dass die Nachbarn an die Tr klopfen und dann den Hausbesitzer rufen."); {
      r->add_bedingung(new BedingungObjektHatNichtZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r = erzeuge_nehmen(1930, -1, false, "Du drehst die Birne aus der Fassung und packst sie ein."); {
      r->add_bedingung(new BedingungObjektHatZustand(this, CEXT::OBJ_FUSE, CEXT::ST_FUSE_AUS));
      r->add_aktion(new AktionObjektNeuePos(this, 1930, 0));
    }




    // 20 Bad

    erzeuge_gegenstand(2010,2000,true,false,true,"badewanne", "eine Badewanne", "Auf der kompletten linken Seite ist eine groe Badewanne mit Fen platziert.", 0);
    erzeuge_untersuchung(2010, -1, POS_EGAL, "Optimal zum Entspannen, so ein heies Bad.");
    erzeuge_benutzung(2010, -1, POS_EGAL, "Du willst jetzt baden? Dann los, ich freue mich schon, wie du das dem Hausbesitzer erklrst.");

    erzeuge_gegenstand(2015,2000,true,false,true,"toilette", "eine Toilette", "Hinten rechts steht die Toilette.", 0);
    erzeuge_untersuchung(2015, -1, POS_EGAL, "Ich bin mir sicher, du weit, was man damit macht.");
    erzeuge_benutzung(2015, -1, POS_EGAL, "Wir sind hier Gste, also besitzen wir auch den Anstand und gehen auf das Gsteklo.");
    erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2015,-1, -1, POS_EGAL, POS_EGAL, "Wir sollten diese Toilette nicht benutzen.");

    erzeuge_gegenstand(2020,2000,true,false,true,"wasserhahn", "ein Wasserhahn", "Daneben ist das Waschbecken montiert, mit einem schnen Chromwasserhahn.", 0);
    erzeuge_untersuchung(2020, -1, POS_EGAL, "Nach meiner Erfahrung kommt da Wasser raus.");
    erzeuge_benutzung(2020, -1, POS_EGAL, "Hnde waschen ist nie verkehrt, auch wenn man nicht auf Toilette war.");
    erzeuge_kombination(CEXT::OBJ_HANDTUCH, 2020, CEXT::ST_HANDTUCH_NASS, -1, POS_EGAL, POS_EGAL, "Noch nasser geht wirklich nicht.");
    r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 2020, CEXT::ST_HANDTUCH_SAUBER, -1, POS_EGAL, POS_EGAL, "Du hltst das Handtuch unter den Hahn, bis es tropfnass ist. Zum Glck hast du eine Plastiktte dabei."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_HANDTUCH, CEXT::ST_HANDTUCH_NASS));
    }
    erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2020, CEXT::ST_SEIFE_ORG, -1, POS_EGAL, POS_EGAL, "Der Seifenspender ist zugeschraubt, da bekomme ich nichts rein.");
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2020, -1 , -1, POS_EGAL, POS_EGAL, "In den Seifenspender passt nichts mehr rein."); {
      r->add_bedingung(b = new BedingungOder(this));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_SEIFE)));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_VOLLWASCHMITTEL)));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_VOLLWASSER)));
    }
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2020, CEXT::ST_SEIFE_WASSER, -1, POS_EGAL, POS_EGAL, "Du fllst den Seifenspender randvoll mit Wasser."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_VOLLWASSER));
    }
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2020, CEXT::ST_SEIFE_LEER, -1, POS_EGAL, POS_EGAL, "Du fllst den Seifenspender zur Hlfte mit Wasser."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_WASSER));
    }
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2020, CEXT::ST_SEIFE_WASCHMITTEL, -1, POS_EGAL, POS_EGAL, "Du lsst Wasser auf das Waschmittel laufen, bis du eine schmierige Seife erhltst."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_SEIFE));
    }
    r=erzeuge_kombination(CEXT::OBJ_FORM_DREIECK, 2020,-1, -1, POS_EGAL, POS_EGAL, "Du lsst Wasser in das Frmchen laufen, drehst es um und siehst erstaunt zu, wie es wieder raus luft."); {
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FORM_QUADRAT, 2020);
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FORM_RUND, 2020);
    }
    erzeuge_kombination(906, 2020, -1, -1, POS_EGAL, POS_EGAL, "Du willst die Marmelade strecken ohhne zu wissen, wie sie schmeckt?");

    erzeuge_gegenstand(2030,2000,true,false,true,"spiegelschrank", "ein Spiegelschrank", "ber dem Waschbecken hngt ein Spiegelschrank.", 0);
    erzeuge_untersuchung(2030, 1, POS_RAUM, "Sonst liegt nichts mehr im Schrank.");
    r = erzeuge_untersuchung(2030, 0, POS_RAUM, "Im Schrank liegt ein dreieckiges Frmchen."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FORM_DREIECK, true));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2030, 1));
    }
    erzeuge_benutzung(2030, -1, POS_EGAL, "Du hast es mit Spiegeln, oder?");

    erzeuge_gegenstand(CEXT::OBJ_FORM_DREIECK,2000,false,false,false,"dreieckiges Frmchen", "ein dreieckiges Frmchen", "");
    erzeuge_untersuchung(CEXT::OBJ_FORM_DREIECK, -1, POS_EGAL, "Ein dreieckiges Frmchen. Sieht aus wie ein Teil eines Puzzles.");
    erzeuge_benutzung(CEXT::OBJ_FORM_DREIECK, -1, POS_EGAL, "Ich sehe keinen Sandkasten.");





  // 21 Schlafzimmer

    erzeuge_gegenstand(2105,2100,true,false,true,"schiebetr", "eine Schiebetr", "", ST_TUER_VERSCHLOSSEN);
    r=erzeuge_oeffnen(2105, -1, "Das weit du doch mittlerweile."); {
      r->add_trigger(CMD_SCHLIESSE, 2105, -1);
      r->add_trigger(CMD_DRUECKE, 2105, -1);
      r->add_trigger(CMD_ZIEHE, 2105, -1);
      r->add_trigger(CMD_UNTERSUCHE, 2105, -1);
    }

    erzeuge_gegenstand(2110,2100,true,false,true,"schalter", "ein Schalter", "Hinter dir befindet sich die Schiebetr mit dem Schalter.", 0);
    erzeuge_untersuchung(2110, -1, POS_EGAL, "Genau wie im Flur auch, wir erinnern uns?");
    r=erzeuge_druecken(2110, -1, POS_EGAL, "Die Tr ist bereits offen."); {
      r->add_bedingung(new BedingungObjektHatZustand(this, 2105,ST_TUER_OFFEN));

    }
    get_regeln()->add_regel(r=new Spielregel(this, CMD_DRUECKE, 2110, -1)); {
      r->add_bedingung(new BedingungObjektHatZustand(this, 2105,ST_TUER_VERSCHLOSSEN));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2105, ST_TUER_OFFEN));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100340, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100350, true));
      r->add_aktion(new AktionTextausgabe(this, "Du drckst den Schalter und mit einem Summen fhrt die Schiebetr auf."));
    }
    r = erzeuge_gehe(100350, "Du verlsst das Schlafzimmer. Hinter dir fhrt die Schiebetr wieder zu."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 2105, ST_TUER_VERSCHLOSSEN));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100340, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100350, false));
    }

    erzeuge_gegenstand(2130,2100,true,false,true,"bett", "ein Bett", "An der Wand vor dir steht mittig ein etwa 2 Meter breites Doppelbett mit dunkelroten Bezgen.", 0);
    erzeuge_untersuchung(2130, -1, POS_EGAL, "Ein klassisches Ehebett mit ebenso klassischer Tagesdecke am Fuende.");
    erzeuge_benutzung(2130, -1, POS_EGAL, "Wenn es diesen Haus an einem nicht mangelt, dann an Schlafgelegenheiten.");

    erzeuge_gegenstand(2140,2100,true,false,true,"nachtschrank", "ein Nachtschrank", "Links daneben steht auch noch ein kleines Nachtschrnkchen mit derselben Hhe wie das Bett.", 0);
    r=erzeuge_untersuchung(2140, 0, POS_EGAL, "Das Nachtschrnkchen ist mit einem kleinen, in die Schubladenfront eingelassenen Plastikschloss gesichert."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 2142, true));
    }
    erzeuge_untersuchung(2140, 1, POS_EGAL, "Mit dem geschmolzenen Schloss sollte das Nachtschrnkchen leicht zu ffnen sein.");
    erzeuge_oeffnen(2140, 0, "Das Nachtschrnkchen ist verschlossen.");
    r=erzeuge_oeffnen(2140, 1, "Du ffnest das Nachtschrnkchen und schaust hinein."); {
      r->add_aktion(new AktionRaumwechsel(this, 2500));
    }

    erzeuge_gegenstand(2142,2100,true,false,false,"plastikschloss", "ein Plastikschloss", "", 0);
    erzeuge_untersuchung(2142, 0, POS_EGAL, "Dieses Plastikschloss hlt den Nachtschrank verschlossen.");
    erzeuge_untersuchung(2142, 1, POS_EGAL, "In das Plastikschloss wurde eine Schraube zur Hlfte reingedreht.");
    erzeuge_untersuchung(2142, 2, POS_EGAL, "In das Plastikschloss wurde eine Schraube fast bis zum Anschlag reingedreht.");
    erzeuge_untersuchung(2142, 3, POS_EGAL, "Das Plastikschloss ist komplett geschmolzen.");
    r=erzeuge_kombination(17, 2142, -1, -1, POS_EGAL, POS_EGAL, "Du drehst die Schraube mit den Hnden soweit es geht in das Schloss."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 2144, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, 17, false));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2142, 1));
    }

    erzeuge_gegenstand(2144,2100,true,false,false,"metallschraube", "eine Metallschraube", "", 0);
    r=erzeuge_nehmen(2144, -1, false, "Wir ziehen sie jetzt nicht wieder raus!"); {
      r->add_trigger(CMD_ZIEHE, 2144, -1);
      r->add_trigger(CMD_BENUTZE, 2144, -1);
    }
    erzeuge_untersuchung(2144, 0, POS_EGAL, "Die Schraube steckt zur Hlfte im Schloss.");
    erzeuge_untersuchung(2144, 1, POS_EGAL, "Die Schraube steckt fast komplett im Schloss.");
    erzeuge_kombination(1515, 2144, -1, 1, POS_EGAL, POS_EGAL, "Das reicht, sonst ist die Schraube zu tief reingedreht.");
    r=erzeuge_kombination(1515, 2144, -1, 0, POS_EGAL, POS_EGAL, "Du drehst die Schraube mit dem Schraubendreher fast bis zum Anschlag in das Schloss."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 2142, 2));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2144, 1));
    }

    erzeuge_gegenstand(2148,2100,true,false,true,"rauchmelder", "ein Rauchmelder", "An der Decke zwischen Bett und Tr hngt ein Rauchmelder.");
    erzeuge_untersuchung(2148, -1, POS_EGAL, "Dem regelmssigen Blinken nach zu urteilen ist er aktiv.");
    erzeuge_kombination(2148, 808, -1, -1, POS_EGAL, POS_EGAL, "Da ist kein Platz, um eine Leiter aufzustellen.");
    erzeuge_ziehen(2148, -1, POS_EGAL, "An den kommst du nicht ran.");

    erzeuge_gegenstand(2150,2100,true,false,true,"fenster", "ein Fenster", "An der linken Wand befindet sich das Fenster. Wie im Badezimmer sind die Jalousien bis auf Lichtschlitze geschlossen.", 1);
    r=erzeuge_untersuchung(2150, 0, POS_EGAL, "Das Fenster ist gekippt. Ein leichter Luftzug zieht durch den Raum und durch das Fenster hinaus."); {
      r->add_bedingung(new BedingungObjektHatZustand(this, 1007, 0));
      r->add_bedingung(new BedingungObjektHatZustand(this, 1540, 2));
    }
    r=erzeuge_untersuchung(2150, 0, POS_EGAL, "Das Fenster ist gekippt."); {
      r->add_bedingung(new BedingungOder(this, new BedingungObjektHatNichtZustand(this, 1007,0),
                                               new BedingungObjektHatNichtZustand(this, 1540,2)));
    }
    erzeuge_untersuchung(2150, 1, POS_EGAL, "Das Fenster ist geschlossen.");
    get_regeln()->add_regel(r=new Spielregel(this, CMD_SCHLIESSE, 2150, -1,false, true)); {
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 2150,0));
      a->add_aktion(new AktionObjektNeuerZustand(this, 2150, 1));
      a->add_aktion(new AktionTextausgabe(this, "Du schliet das Fenster."));
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 2150,1));
      a->add_aktion(new AktionTextausgabe(this, "Das Fenster ist bereits geschlossen."));
    }
    get_regeln()->add_regel(r=new Spielregel(this, CMD_OEFFNE, 2150, -1,false, true)); {
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 2150,1));
      a->add_aktion(new AktionObjektNeuerZustand(this, 2150, 0));
      a->add_aktion(new AktionTextausgabe(this, "Du ffnest das Fenster und kippst es."));
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 2150,0));
      a->add_aktion(new AktionTextausgabe(this, "Das Fenster ist bereits geffnet."));
    }





  // 22 Kinderzimmer

    erzeuge_gegenstand(2210,2200,true,false,true,"kinderbett", "ein Kinderbett", "Rechts an der Wand steht ein Bett mit Gittern.");
    erzeuge_untersuchung(2210, -1, POS_EGAL, "Das Bettzeug ist mit Motiven einer bekannten Katze versehen.");
    erzeuge_benutzung(2210, -1, POS_EGAL, "Da passt du nicht rein.");

    erzeuge_gegenstand(2220,2200,true,false,true,"fenster", "ein Fenster", "Die Jalousien des Fensters sind bis auf Sichtschlitze geschlossen.");
    erzeuge_untersuchung(2220, -1, POS_EGAL, "Das Fenster ist geschlossen und mit einer Kindersicherung versehen.");
    erzeuge_schliessen(2220, -1, "Das Fenster ist bereits geschlossen.");
    r = erzeuge_benutzung(2220, -1, POS_EGAL, "Das Fenster besitzt eine Kindersicherung. Und wir wissen ja bereits, wie gut du mit denen ohne Anleitung zurecht kommst."); {
      r->add_trigger(CMD_OEFFNE, 2220, -1);
      r->add_trigger(CMD_DRUECKE, 2220, -1);
      r->add_trigger(CMD_ZIEHE, 2220, -1);
    }

    erzeuge_gegenstand(2230,2200,true,false,true,"kasten", "ein Kasten", "Vor dem Fenster steht ein etwa getrnkekastengroer Kasten.");
    erzeuge_untersuchung(2230, -1, POS_EGAL, "Der Kasten besitzt einen Verschluss.");
    r=erzeuge_benutzung(2230, -1, POS_EGAL, "Du ffnest den Kasten und heraus springt ein Clownskopf auf einer Feder. Ein Clown! Wren es Aliens oder Ninjas gewesen, aber ein Clown? Vor Schreck taumelst du zurck, stt dir den Kopf am Trrahmen und trumst von Clowns, bis dich der Hausbesitzer weckt."); {
      r->add_trigger(CMD_OEFFNE, 2230, -1);
      r->add_aktion(new AktionSpielVerloren(this));
    }

    erzeuge_gegenstand(2240,2200,true,false,true,"puzzle", "ein Puzzle", "Daneben liegt eine Kiste mit einem Puzzlespiel auf der Oberseite.",0);
    erzeuge_untersuchung(2240, -1, POS_EGAL, "Oben sind Fassungen fr eine runde, eine quadratische und eine dreieckige Form.");
    r=erzeuge_benutzung(2240, 0, POS_EGAL, "Du bettigst den kleinen Hebel. Nichts passiert. Du kannst es wahrscheinlich erst dann entriegeln, wenn du alle Formen hast."); {
      r->add_bedingung(b = new BedingungOder(this));
      b->add_bedingung(new BedingungObjektNichtInInventar(this, CEXT::OBJ_FORM_DREIECK));
      b->add_bedingung(new BedingungObjektNichtInInventar(this, CEXT::OBJ_FORM_QUADRAT));
      b->add_bedingung(new BedingungObjektNichtInInventar(this, CEXT::OBJ_FORM_RUND));
    }
    r=erzeuge_benutzung(2240, 0, POS_EGAL, "Du legst die Formen in die Fassungen und bettigst den kleinen Hebel. Der Verschluss springt auf."); {
      r->add_bedingung(new BedingungObjektInInventar(this, CEXT::OBJ_FORM_DREIECK));
      r->add_bedingung(new BedingungObjektInInventar(this, CEXT::OBJ_FORM_QUADRAT));
      r->add_bedingung(new BedingungObjektInInventar(this, CEXT::OBJ_FORM_RUND));
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FORM_DREIECK, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FORM_QUADRAT, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FORM_RUND, false));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2240, 1));
    }
    r=erzeuge_kombination(CEXT::OBJ_FORM_DREIECK, 2240,-1, -1, POS_EGAL, POS_EGAL, " Du hast noch nicht alle Teile zusammen."); {
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FORM_QUADRAT, 2240);
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FORM_RUND, 2240);
      r->add_bedingung(b = new BedingungOder(this));
      b->add_bedingung(new BedingungObjektNichtInInventar(this, CEXT::OBJ_FORM_DREIECK));
      b->add_bedingung(new BedingungObjektNichtInInventar(this, CEXT::OBJ_FORM_QUADRAT));
      b->add_bedingung(new BedingungObjektNichtInInventar(this, CEXT::OBJ_FORM_RUND));
    }
    r=erzeuge_kombination(CEXT::OBJ_FORM_DREIECK, 2240,-1, -1, POS_EGAL, POS_EGAL, " Versuch besser, das Puzzle zu ffnen."); {
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FORM_QUADRAT, 2240);
      r->add_trigger(CMD_KOMBINIERE, CEXT::OBJ_FORM_RUND, 2240);
      r->add_bedingung(new BedingungObjektInInventar(this, CEXT::OBJ_FORM_DREIECK));
      r->add_bedingung(new BedingungObjektInInventar(this, CEXT::OBJ_FORM_QUADRAT));
      r->add_bedingung(new BedingungObjektInInventar(this, CEXT::OBJ_FORM_RUND));
    }
    erzeuge_oeffnen(2240, 0 , "Die Kiste ist noch verschlossen.");
    erzeuge_oeffnen(2240, 2 , "Die Kiste ist bereits offen.");
    r=erzeuge_oeffnen(2240, 1, "Du ffnest die Kiste und findest darin einen grnen Schlssel."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 2240, 2));
      r->add_aktion(new AktionObjektSetSichtbar(this, 2245, true));
    }

    erzeuge_gegenstand(2245,2200,false,false,false,"grner Schlssel", "ein grner Schlssel", "");
    erzeuge_untersuchung(2245, -1, POS_EGAL, "Man kann ihm nicht ansehen, fr welche Tr er gemacht ist.");
    erzeuge_benutzung(2245, -1, POS_EGAL, "Am besten versuchen wir es mit einer Tr.");

    erzeuge_gegenstand(2250,2200,true,false,true,"luke", "eine Luke", "Oben in der Decke fuehrt eine Luke auf den Dachboden.");
    erzeuge_untersuchung(2250, -1, POS_EGAL, "Eine Luke, die einfach zu ffnen ist, wenn man sie erreichen kann.");
    r=erzeuge_benutzung(2250, -1, POS_EGAL, "An die Luke kommst du so nicht ran."); {
      r->add_trigger(CMD_OEFFNE, 2250, -1);
      r->add_trigger(CMD_BENUTZE, 2260, -1);
      r->add_bedingung(new BedingungObjektIstNichtSichtbar(this, 2260));
    }
    r=erzeuge_benutzung(2250, -1, POS_EGAL, "Du steigst durch die Luke auf den Dachboden."); {
      r->add_trigger(CMD_OEFFNE, 2250, -1);
      r->add_trigger(CMD_BENUTZE, 2260, -1);
      r->add_bedingung(new BedingungObjektIstSichtbar(this, 2260));
      r->add_aktion(new AktionRaumwechsel(this, 2600));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100400, true));
    }

    erzeuge_gegenstand(2260,2200,true,false,false,"leiter", "eine Leiter", "Unter der Luke steht eine Leiter.");
    erzeuge_untersuchung(2260, -1, POS_EGAL, "ber die Leiter kommst du an die Luke.");
    r=erzeuge_kombination(808, 2250,-1, -1, POS_EGAL, POS_EGAL, " Du stellst die Leiter unter die Luke."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 2260, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, 808, false));
    }
    r = erzeuge_nehmen(2260, -1, false, "Du packst die Leiter wieder ein."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 2260, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, 808, true));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100400, false));
    }


    // 23 Waschraum

    erzeuge_gegenstand(CEXT::OBJ_TROCKNER,2300,true,false,true,"trockner", "ein Trockner", "An der Wand mit dem Lichtschacht steht links der Trockner.", CEXT::ST_TROCKNER_NORMAL);
    erzeuge_untersuchung(CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_NORMAL, POS_EGAL, "Mit einem Trockner trocknet man Wsche.");
    erzeuge_untersuchung(CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_TROCKNET, POS_EGAL, "Der Trockner trocknet noch immer. Das kann schon mal etwas dauern.");
    erzeuge_untersuchung(CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_FERTIG, POS_EGAL, "Das ich das noch erleben darf, der Trockner ist fertig!");
    erzeuge_benutzung(CEXT::OBJ_TROCKNER, -1, POS_EGAL, "Hast du nasse Wsche?");
    erzeuge_kombination(CEXT::OBJ_HANDTUCH, CEXT::OBJ_TROCKNER, CEXT::ST_HANDTUCH_SAUBER , -1, POS_EGAL, POS_EGAL, "Das ist doch trocken.");
    erzeuge_kombination(CEXT::OBJ_HANDTUCH, CEXT::OBJ_TROCKNER, CEXT::ST_HANDTUCH_DRECKIG , -1, POS_EGAL, POS_EGAL, "Das muss erst mal gewaschen werden.");
    r =erzeuge_kombination(CEXT::OBJ_HANDTUCH, CEXT::OBJ_TROCKNER, CEXT::ST_HANDTUCH_NASS , -1, POS_EGAL, POS_EGAL, "Du packst das nasse Handtuch in den Trockner und stellst ihn an."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_HANDTUCH, false));
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_TROCKNET));
    }
    r =erzeuge_kombination(2, CEXT::OBJ_TROCKNER, -1 , -1, POS_EGAL, POS_EGAL, "Das ist keine nasse Wsche."); {
      r->add_trigger(CMD_KOMBINIERE, 385, 2320);
    }
    erzeuge_oeffnen(CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_NORMAL, "Der Trockner ist leer.");
    erzeuge_oeffnen(CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_TROCKNET, "Der Trockner luft noch.");
    r = erzeuge_oeffnen(CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_FERTIG, "Du ffnest den Trockner und holst das Handtuch raus."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_HANDTUCH, true));
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_HANDTUCH, CEXT::ST_HANDTUCH_SAUBER));
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_TROCKNER, CEXT::ST_TROCKNER_NORMAL));
    }


    erzeuge_gegenstand(2320,2300,true,false,true,"waschmaschine", "eine Waschmaschine", "Daneben steht die Waschmaschine.", 0);
    r =erzeuge_kombination(2, 2320, -1 , 0, POS_EGAL, POS_EGAL, "Wie gesagt, ohne Weichspler mache ich nichts."); {
      r->add_trigger(CMD_KOMBINIERE, 385, 2320);
    }
    r =erzeuge_kombination(CEXT::OBJ_HANDTUCH, 2320, -1 , 0, POS_EGAL, POS_EGAL, "Und wo ist der Weichspler."); {
      r->add_bedingung((new BedingungObjektHatNichtZustand(this, CEXT::OBJ_HANDTUCH,CEXT::ST_HANDTUCH_DRECKIG)));
    }
    r =erzeuge_kombination(CEXT::OBJ_HANDTUCH, 2320, CEXT::ST_HANDTUCH_DRECKIG , 0, POS_EGAL, POS_EGAL, "Na gut, wir stellen es schonmal an und besorgen whrenddessen den Weichspler."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 2320, 1));
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_HANDTUCH, false));
    }
    erzeuge_untersuchung(2320, 0, POS_EGAL, "Ein gutes Fabrikat.");
    r=erzeuge_untersuchung(2320, 1, POS_EGAL, "Die Waschmaschine wscht gerade."); {
      r->add_trigger(CMD_BENUTZE, 2320, -1);
    }
    erzeuge_benutzung(2320, 0, POS_EGAL, "Solange du den Weichspler nicht gefunden hast, brauchen wir gar nicht anfangen.");
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2320, -1 , 0, POS_EGAL, POS_EGAL, "Im Seifenspender ist nichts drin."); {
      r->add_bedingung(b = new BedingungOder(this));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_ORG)));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_LEER)));
    }
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2320, -1 , 0, POS_EGAL, POS_EGAL, "Ich flle nicht einfach etwas in die Waschmaschine, ohne einen Plan zu haben."); {
      r->add_bedingung((new BedingungObjektHatNichtZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_ORG)));
      r->add_bedingung((new BedingungObjektHatNichtZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_LEER)));
    }

    erzeuge_gegenstand(2330,2300,true,false,true,"waschmittel", "waschmittel", "Rechts neben der Waschmaschine steht eine Familienpackung Waschmittel.", 0);
    erzeuge_untersuchung(2330, -1, POS_EGAL, "Das Paket ist noch fast ganz voll.");
    erzeuge_benutzung(2330, -1, POS_EGAL, "Waschmittel auf mein Haupt, oder wie?");
    erzeuge_nehmen(2330, -1, false, "Wo soll ich das hinpacken? In meine Tasche rieseln?");
    erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2330, CEXT::ST_SEIFE_ORG, -1, POS_EGAL, POS_EGAL, "Der Seifenspender ist zugeschraubt, da bekomme ich nichts rein.");
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2330, -1 , -1, POS_EGAL, POS_EGAL, "In den Seifenspender passt nichts mehr rein."); {
      r->add_bedingung(b = new BedingungOder(this));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_SEIFE)));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_VOLLWASCHMITTEL)));
      b->add_bedingung((new BedingungObjektHatZustand(this, CEXT::OBJ_SEIFENSPENDER,CEXT::ST_SEIFE_VOLLWASSER)));
    }
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2330, CEXT::ST_SEIFE_WASCHMITTEL, -1, POS_EGAL, POS_EGAL, "Du fllst den Seifenspender randvoll mit Waschmittel."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_VOLLWASCHMITTEL));
    }
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2330, CEXT::ST_SEIFE_LEER, -1, POS_EGAL, POS_EGAL, "Du fllst den Seifenspender zur Hlfte mit Waschmittel."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_WASCHMITTEL));
    }
    r=erzeuge_kombination(CEXT::OBJ_SEIFENSPENDER, 2330, CEXT::ST_SEIFE_WASSER, -1, POS_EGAL, POS_EGAL, "Du versuchst, mit dem Seifenspender etwas Waschmittel hinein zu schaufeln. Dabei luft dir das ganze Wasser aus."); {
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_SEIFENSPENDER, CEXT::ST_SEIFE_WASCHMITTEL));
    }

    erzeuge_gegenstand(2340,2300,true,false,false,"schrank", "ein Schrank", "In der Mitte der Waschkche steht der Schrank, den du aus dem Flur hierher geschoben hast.");
    erzeuge_oeffnen(2340, -1, "Der Schrank ist leer.");
    r = erzeuge_untersuchung(2340, -1, POS_EGAL, "Vom Schieben ber die hubbeligen Fliesen sind zwei Fe abgebrochen. Den bekommen wir hier nicht mehr weg."); {
      r->add_trigger(CMD_DRUECKE, 2340, -1);
      r->add_trigger(CMD_ZIEHE, 2340, -1);
    }




    // 24 Kchenschublade

    erzeuge_gegenstand(2400,2400,true,false,true,"schublade", "eine  Schublade", "");
    erzeuge_untersuchung(2400, -1, POS_EGAL, "Du schaust gerade hinein.");
    r =erzeuge_beschreibung(2400, -1, "Die Schublade ist leer."); {
      r->add_bedingung((new BedingungObjektInInventar(this, 2410)));
    }
    r =erzeuge_schliessen(2400, -1, "Du schliet die Schublade."); {
      r->add_trigger(CMD_DRUECKE, 2400, -1);
      r->add_aktion(new AktionRaumwechsel(this, 300));
    }

    erzeuge_gegenstand(2410,2400,false,false,true,"knochensge", "eine Knochensge", "In der Schublade liegt eine Knochensge.");
    erzeuge_untersuchung(2410, -1, POS_EGAL, "Gruselige Vorstellung, was die hier alles damit machen knnten.");
    erzeuge_benutzung(2410, -1, POS_EGAL, "Du bist schon etwas suizidgefhrdet, oder?");
    erzeuge_kombination(2410, 20, -1, -1, POS_EGAL, POS_EGAL, "An etwas zu sgen, was man nur in der Hand hlt, ist keine gute Idee.");







    // 25 Nachtschrank

    erzeuge_gegenstand(2500,2500,true,false,true,"nachtschrank", "ein Nachtschrank", "");
    erzeuge_untersuchung(2500, -1, POS_EGAL, "Du schaust gerade hinein.");
    r =erzeuge_schliessen(2500, -1, "Du schliet den Schrank."); {
      r->add_trigger(CMD_DRUECKE, 2500, -1);
      r->add_aktion(new AktionRaumwechsel(this, 2100));
    }


    erzeuge_gegenstand(2510,2500,true,false,true,"gert", "ein gert", "Im Nachtschrank liegt ein merkwrdiges Gert,");
    erzeuge_untersuchung(2510, -1, POS_EGAL, "Dazu fehlt mir die Beschreibungskraft.");
    erzeuge_benutzung(2510, -1, POS_EGAL, "Auf gar keinen Fall!");
    erzeuge_nehmen(2510, -1, false, "Sehen wir den Tatsachen ins Auge: Die Wahrscheinlichkeit ist gro, dass wir erwischt werden. Und mit dem Ding will ich definitiv nicht erwischt werden!");
    erzeuge_oeffnen(2510, -1, "Wir brauchen keine Batterien.");
    r=erzeuge_druecken(2510, -1, POS_EGAL, "An deiner Stelle wrde ich es nicht anfassen."); {
      r->add_trigger(CMD_ZIEHE, 2510,-1);
    }

    erzeuge_gegenstand(2520,2500,false,false,true,"schlaftabletten", "schlaftabletten", "eine Packung Schlaftabletten der extrem starken Sorte,");
    erzeuge_untersuchung(2520, -1, POS_EGAL, "Wenn man davon zwei nimmt, verschlft man das jngste Gericht.");
    erzeuge_benutzung(2520, -1, POS_EGAL, "Willst du schon wieder einpennen?");
    r=erzeuge_nehmen(2520, -1, true, "Du packst die Schlaftabletten ein."); {
      r->add_bedingung(new BedingungObjektNichtInInventar(this, 2520));
    }

    erzeuge_gegenstand(2530,2500,true,false,true,"zeitschrift", "eine Zeitschrift", "eine Zeitschrift mit wertvollen Dittipps");
    erzeuge_untersuchung(2530, -1, POS_EGAL, "Die Super-Dit: Wie sie in zwei Wochen 5 Kilo abnehmen, wenn sie die Woche davor 8 Kilo zugenommen haben.");
    erzeuge_benutzung(2530, -1, POS_EGAL, "Willst du sagen, ich bin dick?");
    erzeuge_nehmen(2530, -1, false, "Nein, lass sie liegen. Denk an den Jojo-Effekt.");

    erzeuge_gegenstand(2540,2500,true,false,true,"gurkenmaske", "eine gurkenmaske", "und die Reste einer Gurkenmaske.");
    erzeuge_untersuchung(2540, -1, POS_EGAL, "Was man alles in einem Nachtschrnkchen findet.");
    erzeuge_benutzung(2540, -1, POS_EGAL, "Igitt!");
    erzeuge_nehmen(2540, -1, false, "Du willst keinen Salat machen und mein Aussehen ist schon perfekt, also lassen wir sie liegen.");






  // 26 Dachboden

    erzeuge_gegenstand(2640,2600,true,false,true,"dachfenster", "ein Dachfenster", "Oben zwischen den Dachziegeln ist ein Fenster eingelassen.", 0);
    r = erzeuge_untersuchung(2640, -1, POS_EGAL, "Das Fenster ist etwas zu hoch angebracht, man kann nichts sehen."); {
      r->add_bedingung((new BedingungObjektIstNichtSichtbar(this, 2650)));
    }
    r = erzeuge_untersuchung(2640, -1, POS_EGAL, "Du stellst dich auf das Buch, schaust aus dem Fenster und siehst den hinteren Teil des Gartens mit dem Gartenhuschen."); {
      r->add_bedingung((new BedingungObjektIstSichtbar(this, 2650)));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2640, 1));
    }
    erzeuge_benutzung(2640, 0, POS_EGAL, "Was soll ich denn machen?");
    erzeuge_oeffnen(2640, -1, "Sag mir doch zuerst, was ich machen soll.");
    r=erzeuge_kombination(27, 2640, -1, 0, POS_EGAL, POS_EGAL, "Ich werfe doch nichts aus dem Fenster ohne zu wissen, wo es landet. Nachher treffe ich noch einen Nachbarn."); {
      r->add_trigger(CMD_KOMBINIERE,CEXT::OBJ_FEUERZEUG, 2640);
      r->add_trigger(CMD_KOMBINIERE,CEXT::OBJ_HANDTUCH, 2640);
      r->add_trigger(CMD_KOMBINIERE,2520, 2640);
      r->add_trigger(CMD_KOMBINIERE,1, 2640);
      r->add_trigger(CMD_KOMBINIERE,18, 2640);
    }
    r=erzeuge_kombination(27, 2640, -1, 1, POS_EGAL, POS_EGAL, "Du wirfst das Steak aus dem Fenster. Aber so wie deine Plne bisher abliefen, ist der Hund Vegetarier."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 27, false));
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 27,1));
      a->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_SCHLAEFT));
    }
    r=erzeuge_kombination(CEXT::OBJ_FEUERZEUG, 2640, -1, 1, POS_EGAL, POS_EGAL, "Du wirfst das Feuerzeug aus dem Fenster. Rauchen ist eh ungesund."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_FEUERZEUG, false));
    }
    r=erzeuge_kombination(CEXT::OBJ_HANDTUCH, 2640, -1, 1, POS_EGAL, POS_EGAL, "Du wirfst das Handtuch aus dem Fenster. Das war sowieso zu weich."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, CEXT::OBJ_HANDTUCH, false));
    }
    r=erzeuge_kombination(2520, 2640, -1, 1, POS_EGAL, POS_EGAL, "wirfst die Schlaftabletten aus dem Fenster. Wollen wir hoffen, der Hund wei, wie man eine Verpackung ffnet."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 2520, false));
    }
    r=erzeuge_kombination(1, 2640, -1, 1, POS_EGAL, POS_EGAL, "Du faltest ein Flugzeug aus dem Zettel und lsst es fliegen, vielleicht verfolgt es der Hund ja bis in den Nachbargarten."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 1, false));
    }
    r=erzeuge_kombination(18, 2640, -1, 1, POS_EGAL, POS_EGAL, "Aus dem DIN A4-Blatt faltest du ein Flugzeug und lsst es fliegen, vielleicht verfolgt es der Hund ja bis in den Nachbargarten."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 18, false));
    }

    erzeuge_gegenstand(2650,2600,true,false,false,"buch", "ein Buch", "Vor dem Dachfenster liegt ein Buch.");
    r=erzeuge_kombination(1516, 2640, -1, -1, POS_EGAL, POS_EGAL, "Du legst das Buch vor dem Dachfenster ab."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 1516, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, 2650, true));
    }
    erzeuge_nehmen(2650, -1, false, "Blo nicht. Sei froh, es nicht mehr schleppen zu mssen.");
    r=erzeuge_benutzung(2650, -1, POS_EGAL, "Wenn es vorher fr dich nichts Interessantes darin gab, dann jetzt wohl auch nicht."); {
      r->add_trigger(CMD_OEFFNE, 2650, -1);
    }






  // 28 Grundstcksmauer

    erzeuge_gegenstand(2810,2800,true,false,true,"garten", "ein Garten", "Zu deiner Rechten liegt der Garten des Hauses.");
    r=erzeuge_gehe(100480, "Noch bevor ich \"Stopp\" rufen kann, springst du in den Garten. Der Hund freut sich und wartet mit dir zusammen auf den Hausbesitzer."); {
      r->add_aktion(new AktionSpielVerloren(this));
    }

    erzeuge_gegenstand(2820,2800,true,false,true,"rosen", "die Rosen", "Von hier aus hat man einen schnen Blick auf die gegenberliegende Mauer mit den Rosenstcken.");

    erzeuge_gegenstand(2830,2800,true,false,true,"hund", "ein Hund", "", CEXT::ST_HUND_AUFGEWACHT);
    erzeuge_beschreibung(2830, CEXT::ST_HUND_AUFGEWACHT, "Direkt unter dir knurrt der Hund und versucht erfolglos, dich anzuspringen.");
    erzeuge_beschreibung(2830, CEXT::ST_HUND_ROSEN, "Mitten in den Rosen wtet der Hund und sucht seine Quietscheente.");
    r=erzeuge_kombination(1632, 2840, -1, -1, POS_EGAL, POS_EGAL, "Du wirfst die Ente ins Wohnzimmer. Der Hund holt sie sich und liegt nun im Eingang. Also mach es dir auf der Mauer bequem, bis der Hausbesitzer da ist."); {
      r->add_aktion(new AktionSpielVerloren(this));
    }
    erzeuge_kombination(1632, 2850, -1, -1, POS_EGAL, POS_EGAL, "Lass mich nachdenken. Ja, das war wohl von allen Mglichkeiten, wo man die Ente hinwerfen kann, die dmlichste Wahl.");
    erzeuge_kombination(1632, 2830, -1, -1, POS_EGAL, POS_EGAL, "Du wirfst die Quietscheente zum Hund und triffst seine Schnauze. Das macht ihn irgendwie wtend.");
    erzeuge_kombination(1632, 2810, -1, -1, POS_EGAL, POS_EGAL, "Du wirfst die Quietscheente in den Garten. Der Hund ist zwei Sekunden abgelenkt und knurrt dich nun mit Quietscheente im Maul an.");
    r=erzeuge_kombination(1632, 2820, -1, -1, POS_EGAL, POS_EGAL, "Du wirfst die Quietscheente in den gegenberliegenden Rosenstock. Der Hund hechtet hinter."); {
      r->add_bedingung(new BedingungObjektHatNichtZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN));
      r->add_bedingung(new BedingungObjektHatZustand(this, 2, 0));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2830, CEXT::ST_HUND_ROSEN));
      r->add_aktion(new AktionObjektSetSichtbar(this, 1632, false));
    }
    r=erzeuge_kombination(1632, 2820, -1, -1, POS_EGAL, POS_EGAL, "Du wirfst die Quietscheente in den gegenberliegenden Rosenstock. Der Hund scheint immer noch so fixiert auf den Blutgeruch, dass er sie ignoriert."); {
      r->add_bedingung(new BedingungOder(this, new BedingungObjektHatZustand(this, 385, CEXT::ST_SCHUERZE_DRECKIGGETRAGEN),
                                               new BedingungObjektHatZustand(this, 2, 1)));
    }

    r=erzeuge_kombination(27, 2830, -1, -1, POS_EGAL, POS_EGAL, "Du wirfst dem Hund das Steak zu. Aber offensichtlich hat er mittlerweile verstanden, was ihm dann passiert, und ignoriert es."); {
      r->add_aktion(new AktionObjektSetSichtbar(this, 27, false));
    }

    erzeuge_gegenstand(2840,2800,true,false,true,"wohnzimmer", "das Wohnzimmer", "Am Ende der Mauer, von dort nur einen 2 Meter Sprung in die Tiefe entfernt, liegt der Eingang zum Wohnzimmer.");
    r=erzeuge_gehe(100470, "Du springst von der Mauer und ins Wohnzimmer, der Hund hinterher. Dein Schwung wirft dich auf den Sessel, der Hund hinterher. Dort wartet er zufrieden auf deinem Scho, bis sein Herrchen kommt."); {
      r->add_bedingung((new BedingungObjektHatNichtZustand(this, 2830,CEXT::ST_HUND_ROSEN)));
      r->add_aktion(new AktionSpielVerloren(this));
    }
    r=erzeuge_gehe(100470, "Whrend der Hund nach der Ente sucht, springst du die Mauer hinunter und sprintest ins Wohnzimmer. Hastig drehst du dich um und schliet die Tr. Geschafft."); {
      r->add_bedingung((new BedingungObjektHatZustand(this, 2830,CEXT::ST_HUND_ROSEN)));
      r->add_aktion(new AktionObjektNeuerZustand(this, CEXT::OBJ_HUND, CEXT::ST_HUND_AUFGEWACHT));
      r->add_aktion(new AktionObjektNeuerZustand(this, 2830, CEXT::ST_HUND_AUFGEWACHT));
      r->add_aktion(new AktionObjektNeuerZustand(this, 1540, 2));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100280, false));
      r->add_aktion(new AktionObjektSetSichtbar(this, 100290, false));
    }

    erzeuge_gegenstand(2850,2800,true,false,true,"nachbargrundstck", "das Nachbargrundstck", "Auf der linken Seite liegt der Garten des Nachbargrundstcks.");
    r=erzeuge_gehe(100460, "Du springst von der Mauer und bist noch nicht ganz auf dem Rasen der Nachbarn gelandet, da haben die schon die Polizei gerufen. Noch bevor du vom Rasen runter bist, ist sie da. Wren die doch sonst auch immer so schnell."); {
      r->add_aktion(new AktionSpielVerloren(this));
    }





  // 30 Vor dem Haus

    erzeuge_gegenstand(3000,3000,true,false,true,"hausbesitzer", "die Hausbesitzer", "Vor dir stehen der Hausbesitzer und seine Frau.", 0);
    r=erzeuge_kombination(1, 3000, -1, 1, POS_EGAL, POS_EGAL, "Du hast doch schon gefragt, jetzt nur nicht auffallen!"); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 3000, 1));
    }
    r=erzeuge_kombination(1, 3000, -1, 0, POS_EGAL, POS_EGAL, "Du hltst dem Hausbesitzer den Zettel hin. \"Wissen Sie zufllig, wo das ist?\"\nDer Hausbesitzer schaut sich die Adresse an. \"Das ist gleich hier um die Ecke.\""); {
      r->add_aktion(new AktionObjektNeuerZustand(this, 3000, 1));
    }

    get_regeln()->add_regel(r = new Spielregel(this, CMD_GEHE, 100510, -1, false, true)); {
      a=new AktionBedingt(this, r, new BedingungObjektHatZustand(this, 3000,0));
      a->add_aktion(new AktionTextausgabe(this, "Du willst wortlos an den beiden vorbei gehen, wirst aber vom Hausbesitzer festgehalten.\n\"Also, Sie verhalten sich ausgesprochen verdchtig. Ilse, ruf die Polizei!\"\nSo ein Mist, und du httest es fast geschafft."));
      a->add_aktion(new AktionSpielVerloren(this));

      a=new AktionBedingt(this, r, new BedingungObjektIstSichtbar(this, 612));
      a->add_aktion(new AktionTextausgabe(this, "Du machst dich auf den Weg zur Strae, als die Frau ruft \"Heinz, da hngt eins unserer Handtcher hinten raus!?\"\nHeinz mustert dich. \"Ilse, ruf die Polizei!\""));
      a->add_aktion(new AktionSpielVerloren(this));

      a=new AktionBedingt(this, r, new BedingungObjektIstSichtbar(this, 908));
      a->add_aktion(new AktionTextausgabe(this, "Du machst dich auf den Weg zur Strae, als die Frau ruft \"Heinz, wie kommt diese Person an unsere Fernbedienung?\"\nHeinz mustert dich. \"Ilse, ruf die Polizei!\""));
      a->add_aktion(new AktionSpielVerloren(this));

      a=new AktionBedingt(this, r, new BedingungObjektIstSichtbar(this, 906));
      a->add_aktion(new AktionTextausgabe(this, "Du machst dich auf den Weg zur Strae, als die Frau ruft \"Heinz, ist das nicht das Marmeladenglas von Oma Guste?\"\nHeinz mustert dich. \"Ilse, ruf die Polizei!\""));
      a->add_aktion(new AktionSpielVerloren(this));

      a=new AktionBedingt(this, r);
      a->add_aktion(new AktionTextausgabe(this, "Du gehst auf die Strae, blickst noch einmal zurck und denkst an all die Dinge, die du erlebt hast. Dann setzt du deinen Weg fort, als wre nichts gewesen."));
      a->add_aktion(new AktionSpielGewonnen(this));

    }







}
