/*
 * BenanntesObjekt.cpp
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#include "BenanntesObjekt.h"
#include "Stringfunktionen.h"
#include "Objektanalyzer.h"

using namespace std;

void BenanntesObjekt::analyse() const {Objektanalyzer::analyse(this); }

BenanntesObjekt::BenanntesObjekt(Spiel* spiel, id_type id, string n)
: IdObjekt(spiel, id), name(n) {

}

bool BenanntesObjekt::partial_name_match(const std::string& s) const {
  if(s.size()>name.size())
    return false;
  return lower_string(s) == lower_string(name.substr(0, s.size()));
}

bool BenanntesObjekt::exact_name_match(const std::string& s) const {
  return lower_string(s)==lower_string(name);
}
