/*
 * BenObjektliste.cpp
 *
 *  Created on: 12.05.2014
 *      Author: Andr Willms
 */

#include "BenObjektliste.h"
#include "BenanntesObjekt.h"
#include "IdObjekt.h"

//#include <memory>

using namespace std;

BenObjektListe::BenObjektListe()
: IdObjektListe() {

}

int BenObjektListe::get_id_by_partial_name_match(const std::string& s) const {
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    BenanntesObjekt* ptr=dynamic_cast<BenanntesObjekt*>((*iter).get());
    if(ptr->partial_name_match(s))
      return ptr->get_id();
  }
  return -1;

}

int BenObjektListe::get_id_by_exact_name_match(const std::string& s) const {
  for(auto iter=objekte.begin(); iter!=objekte.end(); ++iter) {
    BenanntesObjekt* ptr=dynamic_cast<BenanntesObjekt*>((*iter).get());
    if(ptr->exact_name_match(s))
      return ptr->get_id();
  }
  return -1;


}
