/*
 * Bedingungen.h
 *
 *  Created on: 13.05.2014
 *      Author: Andr Willms
 */

#ifndef BEDINGUNGEN_H_
#define BEDINGUNGEN_H_

#include "Bedingung.h"

class BedingungSpielerInRaum : public Bedingung {
  id_type raum;
public:
  BedingungSpielerInRaum(Spiel* spiel, id_type r) : Bedingung(spiel), raum(r) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"playerinroom\" room=\"" << raum << "\" />\n";
  }
};


class BedingungObjektInAktRaum : public Bedingung {
  id_type obj;
public:
  BedingungObjektInAktRaum(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectincurrentroom\" object=\"" << obj << "\" />\n";
  }
};

class BedingungObjektAnOrgPos : public Bedingung {
  id_type obj;
public:
  BedingungObjektAnOrgPos(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectatoriginalpos\" object=\"" << obj << "\" />\n";
  }
};

class BedingungObjektFest : public Bedingung {
  id_type obj;
public:
  BedingungObjektFest(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectfixed\" object=\"" << obj << "\" />\n";
  }
};

class BedingungObjektLose : public Bedingung {
  id_type obj;
public:
  BedingungObjektLose(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectnotfixed\" object=\"" << obj << "\" />\n";
  }
};

class BedingungObjektHatZustand : public Bedingung {
  id_type obj;
  id_type zustand;
public:
  BedingungObjektHatZustand(Spiel* spiel, id_type o, id_type z) : Bedingung(spiel), obj(o), zustand(z) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectinstate\" object=\"" << obj << "\" state=\"" << zustand << "\" />\n";
  }
};

class BedingungObjektHatNichtZustand : public Bedingung {
  id_type obj;
  id_type zustand;
public:
  BedingungObjektHatNichtZustand(Spiel* spiel, id_type o, id_type z) : Bedingung(spiel), obj(o), zustand(z) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectnotinstate\" object=\"" << obj << "\" state=\"" << zustand << "\" />\n";
  }
};

class BedingungObjektInInventar : public Bedingung {
  id_type obj;
public:
  BedingungObjektInInventar(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectininventory\" object=\"" << obj << "\" />\n";
  }
};

class BedingungObjektNichtInInventar : public Bedingung {
  id_type obj;
public:
  BedingungObjektNichtInInventar(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectnotininventory\" object=\"" << obj << "\" />\n";
  }
};

class BedingungObjektIstSichtbar : public Bedingung {
  id_type obj;
public:
  BedingungObjektIstSichtbar(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectvisible\" object=\"" << obj << "\" />\n";
  }
};

class BedingungObjektIstNichtSichtbar : public Bedingung {
  id_type obj;
public:
  BedingungObjektIstNichtSichtbar(Spiel* spiel, id_type o) : Bedingung(spiel), obj(o) {}
  virtual bool pruefen() const;
  void xml_out(std::ostream& ostr) const {
    ostr << "<condition type=\"objectnotvisible\" object=\"" << obj << "\" />\n";
  }
};




#endif /* BEDINGUNGEN_H_ */
