/*
 * Bedingungen.cpp
 *
 *  Created on: 13.05.2014
 *      Author: Andr Willms
 */

#include "Bedingungen.h"
#include "Spiel.h"
#include "Raum.h"
#include "Gegenstand.h"

bool BedingungSpielerInRaum::pruefen() const {
  return get_spiel()->get_akt_raum()->get_id() == raum;
}


bool BedingungObjektInAktRaum::pruefen() const {
  return get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->in_akt_raum();
}

bool BedingungObjektAnOrgPos::pruefen() const {
  return get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->an_org_pos();
}

bool BedingungObjektFest::pruefen() const {
  return get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->ist_fest();
}

bool BedingungObjektLose::pruefen() const {
  return !get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->ist_fest();
}

bool BedingungObjektHatZustand::pruefen() const {
  return get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->get_zustand() == zustand;
}

bool BedingungObjektHatNichtZustand::pruefen() const {
  return get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->get_zustand() != zustand;
}

bool BedingungObjektInInventar::pruefen() const {
  return get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->in_inventar();
}

bool BedingungObjektNichtInInventar::pruefen() const {
  return !get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->in_inventar();
}

bool BedingungObjektIstSichtbar::pruefen() const {
  return get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->ist_sichtbar();
}

bool BedingungObjektIstNichtSichtbar::pruefen() const {
  return !get_spiel()->get_gegenstaende()->get_gegenstand_by_id(obj)->ist_sichtbar();
}

