/*
 * BedingungOder.cpp
 *
 *  Created on: 14.05.2014
 *      Author: Andr Willms
 */

#include "BedingungOder.h"

BedingungOder::BedingungOder(Spiel* spiel)
  : Bedingung(spiel) {
}

BedingungOder::BedingungOder(Spiel* spiel, Bedingung* b1, Bedingung* b2)
  : Bedingung(spiel) {
  add_bedingung(b1);
  add_bedingung(b2);

}


void BedingungOder::add_bedingung(Bedingung* b) {
  bedingungen.push_back(bedingung_ptr(b));
}

bool BedingungOder::pruefen() const {
  for(auto iter=bedingungen.begin(); iter!=bedingungen.end(); ++iter) {
    if((*iter)->pruefen())
      return true;
  }
  return false;
}

void BedingungOder::xml_out(std::ostream& ostr) const {
  ostr << "<conditionor>\n";
  for(auto iter=bedingungen.begin(); iter!=bedingungen.end(); ++iter) {
    (*iter)->xml_out(ostr);
  }
  ostr << "</conditionor>\n";
}
