/*
 * Aktionen.h
 *
 *  Created on: 13.05.2014
 *      Author: Andr Willms
 */

#ifndef AKTIONEN_H_
#define AKTIONEN_H_

#include "Aktion.h"
#include <string>

class AktionRaumwechsel : public Aktion {
  id_type raum;
public:
  AktionRaumwechsel(Spiel* spiel, id_type r) : Aktion(spiel), raum(r) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    ostr << "<action type=\"changeroom\" room=\"" << raum << "\" />\n";
  }
};

class AktionTextausgabe : public Aktion {
  std::string text;
public:
  AktionTextausgabe(Spiel* spiel, const std::string& s) : Aktion(spiel), text(s) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    ostr << "<actiontext>\n";
    ostr << text << "\n";
    ostr << "</actiontext>\n";
  }
};

class AktionObjektNeuePos : public Aktion {
  id_type obj;
  id_type raum;
public:
  AktionObjektNeuePos(Spiel* spiel, id_type o, id_type r) : Aktion(spiel), obj(o), raum(r) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    ostr << "<action type=\"objectnewpos\" object=\"" << obj << "\" pos=\"" << raum << "\" />\n";
  }
};

class AktionObjektNeuerZustand : public Aktion {
  id_type obj;
  int zustand;
public:
  AktionObjektNeuerZustand(Spiel* spiel, id_type o, int z) : Aktion(spiel), obj(o), zustand(z) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    ostr << "<action type=\"objectnewstate\" object=\"" << obj << "\" state=\"" << zustand << "\" />\n";
  }
};

class AktionObjektSetSichtbar : public Aktion {
  id_type obj;
  bool sichtbar;
public:
  AktionObjektSetSichtbar(Spiel* spiel, id_type o, bool s) : Aktion(spiel), obj(o), sichtbar(s) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    if(sichtbar)
      ostr << "<action type=\"objectsetvisible\" object=\"" << obj << "\" />\n";
    else
      ostr << "<action type=\"objectsetinvisible\" object=\"" << obj << "\" />\n";
  }
};

class AktionSpielVerloren : public Aktion {
public:
  AktionSpielVerloren(Spiel* spiel) : Aktion(spiel) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    ostr << "<action type=\"gamelost\" />\n";
  }
};

class AktionSpielGewonnen : public Aktion {
public:
  AktionSpielGewonnen(Spiel* spiel) : Aktion(spiel) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    ostr << "<action type=\"gamewon\" />\n";
  }
};

class AktionObjektZustandCountTo : public Aktion {
  id_type obj;
  int ziel_zustand;
public:
  AktionObjektZustandCountTo(Spiel* spiel, id_type o, int z) : Aktion(spiel), obj(o), ziel_zustand(z) {}
  virtual bool ausfuehren();
  void xml_out(std::ostream& ostr) const {
    ostr << "<action type=\"objectstatecountto\" object=\"" << obj << "\" state=\"" << ziel_zustand << "\" />\n";
  }
};


#endif /* AKTIONEN_H_ */
