/*
 * AktionBedingt.h
 *
 *  Created on: 16.05.2014
 *      Author: Andr Willms
 */

#ifndef AKTIONBEDINGT_H_
#define AKTIONBEDINGT_H_

#include "Aktion.h"
#include "Bedingung.h"


#include <vector>
#include <memory>

class Spielregel;

class AktionBedingt : public Aktion {
  public:
  typedef std::unique_ptr<Bedingung> bedingung_ptr;
  typedef std::unique_ptr<Aktion> aktion_ptr;

private:
  std::vector<bedingung_ptr> bedingungen;
  std::vector<aktion_ptr> aktionen;
  bool single_action;

  bool pruefe_bedingungen() const;

  bool fuehre_aktionen_aus();
public:
  AktionBedingt(Spiel* spiel, bool single=false);
  AktionBedingt(Spiel* spiel, Spielregel* r, bool single=false);
  AktionBedingt(Spiel* spiel, AktionBedingt* a, bool single=false);
  AktionBedingt(Spiel* spiel, Spielregel* r, Bedingung* b, Aktion* a=nullptr, bool single=false);
  AktionBedingt(Spiel* spiel, AktionBedingt* ab, Bedingung* b, Aktion* a=nullptr, bool single=false);

  virtual ~AktionBedingt() {
  }

  virtual bool ausfuehren();

  void add_bedingung(Bedingung* b) {
    bedingungen.push_back(bedingung_ptr(b));
  }

  void add_aktion(Aktion* b) {
    aktionen.push_back(aktion_ptr(b));
  }

  void xml_out(std::ostream& ostr) const;
};

#endif /* AKTIONBEDINGT_H_ */
