/*
 * AktionBedingt.cpp
 *
 *  Created on: 16.05.2014
 *      Author: Andr Willms
 */

#include "AktionBedingt.h"

#include "Spielregel.h"

AktionBedingt::AktionBedingt(Spiel* spiel, bool single)
  : Aktion(spiel), single_action(single) {
}

AktionBedingt::AktionBedingt(Spiel* spiel, Spielregel* r, bool single)
  : Aktion(spiel), single_action(single) {
  r->add_aktion(this);
}

AktionBedingt::AktionBedingt(Spiel* spiel, AktionBedingt* a, bool single)
  : Aktion(spiel), single_action(single) {
  a->add_aktion(this);
}

AktionBedingt::AktionBedingt(Spiel* spiel, Spielregel* r, Bedingung* b, Aktion* a, bool single)
  : Aktion(spiel), single_action(single) {
  r->add_aktion(this);
  add_bedingung(b);
  if(a) add_aktion(a);
}

AktionBedingt::AktionBedingt(Spiel* spiel, AktionBedingt* ab, Bedingung* b, Aktion* a, bool single)
  : Aktion(spiel), single_action(single) {
  ab->add_aktion(this);
  add_bedingung(b);
  if(a) add_aktion(a);
}

bool AktionBedingt::ausfuehren() {
  if(!pruefe_bedingungen())
    return false;

  return fuehre_aktionen_aus();
}

bool AktionBedingt::pruefe_bedingungen() const {
  for(auto iter=bedingungen.begin(); iter!=bedingungen.end(); ++iter) {
    if(!(*iter)->pruefen())
      return false;
  }
  return true;
}

bool AktionBedingt::fuehre_aktionen_aus() {
  bool erfolg=false;
  for(auto iter=aktionen.begin(); iter!=aktionen.end(); ++iter) {
    if((*iter)->ausfuehren()) {
      if(single_action)
        return true;
      erfolg=true;
    }
  }
  return erfolg;
}

void AktionBedingt::xml_out(std::ostream& ostr) const {
  ostr << "<actionconditioned";
  if(single_action) ostr << " oneaction=\"oneaction\"";
  ostr << " >\n";
  for(auto iter=bedingungen.begin(); iter!=bedingungen.end(); ++iter) {
    (*iter)->xml_out(ostr);
  }
  for(auto iter=aktionen.begin(); iter!=aktionen.end(); ++iter) {
    (*iter)->xml_out(ostr);
  }
  ostr << "</actionconditioned>\n";
}
