/*
 * Decompiled with CFR 0.152.
 */
package textengine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Scanner;
import textengine.Aktion;
import textengine.AktionBedingt;
import textengine.AktionObjektNeuePos;
import textengine.AktionObjektNeuerZustand;
import textengine.AktionObjektSetSichtbar;
import textengine.AktionObjektZustandCountTo;
import textengine.AktionRaumwechsel;
import textengine.AktionSpielGewonnen;
import textengine.AktionSpielVerloren;
import textengine.AktionTextausgabe;
import textengine.Bedingung;
import textengine.BedingungObjektAnOrgPos;
import textengine.BedingungObjektHatNichtZustand;
import textengine.BedingungObjektHatZustand;
import textengine.BedingungObjektInAktRaum;
import textengine.BedingungObjektInInventar;
import textengine.BedingungObjektIstNichtSichtbar;
import textengine.BedingungObjektIstSichtbar;
import textengine.BedingungObjektNichtInInventar;
import textengine.BedingungOder;
import textengine.Gegenstand;
import textengine.Raum;
import textengine.Spiel;
import textengine.Spielregel;
import textengine.StringIterator;
import textengine.Trigger;

public class XmlLoader {
    private Spiel spiel;

    public XmlLoader(Spiel s) {
        this.spiel = s;
    }

    public static String lade_datei(String datei) {
        String dat = null;
        try {
            dat = new String(Files.readAllBytes(Paths.get(datei, new String[0])), StandardCharsets.ISO_8859_1);
        }
        catch (FileNotFoundException e) {
            System.out.println("Datei nicht gefunden!");
        }
        catch (IOException e) {
            System.out.println("Probleme beim Dateizugriff!");
        }
        return dat;
    }

    public HashMap<String, String> lese_tag(StringIterator org) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringIterator iter = org.get_pos_behind("<");
        if (iter.nopos()) {
            return null;
        }
        StringIterator tagend = iter.get_pos_of(">");
        if (tagend.char_at(-1) == '/') {
            tagend.offset(-1);
        }
        StringIterator tmp = iter.get_pos_of_any(" >");
        String tagname = iter.trimmed_substr(tmp).toLowerCase();
        map.put("tagname", tagname);
        iter = tmp.move_behind_ws();
        while (iter.before(tagend)) {
            tmp = iter.get_pos_of("=");
            String param = iter.trimmed_substr(tmp).toLowerCase();
            tmp.move_behind("\"");
            iter = tmp.get_pos_of("\"");
            String value = tmp.trimmed_substr(iter);
            map.put(param, value);
            iter.offset(1).move_behind_ws();
        }
        org.assign(tagend.move_behind(">"));
        return map;
    }

    public int lese_exit(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("refid")) {
            throw new XmlError("refid fehlt in Raum, Zeile " + org.occurrences_till("\n"));
        }
        return Integer.parseInt(map.get("refid"));
    }

    public String lese_description(StringIterator org, HashMap<String, String> map) {
        StringIterator tagend = org.get_pos_of("</description>");
        String d = org.trimmed_substr(tagend);
        org.assign(tagend.move_behind(">"));
        return d;
    }

    public Trigger lese_trigger(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("cmd")) {
            throw new XmlError("cmd fehlt in Trigger, Zeile " + org.occurrences_till("\n"));
        }
        int cmd = Integer.parseInt(map.get("cmd"));
        int o1 = -1;
        int o2 = -1;
        if (map.containsKey("first")) {
            o1 = Integer.parseInt(map.get("first"));
        }
        if (map.containsKey("second")) {
            o2 = Integer.parseInt(map.get("second"));
        }
        return new Trigger(cmd, o1, o2);
    }

    public Bedingung lese_bedingung_objectinstate(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("state")) {
            throw new XmlError("state fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        int state = Integer.parseInt(map.get("state"));
        return new BedingungObjektHatZustand(this.spiel, object, state);
    }

    public Bedingung lese_bedingung_objectnotinstate(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("state")) {
            throw new XmlError("state fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        int state = Integer.parseInt(map.get("state"));
        return new BedingungObjektHatNichtZustand(this.spiel, object, state);
    }

    public Bedingung lese_bedingung_objectnotininventory(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new BedingungObjektNichtInInventar(this.spiel, object);
    }

    public Bedingung lese_bedingung_objectininventory(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new BedingungObjektInInventar(this.spiel, object);
    }

    public Bedingung lese_bedingung_objectincurrentroom(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new BedingungObjektInAktRaum(this.spiel, object);
    }

    public Bedingung lese_bedingung_objectvisible(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new BedingungObjektIstSichtbar(this.spiel, object);
    }

    public Bedingung lese_bedingung_objectnotvisible(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new BedingungObjektIstNichtSichtbar(this.spiel, object);
    }

    public Bedingung lese_bedingung_objectatoriginalpos(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new BedingungObjektAnOrgPos(this.spiel, object);
    }

    public Bedingung lese_bedingung(StringIterator org, HashMap<String, String> map) {
        String type;
        if (!map.containsKey("type")) {
            throw new XmlError("type fehlt in Bedingung, Zeile " + org.occurrences_till("\n"));
        }
        switch (type = map.get("type")) {
            case "objectinstate": {
                return this.lese_bedingung_objectinstate(org, map);
            }
            case "objectnotinstate": {
                return this.lese_bedingung_objectnotinstate(org, map);
            }
            case "objectininventory": {
                return this.lese_bedingung_objectininventory(org, map);
            }
            case "objectnotininventory": {
                return this.lese_bedingung_objectnotininventory(org, map);
            }
            case "objectincurrentroom": {
                return this.lese_bedingung_objectincurrentroom(org, map);
            }
            case "objectvisible": {
                return this.lese_bedingung_objectvisible(org, map);
            }
            case "objectnotvisible": {
                return this.lese_bedingung_objectnotvisible(org, map);
            }
            case "objectatoriginalpos": {
                return this.lese_bedingung_objectatoriginalpos(org, map);
            }
        }
        throw new XmlError("Unbekannter type " + type + " in Bedingung, Zeile " + org.occurrences_till("\n"));
    }

    public Aktion lese_aktion_changeroom(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("room")) {
            throw new XmlError("room fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        int room = Integer.parseInt(map.get("room"));
        return new AktionRaumwechsel(this.spiel, room);
    }

    public Aktion lese_aktion_objectsetvisible(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new AktionObjektSetSichtbar(this.spiel, object, true);
    }

    public Aktion lese_aktion_objectsetinvisible(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        return new AktionObjektSetSichtbar(this.spiel, object, false);
    }

    public Aktion lese_aktion_objectnewstate(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("state")) {
            throw new XmlError("state fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        int state = Integer.parseInt(map.get("state"));
        return new AktionObjektNeuerZustand(this.spiel, object, state);
    }

    public Aktion lese_aktion_objectstatecountto(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("state")) {
            throw new XmlError("state fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        int state = Integer.parseInt(map.get("state"));
        return new AktionObjektZustandCountTo(this.spiel, object, state);
    }

    public Aktion lese_aktion_objectnewpos(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("object")) {
            throw new XmlError("object fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("pos")) {
            throw new XmlError("pos fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        int object = Integer.parseInt(map.get("object"));
        int pos = Integer.parseInt(map.get("pos"));
        return new AktionObjektNeuePos(this.spiel, object, pos);
    }

    public Aktion lese_aktion_text(StringIterator org, HashMap<String, String> map) {
        StringIterator tagend = org.get_pos_of("</actiontext>");
        AktionTextausgabe a = new AktionTextausgabe(this.spiel, org.trimmed_substr(tagend));
        org.assign(tagend.move_behind(">"));
        return a;
    }

    public Aktion lese_aktion(StringIterator org, HashMap<String, String> map) {
        String type;
        if (!map.containsKey("type")) {
            throw new XmlError("type fehlt in Aktion, Zeile " + org.occurrences_till("\n"));
        }
        switch (type = map.get("type")) {
            case "changeroom": {
                return this.lese_aktion_changeroom(org, map);
            }
            case "objectsetvisible": {
                return this.lese_aktion_objectsetvisible(org, map);
            }
            case "objectsetinvisible": {
                return this.lese_aktion_objectsetinvisible(org, map);
            }
            case "objectnewstate": {
                return this.lese_aktion_objectnewstate(org, map);
            }
            case "objectstatecountto": {
                return this.lese_aktion_objectstatecountto(org, map);
            }
            case "objectnewpos": {
                return this.lese_aktion_objectnewpos(org, map);
            }
            case "gamelost": {
                return new AktionSpielVerloren(this.spiel);
            }
            case "gamewon": {
                return new AktionSpielGewonnen(this.spiel);
            }
        }
        throw new XmlError("Unbekannter type " + type + " in Aktion, Zeile " + org.occurrences_till("\n"));
    }

    public Raum lese_raum(StringIterator org, HashMap<String, String> map) {
        int id = -1;
        String name = "";
        if (!map.containsKey("id")) {
            throw new XmlError("id fehlt in Raum, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("name")) {
            throw new XmlError("name fehlt in Raum, Zeile " + org.occurrences_till("\n"));
        }
        id = Integer.parseInt(map.get("id"));
        name = map.get("name");
        Raum raum = new Raum(this.spiel, id, name);
        StringIterator tagend = org.get_pos_of("</room>").offset(-1).move_back_before_ws();
        while (org.before(tagend)) {
            HashMap<String, String> tag = this.lese_tag(org);
            switch (tag.get("tagname")) {
                case "exit": {
                    raum.add_ausgang(this.lese_exit(org, tag));
                    break;
                }
                case "description": {
                    raum.set_beschreibung(this.lese_description(org, tag));
                    break;
                }
                default: {
                    throw new XmlError("Unbekanntes Tag " + tag.get("tagname") + " in Zeile " + org.occurrences_till("\n"));
                }
            }
        }
        org.assign(tagend.offset(1).move_behind_ws().move_behind(">"));
        return raum;
    }

    public void lese_start(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("room")) {
            throw new XmlError("room fehlt in Start, Zeile " + org.occurrences_till("\n"));
        }
        this.spiel.wechsel_raum(Integer.parseInt(map.get("room")));
        StringIterator tagend = org.get_pos_of("</start>");
        while (org.before(tagend)) {
            HashMap<String, String> tag = this.lese_tag(org);
            switch (tag.get("tagname")) {
                case "description": {
                    this.spiel.set_starttext(this.lese_description(org, tag));
                }
            }
        }
        org.assign(tagend.move_behind(">"));
    }

    public Gegenstand lese_item(StringIterator org, HashMap<String, String> map) {
        String name;
        if (!map.containsKey("id")) {
            throw new XmlError("id fehlt in Item, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("name")) {
            throw new XmlError("name fehlt in Item, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("position")) {
            throw new XmlError("position fehlt in Item, Zeile " + org.occurrences_till("\n"));
        }
        int id = Integer.parseInt(map.get("id"));
        int position = Integer.parseInt(map.get("position"));
        String lname = name = map.get("name");
        if (map.containsKey("lname")) {
            lname = map.get("lname");
        }
        int zustand = 0;
        if (map.containsKey("state")) {
            zustand = Integer.parseInt(map.get("state"));
        }
        boolean fest = false;
        if (map.containsKey("fixed")) {
            fest = true;
        }
        boolean sichtbar = false;
        if (map.containsKey("visible")) {
            sichtbar = true;
        }
        boolean ablegbar = false;
        if (map.containsKey("dropable")) {
            ablegbar = true;
        }
        return this.spiel.erzeuge_gegenstand(id, name, lname, fest, ablegbar, sichtbar, position, zustand);
    }

    public Spielregel lese_regel(StringIterator org, HashMap<String, String> map) {
        boolean symmetrie = false;
        boolean single_action = false;
        if (map.containsKey("symmetry")) {
            symmetrie = true;
        }
        if (map.containsKey("oneaction")) {
            single_action = true;
        }
        Spielregel regel = new Spielregel(this.spiel, symmetrie, single_action);
        while (!org.nopos()) {
            HashMap<String, String> tag = this.lese_tag(org);
            switch (tag.get("tagname")) {
                case "/rule": {
                    return regel;
                }
                case "trigger": {
                    regel.add_trigger(this.lese_trigger(org, tag));
                    break;
                }
                case "condition": {
                    regel.add_bedingung(this.lese_bedingung(org, tag));
                    break;
                }
                case "conditionor": {
                    regel.add_bedingung(this.lese_bedingungor(org, tag));
                    break;
                }
                case "action": {
                    regel.add_aktion(this.lese_aktion(org, tag));
                    break;
                }
                case "actiontext": {
                    regel.add_aktion(this.lese_aktion_text(org, tag));
                    break;
                }
                case "actionconditioned": {
                    regel.add_aktion(this.lese_aktionbedingt(org, tag));
                    break;
                }
                default: {
                    throw new XmlError("Unbekanntes Tag " + tag.get("tagname") + " in Zeile " + org.occurrences_till("\n"));
                }
            }
        }
        return regel;
    }

    public AktionBedingt lese_aktionbedingt(StringIterator org, HashMap<String, String> map) {
        boolean single_action = false;
        if (map.containsKey("oneaction")) {
            single_action = true;
        }
        AktionBedingt aktion = new AktionBedingt(this.spiel, single_action);
        while (!org.nopos()) {
            HashMap<String, String> tag = this.lese_tag(org);
            switch (tag.get("tagname")) {
                case "/actionconditioned": {
                    return aktion;
                }
                case "condition": {
                    aktion.add_bedingung(this.lese_bedingung(org, tag));
                    break;
                }
                case "conditionor": {
                    aktion.add_bedingung(this.lese_bedingungor(org, tag));
                    break;
                }
                case "action": {
                    aktion.add_aktion(this.lese_aktion(org, tag));
                    break;
                }
                case "actionconditioned": {
                    aktion.add_aktion(this.lese_aktionbedingt(org, tag));
                    break;
                }
                case "actiontext": {
                    aktion.add_aktion(this.lese_aktion_text(org, tag));
                    break;
                }
                default: {
                    throw new XmlError("Unbekanntes Tag " + tag.get("tagname") + " in Zeile " + org.occurrences_till("\n"));
                }
            }
        }
        return aktion;
    }

    public BedingungOder lese_bedingungor(StringIterator org, HashMap<String, String> map) {
        BedingungOder bedingung = new BedingungOder(this.spiel);
        while (!org.nopos()) {
            HashMap<String, String> tag = this.lese_tag(org);
            switch (tag.get("tagname")) {
                case "/conditionor": {
                    return bedingung;
                }
                case "condition": {
                    bedingung.add_bedingung(this.lese_bedingung(org, tag));
                    break;
                }
                default: {
                    throw new XmlError("Unbekanntes Tag " + tag.get("tagname") + " in Zeile " + org.occurrences_till("\n"));
                }
            }
        }
        return bedingung;
    }

    public boolean lese_game(StringIterator org, HashMap<String, String> map) {
        if (!map.containsKey("engine")) {
            throw new XmlError("engine fehlt in game, Zeile " + org.occurrences_till("\n"));
        }
        if (!map.containsKey("title")) {
            throw new XmlError("title fehlt in game, Zeile " + org.occurrences_till("\n"));
        }
        if (Integer.parseInt(map.get("engine")) > 1) {
            throw new XmlError("Spielversion wird von der Engine nicht unterst\u00fctzt!");
        }
        this.spiel.set_titel(map.get("title"));
        while (!org.nopos()) {
            HashMap<String, String> tag = this.lese_tag(org);
            switch (tag.get("tagname")) {
                case "/game": {
                    return true;
                }
                case "room": {
                    this.spiel.get_raeume().add_objekt(this.lese_raum(org, tag));
                    break;
                }
                case "item": {
                    this.spiel.get_gegenstaende().add_objekt(this.lese_item(org, tag));
                    break;
                }
                case "rule": {
                    this.spiel.get_regeln().add_regel(this.lese_regel(org, tag));
                    break;
                }
                case "start": {
                    this.lese_start(org, tag);
                    break;
                }
                default: {
                    throw new XmlError("Unbekanntes Tag " + tag.get("tagname") + " in Zeile " + org.occurrences_till("\n"));
                }
            }
        }
        return true;
    }

    public boolean lade_struktur(String xmldatei) {
        String dat = "";
        InputStreamReader stream = new InputStreamReader(XmlLoader.class.getResourceAsStream(xmldatei), StandardCharsets.ISO_8859_1);
        Scanner scanner = new Scanner(stream);
        scanner.useDelimiter("\\A");
        dat = scanner.next();
        scanner.close();
        if (dat == null) {
            return false;
        }
        StringIterator iter = new StringIterator(dat);
        HashMap<String, String> tag = this.lese_tag(iter);
        if (tag.get("tagname").equals("game")) {
            return this.lese_game(iter, tag);
        }
        throw new XmlError("Nicht unterst\u00fctzter Hauptcontainer " + tag.get("tagname") + " in Zeile " + iter.occurrences_till("\n"));
    }

    public static class XmlError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private String error;

        public XmlError(String e) {
            this.error = e;
        }

        public String get_error() {
            return this.error;
        }
    }
}

