/*
 * Decompiled with CFR 0.152.
 */
package textengine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringIterator {
    public static final int NO_POS = -1;
    private String txt;
    private int pos;

    public StringIterator(String s) {
        this.txt = s;
        this.pos = 0;
    }

    public StringIterator(String s, int p) {
        this.txt = s;
        this.pos = p;
    }

    public StringIterator(StringIterator i, int p) {
        this.txt = i.txt;
        this.pos = p;
    }

    public StringIterator assign(StringIterator i) {
        this.txt = i.txt;
        this.pos = i.pos;
        return this;
    }

    public StringIterator clone() {
        return new StringIterator(this.txt, this.pos);
    }

    public String get_string() {
        return this.txt;
    }

    public long get_pos() {
        return this.pos;
    }

    public boolean equals(StringIterator i) {
        return this.pos == i.pos && this.txt == i.txt;
    }

    public boolean before(StringIterator i) {
        return this.pos < i.pos && this.txt == i.txt;
    }

    public boolean after(StringIterator i) {
        return this.pos > i.pos && this.txt == i.txt;
    }

    public boolean before_or_at(StringIterator i) {
        return this.pos <= i.pos && this.txt == i.txt;
    }

    public boolean after_or_at(StringIterator i) {
        return this.pos >= i.pos && this.txt == i.txt;
    }

    public boolean nopos() {
        return this.pos == -1;
    }

    public StringIterator move_to(String s) {
        this.pos = this.txt.indexOf(s, this.pos);
        return this;
    }

    public StringIterator move_to_any_of(String s) {
        Pattern pattern = Pattern.compile("[" + s + "]");
        Matcher matcher = pattern.matcher(this.txt);
        this.pos = matcher.find(this.pos) ? matcher.start() : -1;
        return this;
    }

    public StringIterator move_behind(String s) {
        this.pos = this.txt.indexOf(s, this.pos);
        if (this.pos != -1) {
            this.pos += s.length();
        }
        return this;
    }

    public StringIterator move_behind_ws() {
        while (Character.isWhitespace(this.txt.charAt(this.pos))) {
            ++this.pos;
        }
        return this;
    }

    public StringIterator move_back_before_ws() {
        while (Character.isWhitespace(this.txt.charAt(this.pos))) {
            --this.pos;
        }
        return this;
    }

    public StringIterator move_to_ws() {
        while (!Character.isWhitespace(this.txt.charAt(this.pos))) {
            ++this.pos;
        }
        return this;
    }

    public StringIterator get_pos_of(String s) {
        return this.clone().move_to(s);
    }

    public StringIterator get_pos_of_any(String s) {
        return this.clone().move_to_any_of(s);
    }

    public StringIterator get_pos_behind(String s) {
        return this.clone().move_behind(s);
    }

    public StringIterator get_pos_of_ws() {
        return this.clone().move_to_ws();
    }

    public StringIterator get_pos_behind_ws() {
        return this.clone().move_behind_ws();
    }

    public StringIterator get_pos_back_before_ws() {
        return this.clone().move_back_before_ws();
    }

    public StringIterator offset(int offset) {
        this.pos += offset;
        if (this.pos < 0 || this.pos >= this.txt.length()) {
            this.pos = -1;
        }
        return this;
    }

    public StringIterator get_offset(int offset) {
        return this.clone().offset(offset);
    }

    public String substr_till(String s) {
        StringIterator iter = this.get_pos_of(s);
        return this.substr(iter);
    }

    public String trimmed_substr_till(String s) {
        StringIterator iter = this.get_pos_of(s);
        return this.trimmed_substr(iter);
    }

    public String substr_till_ws() {
        StringIterator iter = this.get_pos_of_ws();
        return this.substr(iter);
    }

    public String trimmed_substr_till_ws() {
        StringIterator iter = this.get_pos_of_ws();
        return this.trimmed_substr(iter);
    }

    public String substr(StringIterator i2) {
        if (this.txt != i2.txt) {
            return null;
        }
        return this.txt.substring(this.pos, i2.pos);
    }

    public String trimmed_substr(StringIterator i2) {
        if (this.txt != i2.txt) {
            return null;
        }
        return this.txt.substring(this.pos, i2.pos).trim();
    }

    public char char_at() {
        return this.txt.charAt(this.pos);
    }

    public char char_at(int offset) {
        return this.txt.charAt(this.pos + offset);
    }

    public int occurrences_till(String s) {
        if (this.pos == -1) {
            return 0;
        }
        int anz = 0;
        int cpos = 0;
        cpos = this.txt.indexOf(s);
        while (cpos != 1 && cpos < this.pos) {
            cpos = this.txt.indexOf(s, cpos + 1);
            ++anz;
        }
        return anz;
    }
}

