/*
 * Decompiled with CFR 0.152.
 */
package textengine;

import java.io.OutputStreamWriter;
import java.util.Vector;
import textengine.Aktion;
import textengine.Bedingung;
import textengine.Spiel;
import textengine.Spielobjekt;
import textengine.Trigger;
import textengine.XMLObjekt;

public class Spielregel
extends Spielobjekt
implements XMLObjekt {
    private Vector<Trigger> trigger = new Vector();
    private Vector<Bedingung> bedingungen = new Vector();
    private Vector<Aktion> aktionen = new Vector();
    boolean symmetrie;
    private boolean single_action;

    public Spielregel(Spiel spiel, int b, int o1, int o2, boolean sym, boolean single) {
        super(spiel);
        this.symmetrie = sym;
        this.single_action = single;
        this.add_trigger(b, o1, o2);
    }

    public Spielregel(Spiel spiel, boolean sym, boolean single) {
        super(spiel);
        this.symmetrie = sym;
        this.single_action = single;
    }

    public Spielregel(Spiel spiel, int b, int o1, int o2, boolean sym) {
        this(spiel, b, o1, o2, sym, false);
    }

    public Spielregel(Spiel spiel, int b, int o1, int o2) {
        this(spiel, b, o1, o2, false, false);
    }

    public Spielregel(Spiel spiel, int b, int o1) {
        this(spiel, b, o1, -1, false, false);
    }

    public Spielregel(Spiel spiel, int b) {
        this(spiel, b, -1, -1, false, false);
    }

    private boolean ist_trigger(int c, int o1, int o2) {
        int iter = 0;
        while (iter < this.trigger.size()) {
            if (this.trigger.elementAt(iter).ist_trigger(c, o1, o2, this.symmetrie)) {
                return true;
            }
            ++iter;
        }
        return false;
    }

    private boolean pruefe_bedingungen() {
        int iter = 0;
        while (iter < this.bedingungen.size()) {
            if (!this.bedingungen.elementAt(iter).pruefen()) {
                return false;
            }
            ++iter;
        }
        return true;
    }

    private boolean fuehre_aktionen_aus() {
        boolean erfolg = false;
        int iter = 0;
        while (iter < this.aktionen.size()) {
            if (this.aktionen.elementAt(iter).ausfuehren()) {
                if (this.single_action) {
                    return true;
                }
                erfolg = true;
            }
            ++iter;
        }
        return erfolg;
    }

    public void add_bedingung(Bedingung b) {
        this.bedingungen.add(b);
    }

    public void add_aktion(Aktion b) {
        this.aktionen.add(b);
    }

    public void add_trigger(int b, int o1, int o2) {
        this.trigger.add(new Trigger(b, o1, o2));
    }

    public void add_trigger(Trigger t) {
        this.trigger.add(t);
    }

    public boolean ausfuehren(int b, int o1, int o2) {
        if (!this.ist_trigger(b, o1, o2)) {
            return false;
        }
        if (!this.pruefe_bedingungen()) {
            return false;
        }
        return this.fuehre_aktionen_aus();
    }

    @Override
    public void xml_out(OutputStreamWriter ostr) {
    }
}

