/*
 * Decompiled with CFR 0.152.
 */
package textengine;

import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;
import textengine.Befehl;
import textengine.Befehlsliste;
import textengine.Gegenstand;
import textengine.Gegenstandsliste;
import textengine.Raum;
import textengine.Raumliste;
import textengine.Spielregelliste;
import textengine.Utilities;
import textengine.ZerlegteAnweisung;

public class Spiel {
    public static final int ENGINE = 1;
    public static final boolean FDEBUG = false;
    public static final boolean IS_DOS = true;
    private int line_width = 70;
    public static final int CMD_ENDE = 1;
    public static final int CMD_HILFE = 2;
    public static final int CMD_UMSCHAUEN = 3;
    public static final int CMD_HOTSPOT = 4;
    public static final int CMD_RICHTUNGEN = 5;
    public static final int CMD_SPEICHERN = 6;
    public static final int CMD_LADEN = 7;
    public static final int CMD_INVENTAR = 8;
    public static final int CMD_GEHE = 9;
    public static final int CMD_BESCHREIBEN = 10;
    public static final int CMD_NIMM = 11;
    public static final int CMD_UNTERSUCHE = 12;
    public static final int CMD_KOMBINIERE = 13;
    public static final int CMD_VERWENDE = 14;
    public static final int CMD_OEFFNE = 15;
    public static final int CMD_SCHLIESSE = 16;
    public static final int CMD_BENUTZE = 17;
    public static final int CMD_DRUECKE = 18;
    public static final int CMD_ZIEHE = 19;
    private String starttext = "";
    private String titel = "";
    Befehlsliste befehle = new Befehlsliste(this);
    Raumliste raeume = new Raumliste(this);
    Gegenstandsliste gegenstaende = new Gegenstandsliste(this);
    Spielregelliste spielregeln = new Spielregelliste();
    int neuer_raum;
    Raum akt_raum;
    private boolean spiel_laeuft;
    private boolean spiel_gewonnen;

    public boolean is_running() {
        return this.spiel_laeuft;
    }

    public boolean is_won() {
        return this.spiel_gewonnen;
    }

    public Spiel(int zeichenbreite) {
        this.line_width = zeichenbreite;
        this.spiel_laeuft = true;
        this.spiel_gewonnen = false;
        this.erzeuge_befehle();
    }

    public int get_line_width() {
        return this.line_width;
    }

    public void spielen() {
        this.textausgabe(String.valueOf(this.fmt(this.starttext)) + "\n");
        while (this.spiel_laeuft) {
            this.textausgabe("\n");
            this.raum_beschreiben();
            this.textausgabe("\nWas willst du machen (\"h\" f\u00fcr Hilfe): ");
            String eingabe = this.eingabe();
            Utilities.clear_screen();
            ZerlegteAnweisung anw = new ZerlegteAnweisung(this, eingabe);
            anw.schreibe_feedback();
            if (!anw.gueltig) continue;
            if (!this.pruefe_auf_internen_befehl(anw) && !this.spielregeln.ausfuehren(anw.cmd_id, anw.obj1_id, anw.obj2_id)) {
                this.schreibe_allgemein_neg();
            }
            this.textausgabe("\n");
        }
        if (!this.spiel_gewonnen) {
            this.textausgabe("\nBeim naechsten Mal klappt es bestimmt besser.\n\n");
        } else {
            this.textausgabe("\nDu hast es tatsaechlich geschafft. Herzlichen Glueckwunsch.\n\n");
        }
    }

    public String get_starttext() {
        return this.starttext;
    }

    protected void set_starttext(String s) {
        this.starttext = s;
    }

    public String get_titel() {
        return this.titel;
    }

    protected void set_titel(String t) {
        this.titel = t;
    }

    public void wechsel_raum(int id) {
        this.neuer_raum = id;
        this.akt_raum = this.raeume.get_raum_by_id(this.neuer_raum);
    }

    public Befehlsliste get_befehle() {
        return this.befehle;
    }

    public Gegenstandsliste get_gegenstaende() {
        return this.gegenstaende;
    }

    public Spielregelliste get_regeln() {
        return this.spielregeln;
    }

    public Raumliste get_raeume() {
        return this.raeume;
    }

    public Raum get_akt_raum() {
        return this.akt_raum;
    }

    public void spiel_beenden(boolean won) {
        this.spiel_laeuft = false;
        this.spiel_gewonnen = won;
    }

    public void spiel_fortfuehren() {
        this.spiel_laeuft = true;
        this.spiel_gewonnen = false;
    }

    private void raum_beschreiben() {
        this.textausgabe(String.valueOf(this.akt_raum.get_name()) + "\n" + Utilities.separator_line(this.akt_raum.get_name().length() + 2) + "\n");
        String beschr = this.akt_raum.get_beschreibung();
        if (!beschr.isEmpty()) {
            this.textausgabe(String.valueOf(beschr) + "\n");
        }
        this.spielregeln.ausfuehren(10, -1, -1);
        this.akt_raum.schreibe_verfuegbare_richtungen_kurz();
        this.textausgabe("\n");
        this.gegenstaende.schreibe_hotspots_kurz();
        this.textausgabe("\n");
    }

    private void erzeuge_befehle() {
        this.befehle.add_objekt(new Befehl(this, 8, "inventar", 0, "inventar", "Listet deine Habseligkeiten auf"));
        this.befehle.add_objekt(new Befehl(this, 12, "untersuche", 1, "untersuche X", "Untersucht den Gegenstand genauer"));
        this.befehle.add_objekt(new Befehl(this, 11, "nimm", 1, "nimm X", "Nimmt den Gegenstand in dein Inventar auf"));
        this.befehle.add_objekt(new Befehl(this, 9, "gehe", 1, "gehe X", "Du gehst in die angegebene Richtung"));
        this.befehle.add_objekt(new Befehl(this, 17, "benutze", 1, "benutze X", "Du benutzt den Gegenstand X"));
        this.befehle.add_objekt(new Befehl(this, 13, "verwende", 2, "verwende X + Y", "Verwendet/kombiniert/verkn\u00fcpft zwei Gegenstaende"));
        this.befehle.add_objekt(new Befehl(this, 15, "\u00f6ffne", 1, "\u00f6ffne X", "\u00d6ffnet einen Gegenstand"));
        this.befehle.add_objekt(new Befehl(this, 16, "schlie\u00dfe", 1, "schlie\u00dfe X", "Schlie\u00dft einen Gegenstand"));
        this.befehle.add_objekt(new Befehl(this, 18, "dr\u00fccke", 1, "dr\u00fccke X", "Dr\u00fcckt einen Gegenstand"));
        this.befehle.add_objekt(new Befehl(this, 19, "ziehe", 1, "ziehe X", "Zieht oder verschiebt einen Gegenstand"));
        this.befehle.add_objekt(new Befehl(this, 6, "speichern", 1, "speichern NR", "Speichert den Spielstand unter der angegebenen Nummer"));
        this.befehle.add_objekt(new Befehl(this, 7, "laden", 1, "laden NR", "L\u00e4dt den Spielstand mit der angegebenen Nummer"));
        this.befehle.add_objekt(new Befehl(this, 2, "hilfe", 0, "hilfe", "Listet alle Befehle auf"));
        this.befehle.add_objekt(new Befehl(this, 1, "ende", 0, "ende", "Beendet das Spiel"));
    }

    public void schreibe_zufallsreaktion(String[] txts, String bez) {
        int txt = Utilities.get_zufallszahl(0, txts.length - 1);
        String line = Utilities.start_capitalized(txts[txt].replaceAll("%", bez));
        this.textausgabe(String.valueOf(this.fmt(line)) + "\n");
    }

    protected void schreibe_untersuche_neg(String bez) {
        String[] txts = new String[]{"% bleibt %, auch wenn man genauer hinsieht.", "%, mehr nicht.", "Ja, das ist %.", "Auf den ersten Blick sieht es aus wie %. Auf den zweiten auch.", "Du gehst immer n\u00e4her ran und tats\u00e4chlich, es ist %.", "% sieht aus der N\u00e4he auch nicht anders aus.", "Bei genauerer Betrachtung siehst du... auch nicht mehr.", "Nichts au\u00dfergew\u00f6hnliches zu sehen.", "% wie alle anderen auch."};
        this.schreibe_zufallsreaktion(txts, bez);
    }

    protected void schreibe_nimm_neg(String bez) {
        String[] txts = new String[]{"Das Ding nehmen wir nicht auch noch mit.", "Nein, das lassen wir mal an Ort und Stelle.", "Es hat bestimmt einen Grund, dass % an dieser Stelle ist.", "Nein, nenn mir einen Grund, warum uns % helfen koennte.", "Das sollten wir dort nicht wegnehmen.", "% kommt uns nicht in die T\u00fcte.", "% ist das Letzte, was wir jetzt brauchen."};
        this.schreibe_zufallsreaktion(txts, bez);
    }

    protected void schreibe_nimm_pos(String bez) {
        String[] txts = new String[]{"Du hast jetzt einen Gegenstand mehr im Inventar.", "Und wieder etwas mehr zu tragen.", "Also, % macht sich wirklich gut in deiner Tasche.", "Ok, % passt gerade noch.", "%? Naja, wenigstens nicht so viel zu tragen."};
        this.schreibe_zufallsreaktion(txts, bez);
    }

    protected void schreibe_allgemein_neg() {
        String[] txts = new String[]{"Auf den ersten Blick eher sinnlos. Auf den zweiten auch.", "Das klappt nicht.", "Gute Idee, hat aber leider nichts gebracht.", "Das lassen wir besser.", "Du hattest schon bessere Ideen.", "Das bringt uns nicht weiter.", "Das bringt uns keinerlei Vorteil.", "Noch so ein Vorschlag und ich k\u00fcndige.", "Gib Bescheid, wenn dir was besseres einf\u00e4llt.", "Nein, das mache ich nicht.", "Ich weigere mich, das zu tun.", "Hatten wir das nicht schon probiert?", "Du willst das nicht wirklich machen, oder?", "Manche Dinge klappen auch beim x-ten Mal nicht."};
        this.schreibe_zufallsreaktion(txts, "");
    }

    private boolean pruefe_auf_internen_befehl(ZerlegteAnweisung anw) {
        if (anw.gueltig) {
            switch (anw.cmd_id) {
                case 1: {
                    this.spiel_laeuft = !this.bestaetige_spielabbruch();
                    return true;
                }
                case 2: {
                    this.befehle.schreibe_verfuegbare_befehle();
                    return true;
                }
                case 8: {
                    this.gegenstaende.schreibe_inventar();
                    return true;
                }
                case 6: {
                    if (this.gegenstaende.serialisieren(this, "savegame_" + anw.obj1_txt + ".dat")) {
                        this.textausgabe("\nSpiel unter " + anw.obj1_txt + " gespeichert.\n");
                    } else {
                        this.textausgabe("\nSpeichern fehlgeschlagen!\n");
                    }
                    return true;
                }
                case 7: {
                    if (this.gegenstaende.deserialisieren(this, "savegame_" + anw.obj1_txt + ".dat")) {
                        this.textausgabe("\nSpiel " + anw.obj1_txt + " geladen.\n");
                    } else {
                        this.textausgabe("\nLaden fehlgeschlagen!\n");
                    }
                    return true;
                }
                case 11: {
                    this.textausgabe("\n");
                    if (!this.spielregeln.ausfuehren(anw.cmd_id, anw.obj1_id, anw.obj2_id)) {
                        Gegenstand g = this.gegenstaende.get_gegenstand_by_id(anw.obj1_id);
                        if (!g.ist_fest()) {
                            if (g.in_inventar()) {
                                this.textausgabe(String.valueOf(Utilities.start_capitalized(g.get_bezeichnung())) + " haben wir doch bereits in der Tasche.\n");
                            } else {
                                g.set_akt_pos(0);
                                this.schreibe_nimm_pos(g.get_bezeichnung());
                            }
                        } else {
                            this.schreibe_nimm_neg(g.get_bezeichnung());
                        }
                    }
                    return true;
                }
                case 12: {
                    this.textausgabe("\n");
                    if (!this.spielregeln.ausfuehren(anw.cmd_id, anw.obj1_id, anw.obj2_id)) {
                        Gegenstand g = this.gegenstaende.get_gegenstand_by_id(anw.obj1_id);
                        this.schreibe_untersuche_neg(g.get_bezeichnung());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean bestaetige_spielabbruch() {
        this.textausgabe("\nWillst du wirklich das Spiel beenden? Dann schreib \"ja\":");
        return this.eingabe().trim().equalsIgnoreCase("ja");
    }

    public String fmt(String s) {
        return Utilities.text_layout(s, this.line_width);
    }

    public void textausgabe(String s) {
        System.out.print(s);
    }

    private String eingabe_dos() {
        Scanner scanner = null;
        try {
            scanner = new Scanner(new InputStreamReader(System.in, "cp850"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
        scanner.useDelimiter("\n");
        String inp = scanner.next();
        return inp;
    }

    private String eingabe_normal() {
        Scanner scanner = new Scanner(System.in);
        scanner.useDelimiter("\n");
        String inp = scanner.next();
        return inp;
    }

    public String eingabe() {
        return this.eingabe_dos();
    }

    public Gegenstand erzeuge_gegenstand(int id, String name, String bez, boolean fest, boolean ablegbar, boolean sichtbar, int pos, int zustand) {
        return new Gegenstand(this, id, name, bez, fest, ablegbar, sichtbar, pos, zustand);
    }
}

