/*
 * Decompiled with CFR 0.152.
 */
package textengine;

import java.io.OutputStreamWriter;
import java.util.Vector;
import textengine.Gegenstand;
import textengine.IdObjekt;
import textengine.Objektanalyzer;
import textengine.Spiel;
import textengine.Utilities;
import textengine.XMLObjekt;

public class Raum
extends IdObjekt
implements XMLObjekt {
    private String name;
    private String beschreibung;
    private Vector<Integer> ausgaenge = new Vector();

    @Override
    public void analyse() {
        Objektanalyzer.analyse(this);
    }

    public Raum(Spiel spiel, int id, String n, String beschr) {
        super(spiel, id);
        this.name = n;
        this.beschreibung = beschr;
    }

    public Raum(Spiel spiel, int id, String n) {
        this(spiel, id, n, "");
    }

    public Vector<Integer> get_verfuegbare_richtungen() {
        Vector<Integer> v = new Vector<Integer>();
        int iter = 0;
        while (iter < this.ausgaenge.size()) {
            Gegenstand ptr = this.get_spiel().get_gegenstaende().get_gegenstand_by_id(this.ausgaenge.elementAt(iter));
            if (ptr.ist_sichtbar()) {
                v.add(ptr.get_id());
            }
            ++iter;
        }
        return v;
    }

    public void schreibe_verfuegbare_richtungen_kurz() {
        StringBuffer out = new StringBuffer("Richtungen: ");
        int anz = 0;
        int iter = 0;
        while (iter < this.ausgaenge.size()) {
            Gegenstand ptr = this.get_spiel().get_gegenstaende().get_gegenstand_by_id(this.ausgaenge.elementAt(iter));
            if (ptr.ist_sichtbar()) {
                if (++anz != 1) {
                    out.append(", ");
                }
                out.append(Utilities.start_capitalized(ptr.get_name()));
            }
            ++iter;
        }
        this.get_spiel().textausgabe("\n" + this.get_spiel().fmt(out.toString()));
    }

    public int get_ausgangid_by_partial_name_match(String s) {
        int iter = 0;
        while (iter < this.ausgaenge.size()) {
            int id = this.ausgaenge.elementAt(iter);
            Gegenstand ptr = this.get_spiel().get_gegenstaende().get_gegenstand_by_id(id);
            if (ptr.ist_sichtbar() && ptr.partial_name_match(s)) {
                return id;
            }
            ++iter;
        }
        return -1;
    }

    @Override
    public void xml_out(OutputStreamWriter ostr) {
    }

    public String get_beschreibung() {
        return this.beschreibung;
    }

    public void set_beschreibung(String b) {
        this.beschreibung = b;
    }

    public String get_name() {
        return this.name;
    }

    public void add_ausgang(int id) {
        this.ausgaenge.add(id);
    }
}

