/*
 * Decompiled with CFR 0.152.
 */
package textengine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;
import textengine.BenObjektListe;
import textengine.Gegenstand;
import textengine.Spiel;
import textengine.Utilities;

public class Gegenstandsliste
extends BenObjektListe {
    public Gegenstandsliste(Spiel s) {
        super(s);
    }

    public Gegenstand get_gegenstand_by_id(int id) {
        return (Gegenstand)this.get_objekt_by_id(id);
    }

    public int get_gegenstandid_by_available_and_partial_name_match(String s) {
        int iter = 0;
        while (iter < this.objekte.size()) {
            Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
            if (ptr.ist_sichtbar() && (ptr.in_akt_raum() || ptr.in_inventar()) && ptr.partial_name_match(s)) {
                return ptr.get_id();
            }
            ++iter;
        }
        return -1;
    }

    public Vector<Integer> get_inventar() {
        Vector<Integer> v = new Vector<Integer>();
        int iter = 0;
        while (iter < this.objekte.size()) {
            Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
            if (ptr.ist_sichtbar() && ptr.in_inventar()) {
                v.add(ptr.get_id());
            }
            ++iter;
        }
        return v;
    }

    public void schreibe_inventar() {
        this.get_spiel().textausgabe("\nDu besitzt folgende Dinge:\n" + Utilities.separator_line(this.get_spiel().get_line_width()) + "\n");
        int anz = 0;
        int iter = 0;
        while (iter < this.objekte.size()) {
            Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
            if (ptr.ist_sichtbar() && ptr.in_inventar()) {
                String item = Utilities.start_capitalized(ptr.get_bezeichnung());
                this.get_spiel().textausgabe(item);
                if (anz++ % 2 == 0) {
                    int seps = this.get_spiel().get_line_width() / 2 - item.length();
                    int i = 0;
                    while (i < seps) {
                        this.get_spiel().textausgabe(" ");
                        ++i;
                    }
                } else {
                    this.get_spiel().textausgabe("\n");
                }
            }
            ++iter;
        }
        this.get_spiel().textausgabe("\n\n");
    }

    public void schreibe_gegenstandsliste() {
        this.get_spiel().textausgabe("\nGegenstandsliste:\n" + Utilities.separator_line(this.get_spiel().get_line_width()) + "\n");
        int anz = 0;
        int iter = 0;
        while (iter < this.objekte.size()) {
            Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
            String item = Utilities.start_capitalized(ptr.get_bezeichnung());
            item = String.valueOf(item) + " (" + ptr.get_id() + "," + ptr.get_akt_pos() + "," + ptr.get_zustand() + ")";
            this.get_spiel().textausgabe(item);
            if (anz++ % 2 == 0) {
                int seps = this.get_spiel().get_line_width() / 2 - item.length();
                int i = 0;
                while (i < seps) {
                    this.get_spiel().textausgabe(" ");
                    ++i;
                }
            } else {
                this.get_spiel().textausgabe("\n");
            }
            ++iter;
        }
        this.get_spiel().textausgabe("\n\n");
    }

    public Vector<Integer> get_hotspots() {
        Vector<Integer> v = new Vector<Integer>();
        int iter = 0;
        while (iter < this.objekte.size()) {
            Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
            if (ptr.ist_sichtbar() && ptr.in_akt_raum()) {
                v.add(ptr.get_id());
            }
            ++iter;
        }
        return v;
    }

    public void schreibe_hotspots_kurz() {
        StringBuffer out = new StringBuffer("Objekte: ");
        int anz = 0;
        int iter = 0;
        while (iter < this.objekte.size()) {
            Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
            if (ptr.ist_sichtbar() && ptr.in_akt_raum()) {
                if (++anz != 1) {
                    out.append(", ");
                }
                out.append(Utilities.start_capitalized(ptr.get_name()));
            }
            ++iter;
        }
        this.get_spiel().textausgabe("\n" + this.get_spiel().fmt(out.toString()));
    }

    public void schreibe_invisible_hotspots_kurz() {
        StringBuffer out = new StringBuffer("Unsichtbare Objekte: ");
        int anz = 0;
        int iter = 0;
        while (iter < this.objekte.size()) {
            Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
            if (!ptr.ist_sichtbar() && ptr.in_akt_raum()) {
                if (++anz != 1) {
                    out.append(", ");
                }
                out.append(Utilities.start_capitalized(ptr.get_name()));
                out.append(" (" + ptr.get_id() + "," + ptr.get_zustand() + ")");
            }
            ++iter;
        }
        this.get_spiel().textausgabe("\n" + this.get_spiel().fmt(out.toString()));
    }

    private int berechne_chk(String s, int v) {
        String lc = s.trim();
        int chk = 0;
        int i = 0;
        while (i < lc.length()) {
            chk += lc.charAt(i) * (i + v + 1);
            ++i;
        }
        return chk;
    }

    public boolean serialisieren(Spiel spiel, String datei) {
        String header = String.valueOf(this.objekte.size()) + "," + spiel.get_akt_raum().get_id();
        int chk = this.berechne_chk(header, 23);
        try {
            FileOutputStream fw = new FileOutputStream(datei);
            OutputStreamWriter ostr = new OutputStreamWriter(fw);
            ostr.write(String.valueOf(header) + "\r\n");
            int iter = 0;
            while (iter < this.objekte.size()) {
                Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
                ostr.write(String.valueOf(ptr.serialisieren()) + "\r\n");
                chk += this.berechne_chk(ptr.serialisieren(), iter);
                ++iter;
            }
            ostr.write(String.valueOf(chk) + "\r\n");
            ostr.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean deserialisieren(Spiel spiel, String datei) {
        Vector<String> lines;
        int raum;
        block7: {
            String inp;
            int ganz;
            int chk;
            BufferedReader br;
            block6: {
                FileInputStream fr = new FileInputStream(datei);
                InputStreamReader isr = new InputStreamReader(fr);
                br = new BufferedReader(isr);
                String header = br.readLine();
                chk = this.berechne_chk(header, 23);
                String[] headerdata = header.split(",");
                ganz = Integer.parseInt(headerdata[0]);
                raum = Integer.parseInt(headerdata[1]);
                if (ganz == this.objekte.size()) break block6;
                System.out.println("Fehler: Savegame einer anderen Spielversion!");
                return false;
            }
            lines = new Vector<String>();
            int i = 0;
            while (i < ganz) {
                inp = br.readLine();
                lines.add(inp);
                chk += this.berechne_chk(inp, i);
                ++i;
            }
            inp = br.readLine();
            br.close();
            if (Integer.parseInt(inp) == chk) break block7;
            System.out.println("\nDatei fehlerhaft!\n");
            return false;
        }
        try {
            int iter = 0;
            while (iter < this.objekte.size()) {
                Gegenstand ptr = (Gegenstand)this.objekte.elementAt(iter);
                ptr.deserialisieren((String)lines.elementAt(iter));
                ++iter;
            }
            spiel.wechsel_raum(raum);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void xml_out(OutputStreamWriter ostr) {
    }
}

