/*
 * Decompiled with CFR 0.152.
 */
package textengine;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import textengine.Aktion;
import textengine.Bedingung;
import textengine.Spiel;

public class AktionBedingt
extends Aktion {
    private Vector<Bedingung> bedingungen = new Vector();
    private Vector<Aktion> aktionen = new Vector();
    private boolean single_action;

    public AktionBedingt(Spiel spiel) {
        super(spiel);
        this.single_action = false;
    }

    public AktionBedingt(Spiel spiel, boolean single) {
        super(spiel);
        this.single_action = single;
    }

    public void add_bedingung(Bedingung b) {
        this.bedingungen.add(b);
    }

    public void add_aktion(Aktion b) {
        this.aktionen.add(b);
    }

    @Override
    public boolean ausfuehren() {
        if (!this.pruefe_bedingungen()) {
            return false;
        }
        return this.fuehre_aktionen_aus();
    }

    private boolean pruefe_bedingungen() {
        int iter = 0;
        while (iter < this.bedingungen.size()) {
            if (!this.bedingungen.elementAt(iter).pruefen()) {
                return false;
            }
            ++iter;
        }
        return true;
    }

    private boolean fuehre_aktionen_aus() {
        boolean erfolg = false;
        int iter = 0;
        while (iter < this.aktionen.size()) {
            if (this.aktionen.elementAt(iter).ausfuehren()) {
                if (this.single_action) {
                    return true;
                }
                erfolg = true;
            }
            ++iter;
        }
        return erfolg;
    }

    @Override
    public void xml_out(OutputStreamWriter ostr) throws IOException {
        ostr.write("<actionconditioned>\n");
        int iter = 0;
        while (iter < this.bedingungen.size()) {
            this.bedingungen.elementAt(iter).xml_out(ostr);
            ++iter;
        }
        iter = 0;
        while (iter < this.aktionen.size()) {
            this.aktionen.elementAt(iter).xml_out(ostr);
            ++iter;
        }
        ostr.write("</actionconditioned>\n");
    }
}

