/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Befehlsbutton;
import gui.GuiSpiel;
import gui.Hotspotpanel;
import gui.Inventarpanel;
import gui.Richtungspanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;

public class Spielframe
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GuiSpiel spiel;
    private int breite = 970;
    private int hoehe = 670;
    private int befehl = -1;
    private int gegenstand1 = -1;
    private int gegenstand2 = -1;
    Vector<Integer> objekte = new Vector();
    private JLabel textbereich;
    private Richtungspanel rpanel;
    private Inventarpanel ipanel;
    private Hotspotpanel hpanel;
    private JMenu mSpiel = new JMenu("Spiel");
    private JMenuItem miSpeichern = new JMenuItem("Speichern unter");
    private JMenuItem miLaden = new JMenuItem("Laden");
    private JMenuItem miUeber = new JMenuItem("\u00dcber");

    public GuiSpiel get_spiel() {
        return this.spiel;
    }

    public Spielframe(GuiSpiel s) {
        super(s.get_titel());
        this.spiel = s;
        this.setDefaultCloseOperation(3);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = new Rectangle((dim.width - this.breite) / 2, (dim.height - this.hoehe) / 3, this.breite, this.hoehe);
        this.setBounds(bounds);
        JMenuBar mb = new JMenuBar();
        this.setJMenuBar(mb);
        mb.add(this.mSpiel);
        this.mSpiel.add(this.miSpeichern);
        this.mSpiel.add(this.miLaden);
        this.mSpiel.add(new JSeparator());
        this.mSpiel.add(this.miUeber);
        this.miSpeichern.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.miSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Spielframe.this.speichern();
            }
        });
        this.miLaden.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.miLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Spielframe.this.laden();
            }
        });
        this.miUeber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Spielframe.this.ueber();
            }
        });
        JPanel p1 = new JPanel(new FlowLayout());
        p1.setBorder(new EtchedBorder());
        p1.add(new JLabel("Befehle:"));
        Befehlsbutton bb = new Befehlsbutton(this, "Benutze", 17);
        p1.add(bb);
        bb = new Befehlsbutton(this, "Nimm", 11);
        p1.add(bb);
        bb = new Befehlsbutton(this, "Verwende", 13);
        p1.add(bb);
        bb = new Befehlsbutton(this, "\u00d6ffne", 15);
        p1.add(bb);
        bb = new Befehlsbutton(this, "Schlie\u00dfe", 16);
        p1.add(bb);
        bb = new Befehlsbutton(this, "Dr\u00fccke", 18);
        p1.add(bb);
        bb = new Befehlsbutton(this, "Ziehe", 19);
        p1.add(bb);
        this.add((Component)p1, "North");
        this.textbereich = new JLabel("test\ntest");
        this.textbereich.setFont(this.textbereich.getFont().deriveFont(14.0f));
        this.textbereich.setBorder(new EtchedBorder());
        this.add((Component)this.textbereich, "Center");
        this.spiel.textausgabe(String.valueOf(this.spiel.fmt(this.spiel.get_starttext())) + "\n\n");
        this.spiel.raum_beschreiben();
        this.textbereich.setText("<html>" + this.spiel.get_text().replaceAll("\n", "<br />") + "</html>");
        this.spiel.clear_text();
        this.rpanel = new Richtungspanel(this);
        this.add((Component)this.rpanel, "South");
        this.rpanel.erzeuge_richtungen();
        this.ipanel = new Inventarpanel(this);
        this.add((Component)new JScrollPane(this.ipanel), "East");
        this.ipanel.erzeuge_buttons();
        this.hpanel = new Hotspotpanel(this);
        this.add((Component)new JScrollPane(this.hpanel), "West");
        this.hpanel.erzeuge_buttons();
    }

    public void spielen() {
        this.setVisible(true);
    }

    private void ueber() {
        JOptionPane.showMessageDialog(this, "Swing-Port der Textadventure-Engine von Andr\u00e9 Willms\nJava-Version der orginalen C++-Engine.", "Textadventure-Engine", 1);
    }

    private void speichern() {
        if (!this.spiel.is_running()) {
            return;
        }
        String txt = JOptionPane.showInputDialog("Bitte Namen des zu speichernden Spielstandes angeben.");
        if (txt != null) {
            this.spiel.get_gegenstaende().serialisieren(this.spiel, "savegame_" + txt + ".dat");
        }
    }

    private void laden() {
        String txt = JOptionPane.showInputDialog("Bitte Namen des zu ladenden Spielstandes angeben.");
        if (txt != null && this.spiel.get_gegenstaende().deserialisieren(this.spiel, "savegame_" + txt + ".dat")) {
            this.layout_aktualisieren();
            this.spiel.spiel_fortfuehren();
        }
    }

    public void add_befehl(int cmd) {
        if (!this.spiel.is_running()) {
            return;
        }
        this.befehl = cmd;
        this.gegenstand2 = -1;
        this.gegenstand1 = -1;
    }

    public void add_objekt(int o) {
        if (!this.spiel.is_running()) {
            return;
        }
        if (this.befehl == -1) {
            this.befehl = 12;
        }
        if (this.gegenstand1 == -1) {
            this.gegenstand1 = o;
        } else {
            this.gegenstand2 = o;
        }
        int objanz = this.spiel.get_befehle().get_befehl_by_id(this.befehl).get_benoetigte_objekt_anz();
        if (objanz == 1 && this.gegenstand1 != -1 || objanz == 2 && this.gegenstand2 != -1) {
            this.befehl_ausfuehren(this.befehl, this.gegenstand1, this.gegenstand2);
        }
    }

    private void layout_aktualisieren() {
        this.gegenstand2 = -1;
        this.gegenstand1 = -1;
        this.befehl = -1;
        this.spiel.clear_text();
        this.spiel.raum_beschreiben();
        this.rpanel.erzeuge_richtungen();
        this.ipanel.erzeuge_buttons();
        this.hpanel.erzeuge_buttons();
        this.textbereich.setText("<html>" + this.spiel.get_text().replaceAll("\n", "<br />") + "</html>");
    }

    private void befehl_ausfuehren(int cmd, int o1, int o2) {
        this.spiel.clear_text();
        this.spiel.befehl_ausfuehren(cmd, o1, o2);
        this.spiel.textausgabe("\n\n");
        this.gegenstand2 = -1;
        this.gegenstand1 = -1;
        this.befehl = -1;
        if (this.spiel.is_running()) {
            this.spiel.raum_beschreiben();
            this.rpanel.erzeuge_richtungen();
            this.ipanel.erzeuge_buttons();
            this.hpanel.erzeuge_buttons();
            this.textbereich.setText("<html>" + this.spiel.get_text().replaceAll("\n", "<br />") + "</html>");
        } else {
            this.rpanel.clear_panel();
            this.ipanel.clear_panel_keep_header();
            this.hpanel.clear_panel_keep_header();
            this.spiel.textausgabe("\n\nBeim n\u00e4chsten Mal klappt es bestimmt besser!");
            this.textbereich.setText("<html>" + this.spiel.get_text().replaceAll("\n", "<br />") + "</html>");
            if (this.spiel.is_won()) {
                JOptionPane.showMessageDialog(this, "Wahnsinn!\nDu hast es tats\u00e4chlich geschafft. Herzlichen Gl\u00fcckwunsch.", "Spiel gewonnen!", 1);
            }
        }
    }
}

